/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.CORBA;

import com.ooc.CORBA.Context;
import com.ooc.CORBA.Delegate;
import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.LocalObject;
import com.ooc.CORBA.TypeCode;
import com.ooc.OB.Assert;
import com.ooc.OB.CodeConverterBase;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.LocalCodeConverter;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.TypeCodeFactory;
import com.ooc.OB.ValueWriter;
import com.ooc.OCI.Buffer;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.ValueBaseHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public final class OutputStream
extends org.omg.CORBA_2_3.portable.OutputStream {
    private ORBInstance orbInstance_;
    public Buffer buf_;
    private CodeConverters codeConverters_;
    private boolean oldGIOP_;
    private int charConversionType_;
    private ValueWriter valueWriter_;
    private int alignNext_;
    private java.lang.Object invocationContext_;

    private int writeGap() {
        this.addCapacity(4, 4);
        int n = this.buf_.pos_;
        this.buf_.pos_ += 4;
        return n;
    }

    private void writeLength(int n) {
        int n2 = this.buf_.pos_ - (n + 4);
        this.buf_.data_[n++] = (byte)(n2 >>> 24);
        this.buf_.data_[n++] = (byte)(n2 >>> 16);
        this.buf_.data_[n++] = (byte)(n2 >>> 8);
        this.buf_.data_[n] = (byte)n2;
    }

    public void writeTypeCodeImpl(org.omg.CORBA.TypeCode typeCode, Hashtable hashtable) {
        TypeCode typeCode2 = (TypeCode)typeCode;
        if (typeCode2.recId_ != null) {
            Assert.assert(typeCode2.recType_ != null);
            this.writeTypeCodeImpl(typeCode2.recType_, hashtable);
            return;
        }
        Integer n = (Integer)hashtable.get(typeCode2);
        if (n != null) {
            this.write_long(-1);
            int n2 = n - this.buf_.pos_;
            this.write_long(n2);
            return;
        }
        this.write_ulong(typeCode2.kind().value());
        Integer n3 = new Integer(this.buf_.pos_ - 4);
        try {
            switch (typeCode2.kind().value()) {
                case 28: {
                    hashtable.put(typeCode2, n3);
                    this.write_ushort(typeCode2.fixed_digits());
                    this.write_short(typeCode2.fixed_scale());
                    return;
                }
                case 14: {
                    hashtable.put(typeCode2, n3);
                    int n4 = this.writeGap();
                    this._OB_writeEndian();
                    this.write_string(typeCode2.id());
                    this.write_string(typeCode2.name());
                    this.writeLength(n4);
                    return;
                }
                case 15: 
                case 22: {
                    hashtable.put(typeCode2, n3);
                    int n5 = this.writeGap();
                    this._OB_writeEndian();
                    this.write_string(typeCode2.id());
                    this.write_string(typeCode2.name());
                    this.write_ulong(typeCode2.member_count());
                    int n6 = 0;
                    while (n6 < typeCode2.member_count()) {
                        this.write_string(typeCode2.member_name(n6));
                        this.writeTypeCodeImpl(typeCode2.member_type(n6), hashtable);
                        ++n6;
                    }
                    this.writeLength(n5);
                    return;
                }
                case 16: {
                    hashtable.put(typeCode2, n3);
                    int n7 = this.writeGap();
                    this._OB_writeEndian();
                    this.write_string(typeCode2.id());
                    this.write_string(typeCode2.name());
                    org.omg.CORBA.TypeCode typeCode3 = typeCode2.discriminator_type();
                    this.writeTypeCodeImpl(typeCode3, hashtable);
                    int n8 = typeCode2.default_index();
                    this.write_long(n8);
                    this.write_ulong(typeCode2.member_count());
                    int n9 = 0;
                    while (n9 < typeCode2.member_count()) {
                        if (n9 == n8) {
                            TypeCode typeCode4 = ((TypeCode)typeCode3)._OB_getOrigType();
                            switch (typeCode4.kind().value()) {
                                case 2: {
                                    this.write_short((short)0);
                                    break;
                                }
                                case 4: {
                                    this.write_ushort((short)0);
                                    break;
                                }
                                case 3: {
                                    this.write_long(0);
                                    break;
                                }
                                case 5: {
                                    this.write_ulong(0);
                                    break;
                                }
                                case 23: {
                                    this.write_longlong(0L);
                                    break;
                                }
                                case 24: {
                                    this.write_ulonglong(0L);
                                    break;
                                }
                                case 8: {
                                    this.write_boolean(false);
                                    break;
                                }
                                case 9: {
                                    this.write_char('\u0000');
                                    break;
                                }
                                case 17: {
                                    this.write_ulong(0);
                                    break;
                                }
                                default: {
                                    Assert.assert(false);
                                    break;
                                }
                            }
                        } else {
                            typeCode2.member_label(n9).write_value(this);
                        }
                        this.write_string(typeCode2.member_name(n9));
                        this.writeTypeCodeImpl(typeCode2.member_type(n9), hashtable);
                        ++n9;
                    }
                    this.writeLength(n7);
                    return;
                }
                case 17: {
                    hashtable.put(typeCode2, n3);
                    int n10 = this.writeGap();
                    this._OB_writeEndian();
                    this.write_string(typeCode2.id());
                    this.write_string(typeCode2.name());
                    this.write_ulong(typeCode2.member_count());
                    int n11 = 0;
                    while (n11 < typeCode2.member_count()) {
                        this.write_string(typeCode2.member_name(n11));
                        ++n11;
                    }
                    this.writeLength(n10);
                    return;
                }
                case 18: 
                case 27: {
                    this.write_ulong(typeCode2.length());
                    return;
                }
                case 19: 
                case 20: {
                    hashtable.put(typeCode2, n3);
                    int n12 = this.writeGap();
                    this._OB_writeEndian();
                    this.writeTypeCodeImpl(typeCode2.content_type(), hashtable);
                    this.write_ulong(typeCode2.length());
                    this.writeLength(n12);
                    return;
                }
                case 21: {
                    hashtable.put(typeCode2, n3);
                    int n13 = this.writeGap();
                    this._OB_writeEndian();
                    this.write_string(typeCode2.id());
                    this.write_string(typeCode2.name());
                    this.writeTypeCodeImpl(typeCode2.content_type(), hashtable);
                    this.writeLength(n13);
                    return;
                }
                case 29: {
                    hashtable.put(typeCode2, n3);
                    org.omg.CORBA.TypeCode typeCode5 = typeCode2.concrete_base_type();
                    if (typeCode5 == null) {
                        typeCode5 = TypeCodeFactory.createPrimitiveTC(TCKind.tk_null);
                    }
                    int n14 = this.writeGap();
                    this._OB_writeEndian();
                    this.write_string(typeCode2.id());
                    this.write_string(typeCode2.name());
                    this.write_short(typeCode2.type_modifier());
                    this.writeTypeCodeImpl(typeCode5, hashtable);
                    this.write_ulong(typeCode2.member_count());
                    int n15 = 0;
                    while (n15 < typeCode2.member_count()) {
                        this.write_string(typeCode2.member_name(n15));
                        this.writeTypeCodeImpl(typeCode2.member_type(n15), hashtable);
                        this.write_short(typeCode2.member_visibility(n15));
                        ++n15;
                    }
                    this.writeLength(n14);
                    return;
                }
                case 30: {
                    hashtable.put(typeCode2, n3);
                    int n16 = this.writeGap();
                    this._OB_writeEndian();
                    this.write_string(typeCode2.id());
                    this.write_string(typeCode2.name());
                    this.writeTypeCodeImpl(typeCode2.content_type(), hashtable);
                    this.writeLength(n16);
                    return;
                }
                case 32: {
                    hashtable.put(typeCode2, n3);
                    int n17 = this.writeGap();
                    this._OB_writeEndian();
                    this.write_string(typeCode2.id());
                    this.write_string(typeCode2.name());
                    this.writeLength(n17);
                    return;
                }
                case 31: {
                    hashtable.put(typeCode2, n3);
                    int n18 = this.writeGap();
                    this._OB_writeEndian();
                    this.write_string(typeCode2.id());
                    this.write_string(typeCode2.name());
                    this.writeLength(n18);
                    return;
                }
                default: {
                    Assert.assert(false);
                    return;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    return;
                }
            }
        }
        catch (BadKind badKind) {
            Assert.assert(false);
            return;
        }
        catch (Bounds bounds) {
            Assert.assert(false);
            return;
        }
    }

    private void checkBeginChunk() {
        Assert.assert(this.valueWriter_ != null);
        this.valueWriter_.checkBeginChunk();
    }

    private ValueWriter valueWriter() {
        if (this.valueWriter_ == null) {
            this.valueWriter_ = new ValueWriter(this);
        }
        return this.valueWriter_;
    }

    private void addCapacity(int n) {
        int n2;
        if (this.alignNext_ > 0) {
            int n3 = this.alignNext_;
            this.alignNext_ = 0;
            this.addCapacity(n, n3);
            return;
        }
        if (this.buf_.pos_ == this.buf_.len_ && this.valueWriter_ != null) {
            this.checkBeginChunk();
        }
        if ((n2 = this.buf_.pos_ + n) > this.buf_.len_) {
            this.buf_.realloc(n2);
        }
    }

    private void addCapacity(int n, int n2) {
        Assert.assert(n2 > 0);
        if (this.buf_.pos_ == this.buf_.len_ && this.valueWriter_ != null) {
            this.checkBeginChunk();
        }
        if (this.alignNext_ > 0) {
            n2 = this.alignNext_ > n2 ? this.alignNext_ : n2;
            this.alignNext_ = 0;
        }
        int n3 = this.buf_.pos_ + n2 - 1;
        n3 -= n3 % n2;
        this.buf_.pos_ = n3;
        int n4 = n3 + n;
        if (n4 > this.buf_.len_) {
            this.buf_.realloc(n4);
        }
    }

    public void write(int n) throws IOException {
        this.write_long(n);
    }

    public ORB orb() {
        if (this.orbInstance_ != null) {
            return this.orbInstance_.getORB();
        }
        return null;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        Buffer buffer = new Buffer(this.buf_.len_);
        if (this.buf_.len_ > 0) {
            System.arraycopy(this.buf_.data_, 0, buffer.data_, 0, this.buf_.len_);
        }
        InputStream inputStream = new InputStream(buffer, 0, false, this.codeConverters_, this.oldGIOP_);
        inputStream._OB_ORBInstance(this.orbInstance_);
        return inputStream;
    }

    public void write_boolean(boolean bl) {
        this.addCapacity(1);
        this.buf_.data_[this.buf_.pos_++] = bl ? (byte)1 : 0;
    }

    public void write_char(char c) {
        if (c > '\u00ff') {
            throw new DATA_CONVERSION("char value exceeds 255: " + c);
        }
        this.addCapacity(1);
        if (c != '\u0000' && this.charConversionType_ != 0) {
            CodeConverterBase codeConverterBase = this.codeConverters_.outputCharConverter;
            char c2 = this.charConversionType_ == 1 ? codeConverterBase.convertCharFrom(c) : (this.charConversionType_ == 2 ? codeConverterBase.convertCharTo(c) : codeConverterBase.convertCharBoth(c));
            this.buf_.data_[this.buf_.pos_++] = (byte)c2;
            return;
        }
        this.buf_.data_[this.buf_.pos_++] = (byte)c;
    }

    public void write_wchar(char c) {
        CodeConverterBase codeConverterBase = this.codeConverters_.wcharConverter;
        if (codeConverterBase == null) {
            throw new INV_OBJREF("wchar type not supported object");
        }
        char c2 = codeConverterBase.convert_wchar_to(c);
        if (this.oldGIOP_) {
            if (codeConverterBase.getTo().max_bytes <= 2) {
                this.write_ushort((short)c2);
                return;
            }
            this.write_ulong(c2);
            return;
        }
        int n = codeConverterBase.count_wchar(c2);
        this.write_octet((byte)n);
        this.addCapacity(n);
        codeConverterBase.write_wchar(this, c2);
        this.buf_.pos_ += n;
    }

    public void write_octet(byte by) {
        this.addCapacity(1);
        this.buf_.data_[this.buf_.pos_++] = by;
    }

    public void write_short(short s) {
        this.addCapacity(2, 2);
        this.buf_.data_[this.buf_.pos_++] = (byte)(s >>> 8);
        this.buf_.data_[this.buf_.pos_++] = (byte)s;
    }

    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_long(int n) {
        this.addCapacity(4, 4);
        this.buf_.data_[this.buf_.pos_++] = (byte)(n >>> 24);
        this.buf_.data_[this.buf_.pos_++] = (byte)(n >>> 16);
        this.buf_.data_[this.buf_.pos_++] = (byte)(n >>> 8);
        this.buf_.data_[this.buf_.pos_++] = (byte)n;
    }

    public void write_ulong(int n) {
        this.write_long(n);
    }

    public void write_longlong(long l) {
        this.addCapacity(8, 8);
        this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 56);
        this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 48);
        this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 40);
        this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 32);
        this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 24);
        this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 16);
        this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 8);
        this.buf_.data_[this.buf_.pos_++] = (byte)l;
    }

    public void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_string(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length + 1;
        this.write_ulong(n);
        this.addCapacity(n);
        if (this.charConversionType_ == 0) {
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] > '\u00ff') {
                    throw new DATA_CONVERSION("char value exceeds 255: " + cArray[n2]);
                }
                this.buf_.data_[this.buf_.pos_++] = (byte)cArray[n2];
                ++n2;
            }
        } else if (this.charConversionType_ == 1) {
            CodeConverterBase codeConverterBase = this.codeConverters_.outputCharConverter;
            int n3 = 0;
            while (n3 < cArray.length) {
                if (cArray[n3] > '\u00ff') {
                    throw new DATA_CONVERSION("char value exceeds 255: " + cArray[n3]);
                }
                this.buf_.data_[this.buf_.pos_++] = (byte)codeConverterBase.convertCharFrom(cArray[n3]);
                ++n3;
            }
        } else if (this.charConversionType_ == 2) {
            CodeConverterBase codeConverterBase = this.codeConverters_.outputCharConverter;
            int n4 = 0;
            while (n4 < cArray.length) {
                if (cArray[n4] > '\u00ff') {
                    throw new DATA_CONVERSION("char value exceeds 255: " + cArray[n4]);
                }
                this.buf_.data_[this.buf_.pos_++] = (byte)codeConverterBase.convertCharTo(cArray[n4]);
                ++n4;
            }
        } else {
            CodeConverterBase codeConverterBase = this.codeConverters_.outputCharConverter;
            int n5 = 0;
            while (n5 < cArray.length) {
                if (cArray[n5] > '\u00ff') {
                    throw new DATA_CONVERSION("char value exceeds 255: " + cArray[n5]);
                }
                this.buf_.data_[this.buf_.pos_++] = (byte)codeConverterBase.convertCharBoth(cArray[n5]);
                ++n5;
            }
        }
        this.buf_.data_[this.buf_.pos_++] = 0;
    }

    public void write_wstring(String string) {
        char c;
        char c2;
        CodeConverterBase codeConverterBase = this.codeConverters_.wcharConverter;
        if (codeConverterBase == null) {
            throw new INV_OBJREF("wstring type not supported by object");
        }
        char c3 = string.length();
        short s = codeConverterBase.getTo().max_bytes;
        if (this.oldGIOP_) {
            this.write_ulong(c3 + 1);
        } else {
            c2 = '\u0000';
            c = '\u0000';
            while (c < c3) {
                c2 += codeConverterBase.count_wchar(string.charAt(c));
                ++c;
            }
            this.write_ulong(c2);
        }
        c2 = '\u0000';
        while (c2 < c3) {
            c = codeConverterBase.convert_wchar_to(string.charAt(c2));
            if (this.oldGIOP_) {
                if (s <= 2) {
                    this.write_ushort((short)c);
                } else {
                    this.write_ulong(c);
                }
            } else {
                int n = codeConverterBase.count_wchar(c);
                this.addCapacity(n);
                codeConverterBase.write_wchar(this, c);
                this.buf_.pos_ += n;
            }
            ++c2;
        }
        if (this.oldGIOP_) {
            if (s <= 2) {
                this.write_ushort((short)0);
                return;
            }
            this.write_ulong(0);
        }
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (n2 > 0) {
            this.addCapacity(n2);
            int n3 = n;
            while (n3 < n + n2) {
                this.buf_.data_[this.buf_.pos_++] = blArray[n3] ? (byte)1 : 0;
                ++n3;
            }
        }
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        if (n2 > 0) {
            this.addCapacity(n2);
            if (this.charConversionType_ == 0) {
                int n3 = n;
                while (n3 < n + n2) {
                    if (cArray[n3] > '\u00ff') {
                        throw new DATA_CONVERSION("char value exceeds 255: " + cArray[n3]);
                    }
                    this.buf_.data_[this.buf_.pos_++] = (byte)cArray[n3];
                    ++n3;
                }
                return;
            }
            if (this.charConversionType_ == 1) {
                CodeConverterBase codeConverterBase = this.codeConverters_.outputCharConverter;
                int n4 = n;
                while (n4 < n + n2) {
                    if (cArray[n4] > '\u00ff') {
                        throw new DATA_CONVERSION("char value exceeds 255: " + cArray[n4]);
                    }
                    this.buf_.data_[this.buf_.pos_++] = (byte)codeConverterBase.convertCharFrom(cArray[n4]);
                    ++n4;
                }
                return;
            }
            if (this.charConversionType_ == 2) {
                CodeConverterBase codeConverterBase = this.codeConverters_.outputCharConverter;
                int n5 = n;
                while (n5 < n + n2) {
                    if (cArray[n5] > '\u00ff') {
                        throw new DATA_CONVERSION("char value exceeds 255: " + cArray[n5]);
                    }
                    this.buf_.data_[this.buf_.pos_++] = (byte)codeConverterBase.convertCharTo(cArray[n5]);
                    ++n5;
                }
                return;
            }
            CodeConverterBase codeConverterBase = this.codeConverters_.outputCharConverter;
            int n6 = n;
            while (n6 < n + n2) {
                if (cArray[n6] > '\u00ff') {
                    throw new DATA_CONVERSION("char value exceeds 255: " + cArray[n6]);
                }
                this.buf_.data_[this.buf_.pos_++] = (byte)codeConverterBase.convertCharBoth(cArray[n6]);
                ++n6;
            }
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.write_wchar(cArray[n3]);
            ++n3;
        }
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        if (n2 > 0) {
            this.addCapacity(n2);
            System.arraycopy(byArray, n, this.buf_.data_, this.buf_.pos_, n2);
            this.buf_.pos_ += n2;
        }
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        if (n2 > 0) {
            this.addCapacity(n2 * 2, 2);
            int n3 = n;
            while (n3 < n + n2) {
                this.buf_.data_[this.buf_.pos_++] = (byte)(sArray[n3] >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)sArray[n3];
                ++n3;
            }
        }
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        if (n2 > 0) {
            this.addCapacity(n2 * 4, 4);
            int n3 = n;
            while (n3 < n + n2) {
                this.buf_.data_[this.buf_.pos_++] = (byte)(nArray[n3] >>> 24);
                this.buf_.data_[this.buf_.pos_++] = (byte)(nArray[n3] >>> 16);
                this.buf_.data_[this.buf_.pos_++] = (byte)(nArray[n3] >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)nArray[n3];
                ++n3;
            }
        }
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        if (n2 > 0) {
            this.addCapacity(n2 * 8, 8);
            int n3 = n;
            while (n3 < n + n2) {
                this.buf_.data_[this.buf_.pos_++] = (byte)(lArray[n3] >>> 56);
                this.buf_.data_[this.buf_.pos_++] = (byte)(lArray[n3] >>> 48);
                this.buf_.data_[this.buf_.pos_++] = (byte)(lArray[n3] >>> 40);
                this.buf_.data_[this.buf_.pos_++] = (byte)(lArray[n3] >>> 32);
                this.buf_.data_[this.buf_.pos_++] = (byte)(lArray[n3] >>> 24);
                this.buf_.data_[this.buf_.pos_++] = (byte)(lArray[n3] >>> 16);
                this.buf_.data_[this.buf_.pos_++] = (byte)(lArray[n3] >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)lArray[n3];
                ++n3;
            }
        }
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        if (n2 > 0) {
            this.addCapacity(n2 * 4, 4);
            int n3 = n;
            while (n3 < n + n2) {
                int n4 = Float.floatToIntBits(fArray[n3]);
                this.buf_.data_[this.buf_.pos_++] = (byte)(n4 >>> 24);
                this.buf_.data_[this.buf_.pos_++] = (byte)(n4 >>> 16);
                this.buf_.data_[this.buf_.pos_++] = (byte)(n4 >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)n4;
                ++n3;
            }
        }
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        if (n2 > 0) {
            this.addCapacity(n2 * 8, 8);
            int n3 = n;
            while (n3 < n + n2) {
                long l = Double.doubleToLongBits(dArray[n3]);
                this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 56);
                this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 48);
                this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 40);
                this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 32);
                this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 24);
                this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 16);
                this.buf_.data_[this.buf_.pos_++] = (byte)(l >>> 8);
                this.buf_.data_[this.buf_.pos_++] = (byte)l;
                ++n3;
            }
        }
    }

    public void write_Object(Object object) {
        if (object == null) {
            IOR iOR = new IOR();
            iOR.type_id = "";
            iOR.profiles = new TaggedProfile[0];
            IORHelper.write(this, iOR);
            return;
        }
        if (object instanceof LocalObject) {
            throw new MARSHAL(MinorCodes.describeMarshal(1330577447), 1330577447, CompletionStatus.COMPLETED_NO);
        }
        Delegate delegate = (Delegate)((ObjectImpl)object)._get_delegate();
        delegate._OB_marshalOrigIOR(this);
    }

    public void write_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_TYPECODE("TypeCode is nil");
        }
        Hashtable hashtable = new Hashtable(11);
        this.writeTypeCodeImpl(typeCode, hashtable);
    }

    public void write_any(Any any) {
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public void write_Context(org.omg.CORBA.Context context, ContextList contextList) {
        java.lang.Object object;
        int n = contextList.count();
        Vector vector = new Vector();
        Context context2 = (Context)context;
        int n2 = 0;
        while (n2 < n) {
            try {
                object = contextList.item(n2);
                context2._OB_getValues("", 0, (String)object, vector);
            }
            catch (org.omg.CORBA.Bounds bounds) {
                Assert.assert(false);
            }
            ++n2;
        }
        this.write_ulong(vector.size());
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.write_string((String)object.nextElement());
        }
    }

    public void write_Principal(Principal principal) {
        throw new NO_IMPLEMENT();
    }

    public void write_fixed(BigDecimal bigDecimal) {
        String string = bigDecimal.abs().toString();
        string = bigDecimal.signum() == -1 ? String.valueOf(string) + '=' : String.valueOf(string) + '<';
        String string2 = "";
        if (string.length() % 2 != 0) {
            string2 = "0";
        }
        string2 = String.valueOf(string2) + string;
        int n = string2.length();
        int n2 = 0;
        while (n2 < n - 1) {
            char c = string2.charAt(n2);
            char c2 = string2.charAt(n2 + 1);
            this.write_octet((byte)(c - 48 << 4 | c2 - 48));
            n2 += 2;
        }
    }

    public void write_value(Serializable serializable) {
        this.valueWriter().writeValue(serializable, null);
    }

    public void write_value(Serializable serializable, String string) {
        this.valueWriter().writeValue(serializable, string);
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.valueWriter().writeValue(serializable, null);
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        this.valueWriter().writeValueBox(serializable, null, boxedValueHelper);
    }

    public void write_abstract_interface(java.lang.Object object) {
        this.valueWriter().writeAbstractInterface(object);
    }

    public void write_value(Serializable serializable, org.omg.CORBA.TypeCode typeCode, BoxedValueHelper boxedValueHelper) {
        this.valueWriter().writeValueBox(serializable, typeCode, boxedValueHelper);
    }

    /*
     * Unable to fully structure code
     */
    public void write_InputStream(org.omg.CORBA.portable.InputStream var1_1, org.omg.CORBA.TypeCode var2_2) {
        var3_3 = (InputStream)var1_1;
        try {
            switch (var2_2.kind().value()) {
                case 2: 
                case 4: {
                    this.write_short(var3_3.read_short());
                    return;
                }
                case 3: 
                case 5: 
                case 6: 
                case 17: {
                    this.write_long(var3_3.read_long());
                    return;
                }
                case 7: 
                case 23: 
                case 24: {
                    this.write_longlong(var3_3.read_longlong());
                    return;
                }
                case 8: 
                case 10: {
                    this.write_octet(var3_3.read_octet());
                    return;
                }
                case 9: {
                    this.write_char(var3_3.read_char());
                    return;
                }
                case 26: {
                    this.write_wchar(var3_3.read_wchar());
                    return;
                }
                case 28: {
                    this.write_fixed(var3_3.read_fixed());
                    return;
                }
                case 11: {
                    var4_4 = var3_3.read_TypeCode();
                    this.write_TypeCode(var4_4);
                    this.write_InputStream(var3_3, var4_4);
                    return;
                }
                case 12: {
                    var4_5 = var3_3.read_ulong();
                    if (var4_5 == -1) {
                        throw new MARSHAL(MinorCodes.describeMarshal(1330577446), 1330577446, CompletionStatus.COMPLETED_NO);
                    }
                    this.write_ulong(var4_5);
                    switch (var4_5) {
                        case 28: {
                            this.write_ushort(var3_3.read_ushort());
                            this.write_short(var3_3.read_short());
                            return;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: {
                            var5_12 = var3_3.read_ulong();
                            this.write_ulong(var5_12);
                            this.addCapacity(var5_12);
                            var3_3.read_octet_array(this.buf_.data_, this.buf_.pos_, var5_12);
                            this.buf_.pos_ += var5_12;
                            return;
                        }
                        case 18: 
                        case 27: {
                            var5_13 = var3_3.read_ulong();
                            this.write_ulong(var5_13);
                            return;
                        }
                        default: {
                            throw new InternalError();
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: {
                            return;
                        }
                    }
                }
                case 13: {
                    this.write_Principal(var3_3.read_Principal());
                    return;
                }
                case 14: {
                    var4_6 = IORHelper.read(var3_3);
                    IORHelper.write(this, var4_6);
                    return;
                }
                case 15: {
                    var4_7 = 0;
                    while (var4_7 < var2_2.member_count()) {
                        this.write_InputStream(var3_3, var2_2.member_type(var4_7));
                        ++var4_7;
                    }
                    return;
                }
                case 22: {
                    this.write_string(var3_3.read_string());
                    var4_8 = 0;
                    while (var4_8 < var2_2.member_count()) {
                        this.write_InputStream(var3_3, var2_2.member_type(var4_8));
                        ++var4_8;
                    }
                    return;
                }
                case 16: {
                    var4_9 = var2_2.default_index();
                    var5_14 = -1;
                    var6_16 = ((TypeCode)var2_2.discriminator_type())._OB_getOrigType();
                    block30 : switch (var6_16.kind().value()) {
                        case 2: {
                            var7_25 = var3_3.read_short();
                            this.write_short(var7_25);
                            var8_37 = 0;
                            while (var8_37 < var2_2.member_count()) {
                                if (var8_37 != var4_9 && var7_25 == var2_2.member_label(var8_37).extract_short()) {
                                    var5_14 = var8_37;
                                    break block30;
                                }
                                ++var8_37;
                            }
                            break;
                        }
                        case 4: {
                            var7_26 = var3_3.read_ushort();
                            this.write_ushort(var7_26);
                            var8_38 = 0;
                            while (var8_38 < var2_2.member_count()) {
                                if (var8_38 != var4_9 && var7_26 == var2_2.member_label(var8_38).extract_ushort()) {
                                    var5_14 = var8_38;
                                    break block30;
                                }
                                ++var8_38;
                            }
                            break;
                        }
                        case 3: {
                            var7_27 = var3_3.read_long();
                            this.write_long(var7_27);
                            var8_39 = 0;
                            while (var8_39 < var2_2.member_count()) {
                                if (var8_39 != var4_9 && var7_27 == var2_2.member_label(var8_39).extract_long()) {
                                    var5_14 = var8_39;
                                    break block30;
                                }
                                ++var8_39;
                            }
                            break;
                        }
                        case 5: {
                            var7_28 = var3_3.read_ulong();
                            this.write_ulong(var7_28);
                            var8_40 = 0;
                            while (var8_40 < var2_2.member_count()) {
                                if (var8_40 != var4_9 && var7_28 == var2_2.member_label(var8_40).extract_ulong()) {
                                    var5_14 = var8_40;
                                    break block30;
                                }
                                ++var8_40;
                            }
                            break;
                        }
                        case 23: {
                            var7_29 = var3_3.read_longlong();
                            this.write_longlong(var7_29);
                            var9_44 = 0;
                            while (var9_44 < var2_2.member_count()) {
                                if (var9_44 != var4_9 && var7_29 == var2_2.member_label(var9_44).extract_longlong()) {
                                    var5_14 = var9_44;
                                    break block30;
                                }
                                ++var9_44;
                            }
                            break;
                        }
                        case 24: {
                            var7_30 = var3_3.read_ulonglong();
                            this.write_ulonglong(var7_30);
                            var9_45 = 0;
                            while (var9_45 < var2_2.member_count()) {
                                if (var9_45 != var4_9 && var7_30 == var2_2.member_label(var9_45).extract_ulonglong()) {
                                    var5_14 = var9_45;
                                    break block30;
                                }
                                ++var9_45;
                            }
                            break;
                        }
                        case 9: {
                            var7_31 = var3_3.read_char();
                            this.write_char(var7_31);
                            var8_41 = 0;
                            while (var8_41 < var2_2.member_count()) {
                                if (var8_41 != var4_9 && var7_31 == var2_2.member_label(var8_41).extract_char()) {
                                    var5_14 = var8_41;
                                    break block30;
                                }
                                ++var8_41;
                            }
                            break;
                        }
                        case 8: {
                            var7_32 = var3_3.read_boolean();
                            this.write_boolean(var7_32);
                            var8_42 = 0;
                            while (var8_42 < var2_2.member_count()) {
                                if (var8_42 != var4_9 && var7_32 == var2_2.member_label(var8_42).extract_boolean()) {
                                    var5_14 = var8_42;
                                    break block30;
                                }
                                ++var8_42;
                            }
                            break;
                        }
                        case 17: {
                            var7_33 = var3_3.read_long();
                            this.write_long(var7_33);
                            var8_43 = 0;
                            while (var8_43 < var2_2.member_count()) {
                                if (var8_43 != var4_9 && var7_33 == var2_2.member_label(var8_43).create_input_stream().read_long()) {
                                    var5_14 = var8_43;
                                    break block30;
                                }
                                ++var8_43;
                            }
                            break;
                        }
                        default: {
                            Assert.assert(false);
                        }
                    }
                    if (var5_14 >= 0) {
                        this.write_InputStream(var3_3, var2_2.member_type(var5_14));
                        return;
                    }
                    if (var4_9 >= 0) {
                        this.write_InputStream(var3_3, var2_2.member_type(var4_9));
                        return;
                    }
                    ** GOTO lbl288
                }
                case 18: {
                    this.write_string(var3_3.read_string());
                    return;
                }
                case 27: {
                    this.write_wstring(var3_3.read_wstring());
                    return;
                }
                case 19: 
                case 20: {
                    if (var2_2.kind().value() == 19) {
                        var4_10 = var3_3.read_ulong();
                        this.write_ulong(var4_10);
                    } else {
                        var4_10 = var2_2.length();
                    }
                    if (var4_10 <= 0) ** GOTO lbl288
                    var5_15 = ((TypeCode)var2_2.content_type())._OB_getOrigType();
                    switch (var5_15.kind().value()) {
                        case 2: 
                        case 4: 
                        case 26: {
                            if (var3_3.swap_) {
                                var6_17 = new short[var4_10];
                                var3_3.read_short_array(var6_17, 0, var4_10);
                                this.write_short_array(var6_17, 0, var4_10);
                                return;
                            }
                            this.write_short(var3_3.read_short());
                            var6_18 = 2 * (var4_10 - 1);
                            if (var6_18 > 0) {
                                this.addCapacity(var6_18);
                                var7_34 = var3_3._OB_buffer();
                                System.arraycopy(var7_34.data_, var7_34.pos_, this.buf_.data_, this.buf_.pos_, var6_18);
                                var7_34.pos_ += var6_18;
                                this.buf_.pos_ += var6_18;
                                return;
                            }
                            ** GOTO lbl288
                        }
                        case 3: 
                        case 5: 
                        case 6: {
                            if (var3_3.swap_) {
                                var6_19 = new int[var4_10];
                                var3_3.read_long_array(var6_19, 0, var4_10);
                                this.write_long_array(var6_19, 0, var4_10);
                                return;
                            }
                            this.write_long(var3_3.read_long());
                            var6_20 = 4 * (var4_10 - 1);
                            if (var6_20 > 0) {
                                this.addCapacity(var6_20);
                                var7_35 = var3_3._OB_buffer();
                                System.arraycopy(var7_35.data_, var7_35.pos_, this.buf_.data_, this.buf_.pos_, var6_20);
                                var7_35.pos_ += var6_20;
                                this.buf_.pos_ += var6_20;
                                return;
                            }
                            ** GOTO lbl288
                        }
                        case 7: 
                        case 23: 
                        case 24: {
                            if (var3_3.swap_) {
                                var6_21 = new long[var4_10];
                                var3_3.read_longlong_array(var6_21, 0, var4_10);
                                this.write_longlong_array(var6_21, 0, var4_10);
                                return;
                            }
                            this.write_longlong(var3_3.read_longlong());
                            var6_22 = 8 * (var4_10 - 1);
                            if (var6_22 > 0) {
                                this.addCapacity(var6_22);
                                var7_36 = var3_3._OB_buffer();
                                System.arraycopy(var7_36.data_, var7_36.pos_, this.buf_.data_, this.buf_.pos_, var6_22);
                                var7_36.pos_ += var6_22;
                                this.buf_.pos_ += var6_22;
                                return;
                            }
                            ** GOTO lbl288
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            this.addCapacity(var4_10);
                            var6_23 = var3_3._OB_buffer();
                            System.arraycopy(var6_23.data_, var6_23.pos_, this.buf_.data_, this.buf_.pos_, var4_10);
                            var6_23.pos_ += var4_10;
                            this.buf_.pos_ += var4_10;
                            return;
                        }
                        case 21: {
                            Assert.assert(false);
                        }
                        default: {
                            var6_24 = 0;
                            while (var6_24 < var4_10) {
                                this.write_InputStream(var3_3, var2_2.content_type());
                                ++var6_24;
                            }
                            return;
                        }
                        case 0: 
                        case 1: {
                            return;
                        }
                    }
                }
                case 21: {
                    this.write_InputStream(var3_3, var2_2.content_type());
                    return;
                }
                case 29: 
                case 30: {
                    var3_3._OB_remarshalValue(var2_2, this);
                    return;
                }
                case 32: {
                    var4_11 = var3_3.read_boolean();
                    this.write_boolean(var4_11);
                    if (var4_11) {
                        this.write_Object(var3_3.read_Object());
                        return;
                    }
                    var3_3._OB_remarshalValue(ValueBaseHelper.type(), this);
                    return;
                }
                default: {
                    Assert.assert(false);
lbl288:
                    // 6 sources

                    return;
                }
            }
        }
        catch (BadKind v0) {
            Assert.assert(false);
            return;
        }
        catch (Bounds v1) {
            Assert.assert(false);
        }
        {
            ** case 0:
            ** case 1:
        }
lbl295:
        // 2 sources

    }

    public OutputStream(Buffer buffer) {
        this(buffer, null, false);
    }

    public OutputStream(Buffer buffer, CodeConverters codeConverters) {
        this(buffer, codeConverters, false);
    }

    public OutputStream(Buffer buffer, CodeConverters codeConverters, boolean bl) {
        this.buf_ = buffer;
        if (codeConverters == null) {
            codeConverters = new CodeConverters();
            codeConverters.inputCharConverter = LocalCodeConverter.instanceChar();
            codeConverters.outputCharConverter = LocalCodeConverter.instanceChar();
            codeConverters.wcharConverter = LocalCodeConverter.instanceWchar();
            this._OB_codeConverters(codeConverters, bl);
            return;
        }
        this._OB_codeConverters(codeConverters, bl);
    }

    public void _OB_codeConverters(CodeConverters codeConverters, boolean bl) {
        this.codeConverters_ = new CodeConverters(codeConverters);
        this.oldGIOP_ = bl;
        this.charConversionType_ = this.codeConverters_.outputCharConverter.getConversionType();
    }

    public Buffer _OB_buffer() {
        return this.buf_;
    }

    public int _OB_pos() {
        return this.buf_.pos_;
    }

    public void _OB_pos(int n) {
        this.buf_.pos_ = n;
    }

    public void _OB_align(int n) {
        if (this.buf_.pos_ % n != 0) {
            this.addCapacity(0, n);
        }
    }

    public void _OB_alignNext(int n) {
        this.alignNext_ = n;
    }

    public void _OB_writeEndian() {
        this.write_boolean(false);
    }

    public void _OB_beginValue(int n, String[] stringArray, boolean bl) {
        this.valueWriter().beginValue(n, stringArray, bl);
    }

    public void _OB_endValue() {
        this.valueWriter().endValue();
    }

    public void _OB_ORBInstance(ORBInstance oRBInstance) {
        this.orbInstance_ = oRBInstance;
    }

    public ORBInstance _OB_ORBInstance() {
        return this.orbInstance_;
    }

    public void _OB_invocationContext(java.lang.Object object) {
        this.invocationContext_ = object;
    }

    public java.lang.Object _OB_invocationContext() {
        return this.invocationContext_;
    }
}

