/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.CORBA.OutputStreamHolder;
import com.ooc.OB.Assert;
import com.ooc.OB.Client;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.DowncallEmitter;
import com.ooc.OB.FailureException;
import com.ooc.OB.LocationForward;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OCI.ProfileInfo;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;

public class Downcall {
    protected ORBInstance orbInstance_;
    protected Client client_;
    protected DowncallEmitter emitter_;
    protected ProfileInfo profileInfo_;
    protected RefCountPolicyList policies_;
    protected int reqId_;
    protected String op_;
    protected boolean responseExpected_;
    protected OutputStream out_;
    protected InputStream in_;
    protected static final int DowncallStateUnsent = 0;
    protected static final int DowncallStatePending = 1;
    protected static final int DowncallStateNoException = 2;
    protected static final int DowncallStateUserException = 3;
    protected static final int DowncallStateSystemException = 4;
    protected static final int DowncallStateFailureException = 5;
    protected static final int DowncallStateForward = 6;
    protected static final int DowncallStateForwardPerm = 7;
    protected int state_;
    protected Object stateMonitor_;
    protected Exception ex_;
    protected String exId_;
    protected IOR forwardIOR_;
    protected Vector requestSCL_ = new Vector();
    protected Vector replySCL_ = new Vector();

    void checkForException() throws LocationForward, FailureException {
        switch (this.state_) {
            case 4: {
                Assert.assert(this.ex_ != null);
                throw (SystemException)this.ex_;
            }
            case 5: {
                Assert.assert(this.ex_ != null);
                throw new FailureException((SystemException)this.ex_);
            }
            case 6: {
                Assert.assert(this.forwardIOR_ != null);
                throw new LocationForward(this.forwardIOR_, false);
            }
            case 7: {
                Assert.assert(this.forwardIOR_ != null);
                throw new LocationForward(this.forwardIOR_, true);
            }
        }
    }

    protected final OutputStream preMarshalBase() throws LocationForward, FailureException {
        OutputStreamHolder outputStreamHolder = new OutputStreamHolder();
        this.emitter_ = this.client_.startDowncall(this, outputStreamHolder);
        this.out_ = outputStreamHolder.value;
        this.checkForException();
        return this.out_;
    }

    public Downcall(ORBInstance oRBInstance, Client client, ProfileInfo profileInfo, RefCountPolicyList refCountPolicyList, String string, boolean bl) {
        this.orbInstance_ = oRBInstance;
        this.client_ = client;
        this.profileInfo_ = profileInfo;
        this.policies_ = refCountPolicyList;
        this.op_ = string;
        this.responseExpected_ = bl;
        this.state_ = 0;
        this.stateMonitor_ = null;
        this.ex_ = null;
        this.reqId_ = this.client_.requestId();
    }

    public ORBInstance orbInstance() {
        return this.orbInstance_;
    }

    public Client client() {
        return this.client_;
    }

    public ProfileInfo profileInfo() {
        return this.profileInfo_;
    }

    public RefCountPolicyList policies() {
        return this.policies_;
    }

    public int requestId() {
        return this.reqId_;
    }

    public String operation() {
        return this.op_;
    }

    public boolean responseExpected() {
        return this.responseExpected_;
    }

    public OutputStream output() {
        return this.out_;
    }

    public InputStream input() {
        return this.in_;
    }

    public ServiceContext[] getRequestSCL() {
        Object[] objectArray = new ServiceContext[this.requestSCL_.size()];
        this.requestSCL_.copyInto(objectArray);
        return objectArray;
    }

    public void addToRequestSCL(ServiceContext serviceContext) {
        this.requestSCL_.addElement(serviceContext);
    }

    public void setReplySCL(ServiceContext[] serviceContextArray) {
        Assert.assert(this.replySCL_.size() == 0);
        this.replySCL_.setSize(serviceContextArray.length);
        int n = 0;
        while (n < serviceContextArray.length) {
            this.replySCL_.setElementAt(serviceContextArray[n], n);
            ++n;
        }
    }

    public OutputStream preMarshal() throws LocationForward, FailureException {
        return this.preMarshalBase();
    }

    public void marshalEx(SystemException systemException) throws LocationForward, FailureException {
        this.setFailureException(systemException);
        this.checkForException();
        Assert.assert(false);
    }

    public void postMarshal() throws LocationForward, FailureException {
    }

    public void request() throws LocationForward, FailureException {
        Assert.assert(this.responseExpected_);
        boolean bl = this.emitter_.sendReceive(this);
        Assert.assert(bl);
        this.checkForException();
    }

    public void oneway() throws LocationForward, FailureException {
        Assert.assert(!this.responseExpected_);
        if (this.policies_.syncScope == 1) {
            boolean bl = this.emitter_.send(this, true);
            Assert.assert(bl);
            this.checkForException();
            return;
        }
        boolean bl = this.emitter_.send(this, false);
        if (bl) {
            this.checkForException();
        }
    }

    public void deferred() throws LocationForward, FailureException {
        Assert.assert(this.responseExpected_);
        boolean bl = this.emitter_.send(this, true);
        if (bl) {
            this.checkForException();
        }
    }

    public void response() throws LocationForward, FailureException {
        Assert.assert(this.responseExpected_);
        boolean bl = this.emitter_.receive(this, true);
        Assert.assert(bl);
        this.checkForException();
    }

    public boolean poll() throws LocationForward, FailureException {
        Assert.assert(this.responseExpected_);
        boolean bl = this.emitter_.receive(this, false);
        if (bl) {
            this.checkForException();
            return this.state_ != 1;
        }
        return false;
    }

    public InputStream preUnmarshal() throws LocationForward, FailureException {
        return this.in_;
    }

    public void unmarshalEx(SystemException systemException) throws LocationForward, FailureException {
        this.setFailureException(systemException);
        this.checkForException();
        Assert.assert(false);
    }

    public void postUnmarshal() throws LocationForward, FailureException {
        if (this.state_ == 3 && this.ex_ == null && this.exId_ == null) {
            this.setSystemException(new UNKNOWN(MinorCodes.describeUnknown(1330446337), 1330446337, CompletionStatus.COMPLETED_YES));
        }
        this.checkForException();
    }

    public String unmarshalExceptionId() {
        Assert.assert(this.state_ == 3);
        int n = this.in_._OB_pos();
        String string = this.in_.read_string();
        this.in_._OB_pos(n);
        return string;
    }

    public boolean unsent() {
        return this.state_ == 0;
    }

    public boolean pending() {
        return this.state_ == 1;
    }

    public boolean noException() {
        return this.state_ == 2;
    }

    public boolean userException() {
        return this.state_ == 3;
    }

    public boolean failureException() {
        return this.state_ == 5;
    }

    private void setPendingImpl() {
        Assert.assert(this.responseExpected_);
        this.state_ = 1;
    }

    public void setPending() {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setPendingImpl();
                this.stateMonitor_.notify();
                return;
            }
        }
        this.setPendingImpl();
    }

    private void setNoExceptionImpl(InputStream inputStream) {
        this.state_ = 2;
        if (inputStream == null) {
            Assert.assert(!this.responseExpected_);
            return;
        }
        Assert.assert(this.responseExpected_);
        this.in_ = inputStream;
        this.in_._OB_ORBInstance(this.orbInstance_);
        CodeConverters codeConverters = this.client_.codeConverters();
        this.in_._OB_codeConverters(codeConverters, this.profileInfo_.major == 1 && this.profileInfo_.minor < 2);
    }

    public void setNoException(InputStream inputStream) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setNoExceptionImpl(inputStream);
                this.stateMonitor_.notify();
                return;
            }
        }
        this.setNoExceptionImpl(inputStream);
    }

    private void setUserExceptionImpl(InputStream inputStream) {
        Assert.assert(inputStream != null);
        Assert.assert(this.responseExpected_);
        this.state_ = 3;
        this.in_ = inputStream;
        this.in_._OB_ORBInstance(this.orbInstance_);
        CodeConverters codeConverters = this.client_.codeConverters();
        this.in_._OB_codeConverters(codeConverters, this.profileInfo_.major == 1 && this.profileInfo_.minor < 2);
    }

    public void setUserException(InputStream inputStream) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setUserExceptionImpl(inputStream);
                this.stateMonitor_.notify();
                return;
            }
        }
        this.setUserExceptionImpl(inputStream);
    }

    private void setUserExceptionImpl(UserException userException, String string) {
        Assert.assert(this.responseExpected_);
        Assert.assert(this.ex_ == null);
        this.state_ = 3;
        this.ex_ = userException;
    }

    public void setUserException(UserException userException, String string) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setUserExceptionImpl(userException, string);
                this.stateMonitor_.notify();
                return;
            }
        }
        this.setUserExceptionImpl(userException, string);
    }

    private void setUserExceptionImpl(UserException userException) {
        Assert.assert(this.responseExpected_);
        Assert.assert(this.ex_ == null);
        this.state_ = 3;
        this.ex_ = userException;
    }

    public void setUserException(UserException userException) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setUserExceptionImpl(userException);
                this.stateMonitor_.notify();
                return;
            }
        }
        this.setUserExceptionImpl(userException);
    }

    private void setUserExceptionImpl(String string) {
        Assert.assert(this.responseExpected_);
        Assert.assert(this.ex_ == null);
        this.state_ = 3;
        this.exId_ = string;
    }

    public void setUserException(String string) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setUserExceptionImpl(string);
                this.stateMonitor_.notify();
                return;
            }
        }
        this.setUserExceptionImpl(string);
    }

    private void setSystemExceptionImpl(SystemException systemException) {
        Assert.assert(this.responseExpected_);
        Assert.assert(this.ex_ == null);
        this.state_ = 4;
        this.ex_ = systemException;
    }

    public void setSystemException(SystemException systemException) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setSystemExceptionImpl(systemException);
                this.stateMonitor_.notify();
                return;
            }
        }
        this.setSystemExceptionImpl(systemException);
    }

    private void setFailureExceptionImpl(SystemException systemException) {
        Assert.assert(this.ex_ == null);
        this.state_ = 5;
        this.ex_ = systemException;
    }

    public void setFailureException(SystemException systemException) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setFailureExceptionImpl(systemException);
                this.stateMonitor_.notify();
                return;
            }
        }
        this.setFailureExceptionImpl(systemException);
    }

    private void setLocationForwardImpl(IOR iOR, boolean bl) {
        Assert.assert(this.responseExpected_);
        Assert.assert(this.forwardIOR_ == null);
        this.state_ = bl ? 7 : 6;
        this.forwardIOR_ = iOR;
    }

    public void setLocationForward(IOR iOR, boolean bl) {
        if (this.stateMonitor_ != null) {
            Object object = this.stateMonitor_;
            synchronized (object) {
                this.setLocationForwardImpl(iOR, bl);
                this.stateMonitor_.notify();
                return;
            }
        }
        this.setLocationForwardImpl(iOR, bl);
    }

    public void initStateMonitor() {
        Assert.assert(this.stateMonitor_ == null);
        this.stateMonitor_ = new Object();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitUntilSent(boolean bl) {
        int n = this.policies_.requestTimeout;
        if (!bl || bl && n == 0) {
            Thread.yield();
        }
        Assert.assert(this.stateMonitor_ != null);
        Object object = this.stateMonitor_;
        synchronized (object) {
            while (true) {
                if (this.state_ != 0) {
                    if (this.state_ != 1) return true;
                    return false;
                }
                if (!bl) {
                    return false;
                }
                try {
                    if (n < 0) {
                        this.stateMonitor_.wait();
                        continue;
                    }
                    int n2 = this.state_;
                    this.stateMonitor_.wait(n);
                    if (this.state_ != n2) continue;
                    throw new NO_RESPONSE("Timeout during send", 0, CompletionStatus.COMPLETED_NO);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitUntilCompleted(boolean bl) {
        int n = this.policies_.requestTimeout;
        if (!bl || bl && n == 0) {
            Thread.yield();
        }
        Assert.assert(this.stateMonitor_ != null);
        Object object = this.stateMonitor_;
        synchronized (object) {
            while (true) {
                if (this.state_ != 0 && this.state_ != 1) {
                    return true;
                }
                if (!bl) {
                    return false;
                }
                try {
                    if (n < 0) {
                        this.stateMonitor_.wait();
                        continue;
                    }
                    int n2 = this.state_;
                    this.stateMonitor_.wait(n);
                    if (this.state_ != n2) continue;
                    throw new NO_RESPONSE("Timeout during receive", 0, CompletionStatus.COMPLETED_MAYBE);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

