/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.Any;
import com.ooc.OB.Logger;
import com.ooc.OCI.Param;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.StringSeqHelper;

public final class IIOPConfig {
    private Properties props_;
    private Logger logger_;
    private Vector params_;

    private Param findParam(String string) {
        Param param;
        int n = 0;
        while (n < this.params_.size()) {
            param = (Param)this.params_.elementAt(n);
            if (param.name.equals(string)) {
                return param;
            }
            ++n;
        }
        param = new Param(string, new Any());
        this.params_.addElement(param);
        return param;
    }

    private void parseHost(String string) {
        String string2 = this.props_.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
            int n = stringTokenizer.countTokens();
            if (n == 0) {
                String string3 = String.valueOf(string) + ": no hosts specified";
                this.logger_.error(string3);
                throw new INITIALIZE(string3);
            }
            String[] stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
            Param param = this.findParam("host");
            StringSeqHelper.insert(param.value, stringArray);
        }
    }

    private void parsePort(String string) {
        String string2 = this.props_.getProperty(string);
        if (string2 != null) {
            int n = Integer.parseInt(string2);
            if (n < 1 || n > 65535) {
                String string3 = String.valueOf(string) + ": port must be between 1 and 65535";
                this.logger_.error(string3);
                throw new INITIALIZE(string3);
            }
            short s = n >= 32768 ? (short)(n - 65535 - 1) : (short)n;
            Param param = this.findParam("port");
            param.value.insert_ushort(s);
        }
    }

    private void parseBacklog(String string) {
        String string2 = this.props_.getProperty(string);
        if (string2 != null) {
            int n = Integer.parseInt(string2);
            if (n < 0) {
                String string3 = String.valueOf(string) + ": backlog must be between 0 and 65535";
                this.logger_.error(string3);
                throw new INITIALIZE(string3);
            }
            short s = n >= 32768 ? (short)(n - 65535 - 1) : (short)n;
            Param param = this.findParam("backlog");
            param.value.insert_ushort(s);
        }
    }

    private void parseBind(String string) {
        String string2 = this.props_.getProperty(string);
        if (string2 != null) {
            String string3 = string2.trim();
            if (string3.length() == 0) {
                String string4 = String.valueOf(string) + ": no address specified";
                this.logger_.error(string4);
                throw new INITIALIZE(string4);
            }
            Param param = this.findParam("bind");
            param.value.insert_string(string3);
        }
    }

    private void parseNumeric(String string) {
        String string2 = this.props_.getProperty(string);
        if (string2 != null) {
            boolean bl = string2.equals("true");
            Param param = this.findParam("numeric");
            param.value.insert_boolean(bl);
        }
    }

    private void parseMultiProfile(String string) {
        String string2 = this.props_.getProperty(string);
        if (string2 != null) {
            boolean bl = string2.equals("true");
            Param param = this.findParam("multi_profile");
            param.value.insert_boolean(bl);
        }
    }

    public IIOPConfig(Properties properties, Logger logger) {
        this.props_ = properties;
        this.logger_ = logger;
        this.params_ = new Vector();
    }

    public Param[] getParams() {
        Object[] objectArray = new Param[this.params_.size()];
        this.params_.copyInto(objectArray);
        return objectArray;
    }

    public void parseDeprecatedDefaults() {
        this.parseHost("ooc.orb.oa.host");
        this.parseNumeric("ooc.orb.oa.numeric");
    }

    public void parseDeprecatedForName(String string) {
        String string2 = "ooc.orb.poamanager." + string + ".";
        String string3 = String.valueOf(string2) + "host";
        this.parseHost(string3);
        string3 = String.valueOf(string2) + "numeric";
        this.parseNumeric(string3);
        string3 = String.valueOf(string2) + "port";
        this.parsePort(string3);
    }

    public void parseDeprecatedDefaultPort() {
        this.parsePort("ooc.orb.oa.port");
    }

    public void parseDefaultPort() {
        this.parsePort("ooc.iiop.port");
    }

    public void parseDefaultBind() {
        this.parseBind("ooc.iiop.bind");
    }

    public void parseDefaults() {
        this.parseHost("ooc.iiop.host");
        this.parseNumeric("ooc.iiop.numeric");
        this.parseMultiProfile("ooc.iiop.multi_profile");
        this.parseBacklog("ooc.iiop.backlog");
    }

    public void parseForName(String string) {
        String string2 = "ooc.iiop.acceptor." + string + ".";
        String string3 = String.valueOf(string2) + "host";
        this.parseHost(string3);
        string3 = String.valueOf(string2) + "numeric";
        this.parseNumeric(string3);
        string3 = String.valueOf(string2) + "port";
        this.parsePort(string3);
        string3 = String.valueOf(string2) + "backlog";
        this.parseBacklog(string3);
        string3 = String.valueOf(string2) + "bind";
        this.parseBind(string3);
        string3 = String.valueOf(string2) + "multi_profile";
        this.parseMultiProfile(string3);
    }

    public void parseAll(String string) {
        this.parseDeprecatedDefaults();
        if (string.equals("RootPOAManager")) {
            this.parseDeprecatedDefaultPort();
        }
        this.parseDefaults();
        if (string.equals("RootPOAManager")) {
            this.parseDefaultPort();
            this.parseDefaultBind();
        }
        this.parseDeprecatedForName(string);
        this.parseForName(string);
    }
}

