/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.CORBA.LocalObject;
import com.ooc.IMR.ActiveState;
import com.ooc.IMR.POAStatus;
import com.ooc.OB.Assert;
import com.ooc.OB.BootManager_impl;
import com.ooc.OB.CollocatedServer;
import com.ooc.OB.IMRActiveStateHolder;
import com.ooc.OB.InitialServiceManager;
import com.ooc.OB.LocationForward;
import com.ooc.OB.Logger;
import com.ooc.OB.OAInterface;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.ObjectKey;
import com.ooc.OB.ObjectKeyData;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OB.ServerManager;
import com.ooc.OBPortableServer.DirectServant;
import com.ooc.OBPortableServer.POALocator;
import com.ooc.OBPortableServer.POAManager;
import com.ooc.OBPortableServer.POANameHasher;
import com.ooc.OBPortableServer.POAOAInterface_impl;
import com.ooc.OBPortableServer.POA_impl;
import com.ooc.OCI.Acceptor;
import com.ooc.PortableServer.Current_impl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public final class POAManager_impl
extends LocalObject
implements POAManager {
    private ORBInstance orbInstance_;
    private Hashtable poas_;
    private State state_;
    private Acceptor[] acceptors_;
    private ServerManager serverManager_;
    private String name_;
    private String serverName_;
    private IMRActiveStateHolder imrHolder_;
    private POALocator poaLocator_;
    private OAInterface oaInterface_;
    private Version version_ = new Version();
    private BootManager_impl bootManagerImpl_;

    private void waitPendingRequests() {
        Object object;
        java.lang.Object object2;
        boolean bl = false;
        try {
            object2 = this.orbInstance_.getInitialServiceManager();
            object = ((InitialServiceManager)object2).resolveInitialReferences("POACurrent");
            Current_impl current_impl = (Current_impl)object;
            bl = current_impl._OB_inUpcall();
        }
        catch (InvalidName invalidName) {
        }
        catch (ClassCastException classCastException) {}
        if (bl) {
            throw new BAD_INV_ORDER("Invocation in progress", 0, CompletionStatus.COMPLETED_NO);
        }
        object2 = this.poas_.keys();
        while (object2.hasMoreElements()) {
            object = (POA_impl)this.poas_.get(object2.nextElement());
            ((POA_impl)object)._OB_waitPendingRequests();
        }
    }

    public synchronized void activate() throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ != State.ACTIVE) {
            this.state_ = State.ACTIVE;
            this.notifyAll();
            this.serverManager_.activate();
            this.oaInterface_.activate();
            this._OB_updateIMR();
        }
        this.imrHolder_.serverRunning(this.orbInstance_);
    }

    public synchronized void hold_requests(boolean bl) throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ != State.HOLDING) {
            this.state_ = State.HOLDING;
            this.notifyAll();
            this.serverManager_.hold();
            this.oaInterface_.activate();
            if (bl) {
                this.waitPendingRequests();
            }
            this._OB_updateIMR();
        }
    }

    public synchronized void discard_requests(boolean bl) throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ != State.DISCARDING) {
            this.state_ = State.DISCARDING;
            this.notifyAll();
            this.oaInterface_.discard();
            if (bl) {
                this.waitPendingRequests();
            }
            this._OB_updateIMR();
        }
    }

    public synchronized void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        if (this.state_ != State.INACTIVE) {
            this.serverManager_.destroy();
            this.state_ = State.INACTIVE;
            this.notifyAll();
            if (bl) {
                Enumeration enumeration = this.poas_.keys();
                while (enumeration.hasMoreElements()) {
                    POA_impl pOA_impl = (POA_impl)this.poas_.get(enumeration.nextElement());
                    if (pOA_impl == null) continue;
                    pOA_impl._OB_etherealize();
                }
            }
            this._OB_updateIMR();
        }
    }

    public State get_state() {
        return this.state_;
    }

    public String name() {
        return this.name_;
    }

    public synchronized Acceptor[] get_acceptors() throws AdapterInactive {
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        Acceptor[] acceptorArray = new Acceptor[this.acceptors_.length];
        System.arraycopy(this.acceptors_, 0, acceptorArray, 0, this.acceptors_.length);
        return acceptorArray;
    }

    POAManager_impl(ORBInstance oRBInstance, IMRActiveStateHolder iMRActiveStateHolder, POALocator pOALocator, String string, String string2, Acceptor[] acceptorArray) {
        String string3;
        this.orbInstance_ = oRBInstance;
        this.poas_ = new Hashtable(63);
        this.state_ = State.HOLDING;
        this.acceptors_ = acceptorArray;
        this.name_ = string;
        this.serverName_ = string2;
        this.imrHolder_ = iMRActiveStateHolder;
        this.poaLocator_ = pOALocator;
        this.oaInterface_ = new POAOAInterface_impl(this, this.serverName_, this.orbInstance_);
        String string4 = "ooc.orb.poamanager." + this.name_ + ".";
        int n = string4.length();
        Logger logger = this.orbInstance_.getLogger();
        Properties properties = oRBInstance.getProperties();
        String[] stringArray = new String[]{"conc_model", "host", "numeric", "port", "version"};
        int n2 = stringArray.length;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string5;
            String string6 = (String)enumeration.nextElement();
            if (string6.equals("ooc.orb.oa.thread_pool")) continue;
            if (string6.startsWith(string4)) {
                string5 = string6.substring(n);
            } else {
                if (!string6.startsWith("ooc.orb.oa.")) continue;
                string5 = string6.substring(11);
            }
            int n3 = 0;
            while (n3 < n2) {
                if (string5.equals(stringArray[n3])) break;
                ++n3;
            }
            if (n3 < n2) continue;
            string3 = String.valueOf(string6) + ": unknown property";
            logger.warning(string3);
        }
        this.version_.major = 1;
        this.version_.minor = (byte)2;
        int n4 = 2;
        int n5 = 0;
        while (n5 < n2) {
            String string7 = stringArray[n5];
            string3 = String.valueOf(string4) + string7;
            String string8 = properties.getProperty(string3);
            if (string8 == null) {
                string3 = "ooc.orb.oa." + string7;
                string8 = properties.getProperty(string3);
            }
            if (string8 != null) {
                String string9;
                if (string7.equals("conc_model")) {
                    if (string8.equals("threaded")) {
                        n4 = 2;
                    } else if (string8.equals("thread_per_client")) {
                        n4 = 2;
                    } else if (string8.equals("thread_per_request")) {
                        n4 = 2;
                    } else if (string8.equals("thread_pool")) {
                        n4 = 2;
                    } else {
                        string9 = String.valueOf(string3) + ": unknown value";
                        logger.warning(string9);
                    }
                } else if (string7.equals("version")) {
                    if (string8.equals("1.0")) {
                        this.version_.major = 1;
                        this.version_.minor = 0;
                    } else if (string8.equals("1.1")) {
                        this.version_.major = 1;
                        this.version_.minor = 1;
                    } else if (string8.equals("1.2")) {
                        this.version_.major = 1;
                        this.version_.minor = (byte)2;
                    } else {
                        string9 = String.valueOf(string3) + ": expected `1.0', `1.1' or `1.2'";
                        logger.error(string9);
                        throw new INITIALIZE(string9);
                    }
                }
            }
            ++n5;
        }
        this.serverManager_ = new ServerManager(this.orbInstance_, this.acceptors_, this.oaInterface_, n4);
        this.bootManagerImpl_ = (BootManager_impl)oRBInstance.getBootManager();
    }

    synchronized void _OB_addPOA(POA pOA, String[] stringArray) {
        POANameHasher pOANameHasher = new POANameHasher(stringArray);
        Assert.assert(!this.poas_.containsKey(pOANameHasher));
        this.poas_.put(pOANameHasher, pOA);
        this.poaLocator_.add(pOA, stringArray);
    }

    synchronized void _OB_removePOA(String[] stringArray) {
        POANameHasher pOANameHasher = new POANameHasher(stringArray);
        Assert.assert(this.poas_.containsKey(pOANameHasher));
        this.poas_.remove(pOANameHasher);
        this.poaLocator_.remove(stringArray);
    }

    ActiveState _OB_getIMRActiveState() {
        return this.imrHolder_.getActiveState();
    }

    void _OB_updateIMR() {
        IDLEntity iDLEntity;
        ActiveState activeState = this.imrHolder_.getActiveState();
        if (activeState == null) {
            return;
        }
        Vector vector = new Vector();
        Enumeration enumeration = this.poas_.keys();
        while (enumeration.hasMoreElements()) {
            iDLEntity = (POA_impl)this.poas_.get(enumeration.nextElement());
            if (iDLEntity == null) continue;
            iDLEntity._OB_isPersistent(vector);
        }
        if (vector.size() > 0) {
            try {
                iDLEntity = null;
                switch (this.state_.value()) {
                    case 3: {
                        iDLEntity = POAStatus.INACTIVE;
                        break;
                    }
                    case 1: {
                        iDLEntity = POAStatus.ACTIVE;
                        break;
                    }
                    case 0: {
                        iDLEntity = POAStatus.HOLDING;
                        break;
                    }
                    case 2: {
                        iDLEntity = POAStatus.DISCARDING;
                        break;
                    }
                }
                String[][] stringArray = new String[vector.size()][];
                vector.copyInto((java.lang.Object[])stringArray);
                activeState.poa_status_update(stringArray, (POAStatus)iDLEntity);
                return;
            }
            catch (SystemException systemException) {
                return;
            }
        }
    }

    synchronized DirectServant _OB_getDirectServant(byte[] byArray, RefCountPolicyList refCountPolicyList) throws LocationForward, AdapterInactive {
        IDLEntity iDLEntity;
        if (this.state_ == State.INACTIVE) {
            throw new AdapterInactive();
        }
        ObjectKeyData objectKeyData = new ObjectKeyData();
        if (ObjectKey.ParseObjectKey(byArray, objectKeyData) && (iDLEntity = this._OB_locatePOA(objectKeyData)) != null) {
            POA_impl pOA_impl = (POA_impl)iDLEntity;
            return pOA_impl._OB_getDirectServant(objectKeyData.oid, refCountPolicyList);
        }
        iDLEntity = this.bootManagerImpl_._OB_locate(byArray);
        if (iDLEntity != null) {
            throw new LocationForward((IOR)iDLEntity, false);
        }
        throw new OBJECT_NOT_EXIST("No POA for local servant");
    }

    POA _OB_locatePOA(ObjectKeyData objectKeyData) throws LocationForward {
        IDLEntity iDLEntity;
        Assert.assert(objectKeyData.poaID.length != 0);
        Assert.assert(this.get_state() != State.INACTIVE);
        POA pOA = (POA)this.poas_.get(new POANameHasher(objectKeyData.poaID));
        if (pOA == null && (pOA = this.poaLocator_.locate(objectKeyData)) != null && (iDLEntity = pOA.the_POAManager()) != this) {
            POA_impl pOA_impl = (POA_impl)pOA;
            IOR iOR = pOA_impl._OB_createIOR(objectKeyData.oid);
            throw new LocationForward(iOR, false);
        }
        if (pOA != null && !(iDLEntity = (POA_impl)pOA)._OB_poaMatches(objectKeyData)) {
            pOA = null;
        }
        return pOA;
    }

    public CollocatedServer _OB_getCollocatedServer() {
        return this.serverManager_.getCollocatedServer();
    }

    public synchronized void _OB_validateState() {
        while (this.state_ != State.ACTIVE) {
            if (this.state_ == State.INACTIVE || this.state_ == State.DISCARDING) {
                throw new TRANSIENT("POAManager is inactive or discarding requests", 0, CompletionStatus.COMPLETED_NO);
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Version _OB_getGIOPVersion() {
        return new Version(this.version_.major, this.version_.minor);
    }
}

