/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OCI.IIOP;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.IIOP.InternalError;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.ProfileInfoHolder;
import com.ooc.OCI.ProfileInfoSeqHolder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;

public final class Util {
    public static IOR createIOR(String string, int n, String string2, ProfileInfo profileInfo) {
        IOR iOR = new IOR();
        iOR.type_id = string2;
        iOR.profiles = new TaggedProfile[1];
        iOR.profiles[0] = new TaggedProfile();
        iOR.profiles[0].tag = 0;
        if (profileInfo.major == 1 && profileInfo.minor == 0) {
            ProfileBody_1_0 profileBody_1_0 = new ProfileBody_1_0();
            profileBody_1_0.iiop_version = new Version(1, 0);
            profileBody_1_0.host = string;
            profileBody_1_0.port = n >= 32768 ? (short)(n - 65535 - 1) : (short)n;
            profileBody_1_0.object_key = profileInfo.key;
            Buffer buffer = new Buffer();
            OutputStream outputStream = new OutputStream(buffer);
            outputStream._OB_writeEndian();
            ProfileBody_1_0Helper.write(outputStream, profileBody_1_0);
            iOR.profiles[0].profile_data = new byte[buffer.length()];
            System.arraycopy(buffer.data(), 0, iOR.profiles[0].profile_data, 0, buffer.length());
        } else {
            ProfileBody_1_1 profileBody_1_1 = new ProfileBody_1_1();
            profileBody_1_1.iiop_version = new Version(profileInfo.major, profileInfo.minor);
            profileBody_1_1.host = string;
            profileBody_1_1.port = n >= 32768 ? (short)(n - 65535 - 1) : (short)n;
            profileBody_1_1.object_key = profileInfo.key;
            profileBody_1_1.components = profileInfo.components;
            Buffer buffer = new Buffer();
            OutputStream outputStream = new OutputStream(buffer);
            outputStream._OB_writeEndian();
            ProfileBody_1_1Helper.write(outputStream, profileBody_1_1);
            iOR.profiles[0].profile_data = new byte[buffer.length()];
            System.arraycopy(buffer.data(), 0, iOR.profiles[0].profile_data, 0, buffer.length());
        }
        return iOR;
    }

    public static IOR createIOR(IOR iOR, String string, byte[] byArray) {
        int n = 0;
        while (n < iOR.profiles.length) {
            if (iOR.profiles[n].tag == 0) break;
            ++n;
        }
        Assert.assert(n < iOR.profiles.length);
        Buffer buffer = new Buffer(iOR.profiles[n].profile_data, iOR.profiles[n].profile_data.length);
        InputStream inputStream = new InputStream(buffer, 0, false, null, false);
        inputStream._OB_readEndian();
        ProfileBody_1_0 profileBody_1_0 = ProfileBody_1_0Helper.read(inputStream);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.key = byArray;
        profileInfo.major = profileBody_1_0.iiop_version.major;
        profileInfo.minor = profileBody_1_0.iiop_version.minor;
        profileInfo.components = new TaggedComponent[0];
        return Util.createIOR(profileBody_1_0.host, profileBody_1_0.port, string, profileInfo);
    }

    public static boolean extractProfileInfo(IOR iOR, ProfileInfoHolder profileInfoHolder) {
        ProfileInfoSeqHolder profileInfoSeqHolder = new ProfileInfoSeqHolder();
        profileInfoSeqHolder.value = new ProfileInfo[0];
        Util.extractAllProfileInfos(iOR, profileInfoSeqHolder, false, null, 0, false);
        if (profileInfoSeqHolder.value.length > 0) {
            Assert.assert(profileInfoSeqHolder.value.length == 1);
            profileInfoHolder.value = profileInfoSeqHolder.value[0];
            return true;
        }
        return false;
    }

    public static boolean hostMatch(String string, String string2, boolean bl) {
        block5: {
            if (!string.equals(string2)) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    InetAddress inetAddress2 = InetAddress.getByName(string2);
                    if (inetAddress.equals(inetAddress2)) break block5;
                    if (bl) {
                        InetAddress inetAddress3 = InetAddress.getByName("127.0.0.1");
                        if (!inetAddress2.equals(inetAddress3)) {
                            return false;
                        }
                        break block5;
                    }
                    return false;
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
            }
        }
        return true;
    }

    public static void extractAllProfileInfos(IOR iOR, ProfileInfoSeqHolder profileInfoSeqHolder, boolean bl, String string, int n, boolean bl2) {
        Object object;
        short s = n >= 32768 ? (short)(n - 65535 - 1) : (short)n;
        Vector<ProfileInfo> vector = new Vector<ProfileInfo>();
        int n2 = 0;
        while (n2 < iOR.profiles.length) {
            block15: {
                TaggedComponent[] taggedComponentArray;
                ProfileBody_1_0 profileBody_1_0;
                block16: {
                    int n3;
                    int n4;
                    if (iOR.profiles[n2].tag != 0) break block15;
                    byte[] byArray = iOR.profiles[n2].profile_data;
                    object = new Buffer(byArray, byArray.length);
                    InputStream inputStream = new InputStream((Buffer)object, 0, false, null, false);
                    inputStream._OB_readEndian();
                    profileBody_1_0 = ProfileBody_1_0Helper.read(inputStream);
                    if (profileBody_1_0.iiop_version.major > 1 || profileBody_1_0.iiop_version.minor > 0) {
                        n4 = inputStream.read_ulong();
                        taggedComponentArray = new TaggedComponent[n4];
                        n3 = 0;
                        while (n3 < n4) {
                            taggedComponentArray[n3] = TaggedComponentHelper.read(inputStream);
                            ++n3;
                        }
                    } else {
                        taggedComponentArray = new TaggedComponent[]{};
                    }
                    if (!bl) break block16;
                    n4 = 0;
                    if (s == profileBody_1_0.port && Util.hostMatch(string, profileBody_1_0.host, bl2)) {
                        n4 = 1;
                    }
                    if (n4 == 0) {
                        n3 = 0;
                        while (n3 < taggedComponentArray.length && n4 == 0) {
                            if (taggedComponentArray[n3].tag == 3) {
                                byte[] byArray2 = taggedComponentArray[n3].component_data;
                                Buffer buffer = new Buffer(byArray2, byArray2.length);
                                InputStream inputStream2 = new InputStream(buffer, 0, false, null, false);
                                inputStream2._OB_readEndian();
                                String string2 = inputStream2.read_string();
                                short s2 = inputStream2.read_ushort();
                                if (s == s2 && Util.hostMatch(string, string2, bl2)) {
                                    n4 = 1;
                                }
                            }
                            ++n3;
                        }
                    }
                    if (n4 == 0) break block15;
                }
                ProfileInfo profileInfo = new ProfileInfo();
                profileInfo.key = profileBody_1_0.object_key;
                profileInfo.minor = profileBody_1_0.iiop_version.minor;
                profileInfo.major = profileBody_1_0.iiop_version.major;
                profileInfo.id = iOR.profiles[n2].tag;
                profileInfo.index = n2;
                profileInfo.components = taggedComponentArray;
                vector.addElement(profileInfo);
            }
            ++n2;
        }
        if (vector.size() > 0) {
            int n5 = profileInfoSeqHolder.value.length;
            if (n5 == 0) {
                profileInfoSeqHolder.value = new ProfileInfo[vector.size()];
                vector.copyInto(profileInfoSeqHolder.value);
                return;
            }
            object = new ProfileInfo[n5 + vector.size()];
            System.arraycopy(profileInfoSeqHolder.value, 0, object, 0, n5);
            int n6 = 0;
            while (n6 < vector.size()) {
                object[n5 + n6] = (ProfileInfo)vector.elementAt(n6);
                ++n6;
            }
            profileInfoSeqHolder.value = object;
        }
    }

    public static boolean equivalent(IOR iOR, IOR iOR2) {
        InputStream inputStream;
        Buffer buffer;
        byte[] byArray;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < iOR.profiles.length) {
            if (iOR.profiles[n3].tag == 0) {
                ++n;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < iOR2.profiles.length) {
            if (iOR2.profiles[n4].tag == 0) {
                ++n2;
            }
            ++n4;
        }
        if (n != n2) {
            return false;
        }
        ProfileBody_1_0[] profileBody_1_0Array = new ProfileBody_1_0[n];
        n3 = 0;
        int n5 = 0;
        while (n3 < iOR.profiles.length) {
            if (iOR.profiles[n3].tag == 0) {
                byArray = iOR.profiles[n3].profile_data;
                buffer = new Buffer(byArray, byArray.length);
                inputStream = new InputStream(buffer, 0, false, null, false);
                inputStream._OB_readEndian();
                profileBody_1_0Array[n5++] = ProfileBody_1_0Helper.read(inputStream);
            }
            ++n3;
        }
        if (n5 != n) {
            throw new InternalError();
        }
        ProfileBody_1_0[] profileBody_1_0Array2 = new ProfileBody_1_0[n2];
        n4 = 0;
        int n6 = 0;
        while (n4 < iOR2.profiles.length) {
            if (iOR2.profiles[n4].tag == 0) {
                byArray = iOR2.profiles[n4].profile_data;
                buffer = new Buffer(byArray, byArray.length);
                inputStream = new InputStream(buffer, 0, false, null, false);
                inputStream._OB_readEndian();
                profileBody_1_0Array2[n6++] = ProfileBody_1_0Helper.read(inputStream);
            }
            ++n4;
        }
        if (n6 != n2) {
            throw new InternalError();
        }
        n5 = 0;
        while (n5 < n) {
            n6 = 0;
            while (n6 < n2) {
                if (profileBody_1_0Array2[n6] != null && Util.compareBodies(profileBody_1_0Array[n5], profileBody_1_0Array2[n6])) {
                    profileBody_1_0Array[n5] = null;
                    profileBody_1_0Array2[n6] = null;
                    break;
                }
                ++n6;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < n) {
            if (profileBody_1_0Array[n5] != null) {
                return false;
            }
            ++n5;
        }
        n6 = 0;
        while (n6 < n2) {
            if (profileBody_1_0Array2[n6] != null) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    static boolean compareBodies(ProfileBody_1_0 profileBody_1_0, ProfileBody_1_0 profileBody_1_02) {
        if (profileBody_1_0.iiop_version.major != profileBody_1_02.iiop_version.major || profileBody_1_0.iiop_version.minor != profileBody_1_02.iiop_version.minor) {
            return false;
        }
        if (profileBody_1_0.port != profileBody_1_02.port) {
            return false;
        }
        if (profileBody_1_0.object_key.length != profileBody_1_02.object_key.length) {
            return false;
        }
        int n = 0;
        while (n < profileBody_1_0.object_key.length) {
            if (profileBody_1_0.object_key[n] != profileBody_1_02.object_key[n]) {
                return false;
            }
            ++n;
        }
        if (!profileBody_1_0.host.equals(profileBody_1_02.host)) {
            try {
                InetAddress inetAddress = InetAddress.getByName(profileBody_1_0.host);
                InetAddress inetAddress2 = InetAddress.getByName(profileBody_1_02.host);
                if (!inetAddress.equals(inetAddress2)) {
                    return false;
                }
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
        return true;
    }

    public static int hash(IOR iOR, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < iOR.profiles.length) {
            if (iOR.profiles[n3].tag == 0) {
                byte[] byArray = iOR.profiles[n3].profile_data;
                Buffer buffer = new Buffer(byArray, byArray.length);
                InputStream inputStream = new InputStream(buffer, 0, false, null, false);
                inputStream._OB_readEndian();
                ProfileBody_1_0 profileBody_1_0 = ProfileBody_1_0Helper.read(inputStream);
                n2 ^= profileBody_1_0.port;
                int n4 = 0;
                while (n4 + 1 < profileBody_1_0.object_key.length) {
                    n2 ^= profileBody_1_0.object_key[n4 + 1] * 256 + profileBody_1_0.object_key[n4];
                    n4 += 2;
                }
            }
            ++n3;
        }
        return n2 % (n + 1);
    }
}

