/*
 * Decompiled with CFR 0.152.
 */
package nl.knmi.orfeus.seedlink;

import edu.iris.Fissures.seed.builder.ObjectBuilder;
import edu.iris.Fissures.seed.builder.SeedObjectBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.SeedObjectContainer;
import edu.iris.Fissures.seed.director.SeedImportDirector;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import nl.knmi.orfeus.seedlink.SeedLinkException;

public class SLPacket {
    public static final int TYPE_SLINFT = -101;
    public static final int TYPE_SLINF = -102;
    public static final SLPacket SLTERMINATE = new SLPacket();
    public static final SLPacket SLNOPACKET = new SLPacket();
    public static final SLPacket SLERROR = new SLPacket();
    public static final int SLHEADSIZE = 8;
    public static final int SLRECSIZE = 512;
    public static String SIGNATURE = "SL";
    public static String INFOSIGNATURE = "SLINFO";
    public static String ERRORSIGNATURE = "ERROR\r\n";
    public static String ENDSIGNATURE = "END";
    public byte[] slhead = null;
    public byte[] msrecord = null;
    protected Blockette blockette = null;

    protected SLPacket() {
    }

    public SLPacket(byte[] byArray, int n) throws SeedLinkException {
        if (byArray.length - n < 520) {
            throw new SeedLinkException("not enough bytes in subarray to construct a new SLPacket");
        }
        this.slhead = new byte[8];
        System.arraycopy(byArray, n, this.slhead, 0, 8);
        this.msrecord = new byte[512];
        System.arraycopy(byArray, n + 8, this.msrecord, 0, 512);
    }

    public int getSequenceNumber() {
        if (new String(this.slhead).substring(0, INFOSIGNATURE.length()).equalsIgnoreCase(INFOSIGNATURE)) {
            return 0;
        }
        if (!new String(this.slhead).substring(0, SIGNATURE.length()).equalsIgnoreCase(SIGNATURE)) {
            return -1;
        }
        String string = new String(this.slhead, 2, 6);
        int n = -1;
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("SLPacket.getSequenceNumber(): bad packet sequence number: " + string);
            return -1;
        }
        return n;
    }

    public int getType() throws SeedLinkException {
        if (new String(this.slhead).substring(0, INFOSIGNATURE.length()).equalsIgnoreCase(INFOSIGNATURE)) {
            if (this.slhead[7] != 42) {
                return -101;
            }
            return -102;
        }
        return this.getBlockette().getType();
    }

    public Blockette getBlockette() throws SeedLinkException {
        if (this.blockette != null) {
            return this.blockette;
        }
        SeedObjectBuilder seedObjectBuilder = new SeedObjectBuilder();
        SeedImportDirector seedImportDirector = new SeedImportDirector((ObjectBuilder)seedObjectBuilder);
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.msrecord));
            seedImportDirector.construct((InputStream)dataInputStream);
            SeedObjectContainer seedObjectContainer = (SeedObjectContainer)seedObjectBuilder.getContainer();
            int n = seedObjectContainer.iterate();
            this.blockette = (Blockette)seedObjectContainer.getNext();
            return this.blockette;
        }
        catch (Exception exception) {
            throw new SeedLinkException("failed to decode mini-seed record: " + exception);
        }
    }
}

