/*
 * Decompiled with CFR 0.152.
 */
package nl.knmi.orfeus.seedlink.client;

import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.exception.SeedException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamTokenizer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import nl.knmi.orfeus.seedlink.SLLog;
import nl.knmi.orfeus.seedlink.SLPacket;
import nl.knmi.orfeus.seedlink.SeedLinkException;
import nl.knmi.orfeus.seedlink.Util;
import nl.knmi.orfeus.seedlink.client.SLNetStation;
import nl.knmi.orfeus.seedlink.client.SLState;

public class SeedLinkConnection {
    public static final String SEEDLINK_PROTOCOL_PREFIX = "seedlink://";
    protected static final String UNISTATION = "UNI";
    protected static final String UNINETWORK = "XX";
    protected static final int DFT_READBUF_SIZE = 1024;
    protected static char QUOTE_CHAR = (char)34;
    protected String sladdr = null;
    protected int keepalive = 0;
    protected int netto = 120;
    protected int netdly = 30;
    protected SLLog sllog = null;
    protected String infoString = "";
    protected String statefile = null;
    protected boolean lastpkttime = false;
    protected Vector streams = new Vector();
    protected String begin_time = null;
    protected String end_time = null;
    protected boolean resume = true;
    protected boolean multistation = false;
    protected boolean dialup = false;
    protected boolean terminateFlag = false;
    protected String server_id = null;
    protected float server_version = 0.0f;
    protected String infoRequestString = null;
    protected Socket socket = null;
    protected InputStream socketInputStream = null;
    protected OutputStream socketOutputStream = null;
    protected SLState state = null;
    protected StringBuffer infoStrBuf = new StringBuffer();

    public SeedLinkConnection(SLLog sLLog) {
        this.state = new SLState();
        this.sllog = sLLog != null ? sLLog : new SLLog();
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    public SLState getState() {
        return this.state;
    }

    public void setLog(SLLog sLLog) {
        if (sLLog != null) {
            this.sllog = sLLog;
        }
    }

    public SLLog getLog() {
        return this.sllog;
    }

    public void setNetTimout(int n) {
        this.netto = n;
    }

    public int getNetTimout() {
        return this.netto;
    }

    public void setKeepAlive(int n) {
        this.keepalive = n;
    }

    public int getKeepAlive() {
        return this.keepalive;
    }

    public void setNetDelay(int n) {
        this.netdly = n;
    }

    public int getNetDelay() {
        return this.netdly;
    }

    public void setSLAddress(String string) {
        if (string.startsWith(SEEDLINK_PROTOCOL_PREFIX)) {
            string = string.substring(SEEDLINK_PROTOCOL_PREFIX.length());
        }
        this.sladdr = string;
    }

    public void setLastpkttime(boolean bl) {
        this.lastpkttime = bl;
    }

    public void setBeginTime(String string) {
        this.begin_time = string != null ? new String(string) : null;
    }

    public void setEndTime(String string) {
        this.end_time = string != null ? new String(string) : null;
    }

    public void terminate() {
        this.terminateFlag = true;
    }

    public String getSLAddress() {
        return this.sladdr;
    }

    public Vector getStreams() {
        return (Vector)this.streams.clone();
    }

    public String getInfoString() {
        return this.infoString;
    }

    protected String createInfoString(StringBuffer stringBuffer) {
        int n = 0;
        while ((n = stringBuffer.indexOf("><", n)) > 0) {
            stringBuffer.replace(n, n + 2, ">\n<");
        }
        return stringBuffer.toString().trim();
    }

    protected boolean checkslcd() {
        boolean bl = true;
        if (this.streams.size() < 1 && this.infoRequestString == null) {
            this.sllog.log(true, 0, "[" + this.sladdr + "] stream chain AND info type are empty");
            bl = false;
        }
        int n = 0;
        if (this.sladdr == null) {
            this.sllog.log(false, 1, "[" + this.sladdr + "] [" + this.sladdr + "] server address is empty");
            bl = false;
        } else {
            n = this.sladdr.indexOf(58);
            if (n < 1 || this.sladdr.length() < n + 2) {
                this.sllog.log(true, 0, "[" + this.sladdr + "] host address: [" + this.sladdr + "] is not in `[hostname]:port' format");
                bl = false;
            }
        }
        return bl;
    }

    public int readStreamList(String string, String string2) throws SeedLinkException {
        BufferedReader bufferedReader = null;
        StreamTokenizer streamTokenizer = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            streamTokenizer = new StreamTokenizer(bufferedReader);
        }
        catch (Exception exception) {
            String string3 = "[" + this.sladdr + "] " + exception + ": opening stream list file: " + string;
            this.sllog.log(true, 0, string3);
            throw new SeedLinkException(string3);
        }
        this.sllog.log(false, 1, "reading stream list from " + string);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(63, 63);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        streamTokenizer.commentChar(42);
        streamTokenizer.ordinaryChars(48, 57);
        streamTokenizer.wordChars(48, 57);
        int n = 0;
        int n2 = 0;
        try {
            while (streamTokenizer.ttype != -1) {
                int n3;
                ++n;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                boolean bl = false;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -1) break;
                if (streamTokenizer.ttype == -3) {
                    string4 = streamTokenizer.sval;
                    bl = true;
                    streamTokenizer.nextToken();
                    if (streamTokenizer.ttype == -3) {
                        string5 = streamTokenizer.sval;
                        streamTokenizer.nextToken();
                        if (streamTokenizer.ttype == -3) {
                            string6 = "";
                            while (streamTokenizer.ttype == -3) {
                                string6 = string6 + " " + streamTokenizer.sval;
                                streamTokenizer.nextToken();
                            }
                        }
                    }
                }
                while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
                    streamTokenizer.nextToken();
                }
                if (!bl) continue;
                if (string4 == null) {
                    this.sllog.log(true, 0, "invalid or missing network string at line " + n + " of stream list file: " + string);
                    continue;
                }
                if (string5 == null) {
                    this.sllog.log(true, 0, "invalid or missing station string line " + n + " of stream list file: " + string);
                    continue;
                }
                if (string6 != null) {
                    n3 = this.addStream(string4, string5, string6, -1, null);
                    ++n2;
                    continue;
                }
                n3 = this.addStream(string4, string5, string2, -1, null);
                ++n2;
            }
            if (n2 == 0) {
                this.sllog.log(true, 0, "[" + this.sladdr + "] no streams defined in " + string);
            } else {
                this.sllog.log(false, 2, "[" + this.sladdr + "] Read " + n2 + " streams from " + string);
            }
        }
        catch (IOException iOException) {
            String string7 = "[" + this.sladdr + "] " + iOException + ": reaading stream list file: " + string;
            this.sllog.log(true, 0, string7);
            throw new SeedLinkException(string7);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    public int parseStreamlist(String string, String string2) throws SeedLinkException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = null;
            String string4 = null;
            String string5 = null;
            boolean bl = true;
            try {
                String string6 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string6, ":");
                String string7 = stringTokenizer2.nextToken();
                StringTokenizer stringTokenizer3 = new StringTokenizer(string7, "_");
                if (stringTokenizer3.countTokens() != 2) {
                    this.sllog.log(true, 0, "[" + this.sladdr + "] not in NET_STA format: " + string7);
                    bl = false;
                    continue;
                }
                string3 = stringTokenizer3.nextToken();
                if (string3.length() < 1) {
                    this.sllog.log(true, 0, "[" + this.sladdr + "] not in NET_STA format: " + string7);
                    bl = false;
                } else {
                    string4 = stringTokenizer3.nextToken();
                    if (string4.length() < 1) {
                        this.sllog.log(true, 0, "[" + this.sladdr + "] not in NET_STA format: " + string7);
                        bl = false;
                    }
                }
                if (stringTokenizer2.hasMoreTokens()) {
                    string5 = stringTokenizer2.nextToken();
                    if (string5.length() < 1) {
                        this.sllog.log(true, 0, "[" + this.sladdr + "] empty selector: " + string7);
                        bl = false;
                    }
                } else {
                    string5 = string2;
                }
                if (!bl) continue;
                this.addStream(string3, string4, string5, -1, null);
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {
            }
        }
        if (n == 0) {
            this.sllog.log(true, 0, "[" + this.sladdr + "] no streams defined in stream list");
        } else if (n > 0) {
            this.sllog.log(false, 2, "parsed " + n + " streams from stream list");
        }
        return n;
    }

    protected int addStream(String string, String string2, String string3, int n, String string4) throws SeedLinkException {
        if (this.streams.size() > 0) {
            SLNetStation sLNetStation = (SLNetStation)this.streams.elementAt(0);
            if (sLNetStation.net.equals(UNINETWORK) && sLNetStation.station.equals(UNISTATION)) {
                String string5 = "[" + this.sladdr + "] addStream called, but uni-station mode already configured!";
                this.sllog.log(true, 0, string5);
                throw new SeedLinkException(string5);
            }
        }
        for (int i = 0; i < this.streams.size(); ++i) {
            SLNetStation sLNetStation = (SLNetStation)this.streams.elementAt(i);
            if (!sLNetStation.net.equals(string) || !sLNetStation.station.equals(string2)) continue;
            return sLNetStation.appendSelectors(string3);
        }
        SLNetStation sLNetStation = new SLNetStation(string, string2, string3, n, string4);
        this.streams.addElement(sLNetStation);
        this.multistation = true;
        return 0;
    }

    public void setUniParams(String string, int n, String string2) throws SeedLinkException {
        SLNetStation sLNetStation;
        if (this.streams.size() > 0) {
            sLNetStation = (SLNetStation)this.streams.elementAt(0);
            if (!sLNetStation.net.equals(UNINETWORK) || !sLNetStation.station.equals(UNISTATION)) {
                String string3 = "[" + this.sladdr + "] setUniParams called, but multi-station mode already configured!";
                this.sllog.log(true, 0, string3);
                throw new SeedLinkException(string3);
            }
        }
        sLNetStation = new SLNetStation(UNINETWORK, UNISTATION, string, n, string2);
        this.streams.addElement(sLNetStation);
        this.multistation = false;
    }

    public int setStateFile(String string) throws SeedLinkException {
        this.statefile = string;
        return this.recoverState(string);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int recoverState(String var1_1) throws SeedLinkException {
        var2_2 = null;
        var3_3 = null;
        try {
            var2_2 = new BufferedReader(new FileReader(var1_1));
            var3_3 = new StreamTokenizer(var2_2);
        }
        catch (IOException var4_4) {
            this.sllog.log(true, 0, "[" + this.sladdr + "] cannot open state file: " + var4_4);
            return 0;
        }
        catch (Exception var4_5) {
            var5_7 = "[" + this.sladdr + "] " + var4_5 + ": opening state file: " + var1_1;
            this.sllog.log(true, 0, var5_7);
            throw new SeedLinkException(var5_7);
        }
        this.sllog.log(false, 1, "[" + this.sladdr + "] recovering connection state from state file: " + var1_1);
        var3_3.commentChar(35);
        var3_3.commentChar(42);
        var3_3.eolIsSignificant(true);
        var3_3.quoteChar(SeedLinkConnection.QUOTE_CHAR);
        var4_6 = 0;
        var5_8 = 0;
        while (true) {
            try lbl-1000:
            // 4 sources

            {
                while (true) {
                    if (var3_3.ttype == -1) ** GOTO lbl-1000
                    ++var4_6;
                    var6_9 = null;
                    var7_12 = null;
                    var8_14 = -1;
                    var9_15 = "";
                    var3_3.nextToken();
                    if (var3_3.ttype != -1) {
                        if (var3_3.ttype == -3) {
                            var6_9 = var3_3.sval;
                            var3_3.nextToken();
                            if (var3_3.ttype == -3) {
                                var7_12 = var3_3.sval;
                                var3_3.nextToken();
                                if (var3_3.ttype == -2) {
                                    var8_14 = (int)Math.round(var3_3.nval);
                                    var3_3.nextToken();
                                    if (var3_3.ttype == SeedLinkConnection.QUOTE_CHAR) {
                                        var9_15 = var3_3.sval;
                                        var3_3.nextToken();
                                    }
                                }
                            }
                        }
                        while (var3_3.ttype != 10 && var3_3.ttype != -1) {
                            var3_3.nextToken();
                        }
                        if (var9_15.equals("")) {
                            this.sllog.log(true, 0, "error parsing line " + var4_6 + " of state file");
                            continue;
                        }
                        if (var9_15.equals("null")) continue;
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (var5_8 == 0) {
                            this.sllog.log(true, 0, "[" + this.sladdr + "] no matching streams found in " + var1_1);
                            return var5_8;
                        }
                        this.sllog.log(false, 2, "[" + this.sladdr + "] recoverd state for  " + var5_8 + " streams in " + var1_1);
                        return var5_8;
                    }
                    var10_16 = null;
                    break;
                }
            }
            catch (IOException var6_11) {
                var7_13 = "[" + this.sladdr + "] " + var6_11 + ": reaading state  file: " + var1_1;
                this.sllog.log(true, 0, var7_13);
                throw new SeedLinkException(var7_13);
            }
            finally {
                try {
                    var2_2.close();
                }
                catch (Exception var13_20) {}
            }
            for (var11_17 = 0; var11_17 < this.streams.size(); ++var11_17) {
                var10_16 = (SLNetStation)this.streams.elementAt(var11_17);
                if (var10_16.net.equals(var6_9) && var10_16.station.equals(var7_12)) break;
                var10_16 = null;
            }
            if (var10_16 == null) ** GOTO lbl-1000
            var10_16.seqnum = var8_14;
            if (var9_15 == null) ** GOTO lbl-1000
            try {
                var10_16.btime = new Btime(var9_15);
                ++var5_8;
            }
            catch (Exception var11_18) {
                this.sllog.log(true, 0, "parsing timestamp in line " + var4_6 + " of state file: " + var11_18);
                ** continue;
            }
        }
    }

    public int saveState(String string) throws SeedLinkException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
        }
        catch (IOException iOException) {
            this.sllog.log(true, 0, "[" + this.sladdr + "] cannot open state file: " + iOException);
        }
        catch (Exception exception) {
            String string2 = "[" + this.sladdr + "] " + exception + ": opening state file: " + string;
            this.sllog.log(true, 0, string2);
            throw new SeedLinkException(string2);
        }
        this.sllog.log(false, 2, "[" + this.sladdr + "] saving connection state to state file");
        int n = 0;
        try {
            for (int i = 0; i < this.streams.size(); ++i) {
                SLNetStation sLNetStation = (SLNetStation)this.streams.elementAt(i);
                bufferedWriter.write(sLNetStation.net + " " + sLNetStation.station + " " + sLNetStation.seqnum + " " + QUOTE_CHAR + sLNetStation.btime + QUOTE_CHAR + "\n");
            }
        }
        catch (IOException iOException) {
            String string3 = "[" + this.sladdr + "] " + iOException + ": writing state file: " + string;
            this.sllog.log(true, 0, string3);
            throw new SeedLinkException(string3);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    protected SLPacket doTerminate() {
        this.sllog.log(false, 0, "[" + this.sladdr + "] terminating collect loop");
        this.disconnect();
        this.state = new SLState();
        this.infoRequestString = null;
        this.infoStrBuf = new StringBuffer();
        return SLPacket.SLTERMINATE;
    }

    public SLPacket collect() throws SeedLinkException {
        this.terminateFlag = false;
        if (this.infoRequestString != null) {
            this.state.query_mode = 1;
        }
        if (this.socket == null || !this.socket.isConnected()) {
            if (!this.checkslcd()) {
                String string = "[" + this.sladdr + "] problems with the connection description";
                this.sllog.log(true, 0, string);
                throw new SeedLinkException(string);
            }
            this.state.previous_time = Util.getCurrentTime();
            this.state.netto_trig = -1;
            this.state.keepalive_trig = -1;
        }
        int n = 0;
        while (true) {
            double d;
            this.sllog.log(false, 5, "[" + this.sladdr + "] primary loop pass " + n);
            ++n;
            if (this.terminateFlag) {
                return this.doTerminate();
            }
            if (this.socket == null || !this.socket.isConnected()) {
                this.state.state = 0;
            }
            if (this.state.state == 2 && this.netto > 0 && this.state.netto_trig > 0) {
                this.sllog.log(false, 0, "[" + this.sladdr + "] network timeout (" + this.netto + "s), reconnecting in " + this.netdly + "s");
                this.disconnect();
                this.state.state = 0;
                this.state.netto_trig = -1;
                this.state.netdly_trig = -1;
            }
            if (this.state.state == 2 && !this.state.expect_info && this.keepalive > 0 && this.state.keepalive_trig > 0) {
                this.sllog.log(false, 2, "[" + this.sladdr + "] sending: keepalive request");
                try {
                    this.sendInfoRequest("ID", 3);
                    this.state.query_mode = 2;
                    this.state.expect_info = true;
                    this.state.keepalive_trig = -1;
                }
                catch (SeedLinkException seedLinkException) {
                }
                catch (IOException iOException) {
                    this.sllog.log(false, 0, "[" + this.sladdr + "] I/O error, reconnecting in " + this.netdly + "s");
                    this.disconnect();
                    this.state.state = 0;
                }
            }
            if (this.state.state == 2 && !this.state.expect_info && this.infoRequestString != null) {
                try {
                    this.sendInfoRequest(this.infoRequestString, 1);
                    this.state.query_mode = 1;
                    this.state.expect_info = true;
                }
                catch (SeedLinkException seedLinkException) {
                    this.state.query_mode = 0;
                }
                catch (IOException iOException) {
                    this.sllog.log(false, 0, "[" + this.sladdr + "] I/O error, reconnecting in " + this.netdly + "s");
                    this.disconnect();
                    this.state.state = 0;
                }
                this.infoRequestString = null;
            }
            if (this.state.state == 0 && this.state.netdly_trig > 0) {
                Util.sleep(500L);
            }
            if (this.state.state == 0 && this.state.netdly_trig == 0) {
                try {
                    this.connect();
                    this.state.state = 1;
                }
                catch (Exception exception) {
                    this.sllog.log(true, 0, exception.toString());
                }
                this.state.netto_trig = -1;
                this.state.netdly_trig = -1;
            }
            if (this.state.state == 1) {
                if (this.infoRequestString != null) {
                    try {
                        this.sendInfoRequest(this.infoRequestString, 1);
                        this.state.query_mode = 1;
                        this.state.expect_info = true;
                    }
                    catch (SeedLinkException seedLinkException) {
                        this.sllog.log(false, 1, "[" + this.sladdr + "] SeedLink version does not support INFO requests");
                        this.state.query_mode = 0;
                        this.state.expect_info = false;
                    }
                    catch (IOException iOException) {
                        this.sllog.log(true, 0, "[" + this.sladdr + "] I/O error, reconnecting in " + this.netdly + "s");
                        this.disconnect();
                        this.state.state = 0;
                    }
                    this.infoRequestString = null;
                } else if (!this.state.expect_info) {
                    try {
                        this.configLink();
                        this.state.recptr = 0;
                        this.state.sendptr = 0;
                        this.state.state = 2;
                    }
                    catch (Exception exception) {
                        this.sllog.log(true, 0, "[" + this.sladdr + "] negotiation with remote SeedLink failed: " + exception);
                        this.disconnect();
                        this.state.state = 0;
                        this.state.netdly_trig = -1;
                    }
                    this.state.expect_info = false;
                }
            }
            if (this.state.state == 2 || this.state.expect_info && this.state.state != 0) {
                while (this.state.packetAvailable()) {
                    SLPacket sLPacket = null;
                    boolean bl = true;
                    if (this.state.packetIsInfo()) {
                        boolean bl2;
                        boolean bl3 = bl2 = this.state.databuf[this.state.sendptr + 8 - 1] != 42;
                        if (!this.state.expect_info) {
                            this.sllog.log(true, 0, "[" + this.sladdr + "] unexpected INFO packet received, skipping");
                        } else {
                            if (bl2) {
                                this.state.expect_info = false;
                            }
                            if (this.state.query_mode == 2) {
                                bl = false;
                                if (!bl2) {
                                    this.sllog.log(true, 0, "[" + this.sladdr + "] non-terminated keep-alive packet received!?!");
                                } else {
                                    this.sllog.log(false, 2, "[" + this.sladdr + "] keepalive packet received");
                                }
                            } else {
                                sLPacket = this.state.getPacket();
                                int n2 = sLPacket.getType();
                                if (n2 == -102) {
                                    this.appendInfoString(sLPacket);
                                } else if (n2 == -101) {
                                    this.appendInfoString(sLPacket);
                                    this.infoString = this.createInfoString(this.infoStrBuf);
                                    this.infoStrBuf = new StringBuffer();
                                }
                            }
                        }
                        if (this.state.query_mode != 0) {
                            this.state.query_mode = 0;
                        }
                    } else {
                        try {
                            sLPacket = this.state.getPacket();
                            this.updateStream(sLPacket);
                            if (this.statefile != null) {
                                this.saveState(this.statefile);
                            }
                        }
                        catch (SeedLinkException seedLinkException) {
                            this.sllog.log(true, 0, "[" + this.sladdr + "] bad packet: " + seedLinkException);
                            bl = false;
                        }
                    }
                    this.state.incrementSendPointer();
                    this.state.packDataBuffer();
                    if (!bl) continue;
                    return sLPacket;
                }
                if (this.terminateFlag) {
                    return this.doTerminate();
                }
                try {
                    if (this.state.isError()) {
                        this.sllog.log(true, 0, "[" + this.sladdr + "] SeedLink reported an error with the last command");
                        this.disconnect();
                        return SLPacket.SLERROR;
                    }
                }
                catch (SeedLinkException seedLinkException) {
                    // empty catch block
                }
                try {
                    if (this.state.isEnd()) {
                        this.sllog.log(false, 1, "[" + this.sladdr + "] end of buffer or selected time window");
                        this.disconnect();
                        return SLPacket.SLTERMINATE;
                    }
                }
                catch (SeedLinkException seedLinkException) {
                    // empty catch block
                }
                byte[] byArray = null;
                try {
                    byArray = this.receiveData(this.state.bytesRemaining(), this.sladdr);
                }
                catch (IOException iOException) {
                    this.sllog.log(true, 0, "[" + this.sladdr + "] socket read error: " + iOException + ", reconnecting in " + this.netdly + "s");
                    this.disconnect();
                    this.state.state = 0;
                    this.state.netto_trig = -1;
                    this.state.netdly_trig = -1;
                }
                if (byArray != null && byArray.length > 0) {
                    this.state.appendBytes(byArray);
                    this.state.netto_trig = -1;
                    this.state.keepalive_trig = -1;
                } else {
                    Util.sleep(500L);
                }
            }
            if (!((d = Util.getCurrentTime()) - this.state.previous_time >= 0.25)) continue;
            this.state.previous_time = d;
            if (this.netto > 0) {
                if (this.state.netto_trig == -1) {
                    this.state.netto_time = d;
                    this.state.netto_trig = 0;
                } else if (this.state.netto_trig == 0 && d - this.state.netto_time > (double)this.netto) {
                    this.state.netto_trig = 1;
                }
            }
            if (this.keepalive > 0) {
                if (this.state.keepalive_trig == -1) {
                    this.state.keepalive_time = d;
                    this.state.keepalive_trig = 0;
                } else if (this.state.keepalive_trig == 0 && d - this.state.keepalive_time > (double)this.keepalive) {
                    this.state.keepalive_trig = 1;
                }
            }
            if (this.netdly <= 0) continue;
            if (this.state.netdly_trig == -1) {
                this.state.netdly_time = d;
                this.state.netdly_trig = 1;
                continue;
            }
            if (this.state.netdly_trig != 1 || !(d - this.state.netdly_time > (double)this.netdly)) continue;
            this.state.netdly_trig = 0;
        }
    }

    protected void appendInfoString(SLPacket sLPacket) {
        int n;
        int n2 = 0;
        try {
            Blockette blockette = sLPacket.getBlockette();
            if (blockette.getType() != 999) {
                n = 0;
            } else {
                n = this.getInteger(blockette, 17);
                if (n < 48 || n >= sLPacket.msrecord.length) {
                    n = 0;
                } else {
                    n2 = this.getInteger(blockette, 9);
                    if (n2 <= 0 || n2 > sLPacket.msrecord.length - n) {
                        n = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n == 0) {
            n = 64;
            n2 = sLPacket.msrecord.length - n;
        }
        this.infoStrBuf.append(new String(sLPacket.msrecord, n, n2));
    }

    protected int getInteger(Blockette blockette, int n) throws SeedException {
        Object object = blockette.getFieldVal(n);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return Integer.parseInt(object.toString());
    }

    public void connect() throws SeedLinkException, IOException {
        try {
            String string = this.sladdr.substring(0, this.sladdr.indexOf(58));
            int n = Integer.parseInt(this.sladdr.substring(this.sladdr.indexOf(58) + 1));
            Socket socket = new Socket();
            socket.setReceiveBufferSize(65536);
            socket.setReuseAddress(true);
            socket.setKeepAlive(true);
            socket.connect(new InetSocketAddress(string, n));
            int n2 = 10;
            int n3 = 0;
            while (n3++ < n2 && !socket.isConnected()) {
                Util.sleep(1000L);
            }
            if (!socket.isConnected()) {
                String string2 = "[" + this.sladdr + "] socket connect time-out (" + n2 + "s)";
                throw new SeedLinkException(string2);
            }
            this.sllog.log(false, 1, "[" + this.sladdr + "] network socket opened");
            socket.setKeepAlive(true);
            this.socket = socket;
            this.socketInputStream = this.socket.getInputStream();
            this.socketOutputStream = this.socket.getOutputStream();
        }
        catch (Exception exception) {
            throw new SeedLinkException("[" + this.sladdr + "] cannot connect to SeedLink server: " + exception);
        }
        try {
            this.sayHello();
        }
        catch (SeedLinkException seedLinkException) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw seedLinkException;
        }
        catch (IOException iOException) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iOException;
        }
    }

    public void disconnect() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.sllog.log(true, 1, "[" + this.sladdr + "] network socket close failed: " + iOException);
            }
            this.socket = null;
            this.sllog.log(false, 1, "[" + this.sladdr + "] network socket closed");
        }
        this.state = new SLState();
    }

    public void close() {
        if (this.socket != null) {
            this.sllog.log(false, 1, "[" + this.sladdr + "] closing SeedLinkConnection()");
            this.disconnect();
        }
        if (this.statefile != null) {
            try {
                this.saveState(this.statefile);
            }
            catch (SeedLinkException seedLinkException) {
                this.sllog.log(true, 0, seedLinkException.toString());
            }
        }
    }

    public byte[] sendData(byte[] byArray, String string, int n) throws SeedLinkException, IOException {
        this.socketOutputStream.write(byArray);
        if (n <= 0) {
            return null;
        }
        byte[] byArray2 = null;
        int n2 = 0;
        int n3 = 50;
        int n4 = 30000 / n3;
        while ((byArray2 = this.receiveData(n, string)) != null && byArray2.length == 0) {
            if (n2 > n4) {
                throw new SeedLinkException("[" + string + "] no response from SeedLink server to '" + new String(byArray) + "'");
            }
            Util.sleep(n3);
            ++n2;
        }
        if (byArray2 == null) {
            throw new SeedLinkException("[" + string + "] bad response to '" + byArray + "'");
        }
        return byArray2;
    }

    public byte[] receiveData(int n, String string) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        if (this.socketInputStream.available() > 0) {
            n2 = this.socketInputStream.read(byArray);
        }
        if (n2 == -1) {
            this.sllog.log(true, 1, "[" + string + "] socket.read(): " + n2 + ": TCP FIN or EOF received");
            return null;
        }
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public void sayHello() throws SeedLinkException, IOException {
        String string = "HELLO";
        this.sllog.log(false, 2, "[" + this.sladdr + "] sending: " + string);
        byte[] byArray = new String(string + "\r").getBytes();
        byte[] byArray2 = null;
        byArray2 = this.sendData(byArray, this.sladdr, 1024);
        String string2 = null;
        try {
            string2 = new String(byArray2);
            int n = string2.indexOf(" v");
            if (n < 0) {
                this.server_id = string2;
                this.server_version = 0.0f;
            } else {
                this.server_id = string2.substring(0, n);
                String string3 = string2.substring(n + 2);
                int n2 = string3.indexOf(" ");
                this.server_version = Float.valueOf(string3.substring(0, n2)).floatValue();
            }
        }
        catch (Exception exception) {
            throw new SeedLinkException("[" + this.sladdr + "] bad server ID/version string: '" + string2 + "'");
        }
        if (!this.server_id.equalsIgnoreCase("SEEDLINK")) {
            throw new SeedLinkException("[" + this.sladdr + "] incorrect response to HELLO: '" + string2 + "'");
        }
        this.sllog.log(false, 1, "[" + this.sladdr + "] connected to: '" + string2.substring(0, string2.indexOf(13)) + "'");
    }

    public void requestInfo(String string) throws SeedLinkException {
        if (this.infoRequestString != null || this.state.expect_info) {
            throw new SeedLinkException("[" + this.sladdr + "] cannot make INFO request, one is already pending");
        }
        this.infoRequestString = string;
    }

    public void sendInfoRequest(String string, int n) throws SeedLinkException, IOException {
        if (this.checkVersion(2.92f) < 0) {
            throw new SeedLinkException("[" + this.sladdr + "] detected SeedLink version (" + this.server_version + ") does not support INFO requests");
        }
        byte[] byArray = new String("INFO " + string + "\r").getBytes();
        this.sllog.log(false, n, "[" + this.sladdr + "] sending: requesting INFO level " + string);
        this.sendData(byArray, this.sladdr, 0);
    }

    public int checkVersion(float f) {
        if (this.server_version == 0.0f) {
            return 0;
        }
        if (this.server_version >= f) {
            return 1;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configLink() throws SeedLinkException, IOException {
        if (this.multistation) {
            if (this.checkVersion(2.5f) < 0) throw new SeedLinkException("[" + this.sladdr + "] detected SeedLink version (" + this.server_version + ") does not support multi-station protocol");
            this.negotiateMultiStation();
            return;
        } else {
            this.negotiateUniStation();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void negotiateStation(SLNetStation sLNetStation) throws SeedLinkException, IOException {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray = sLNetStation.getSelectors();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            object3 = stringArray[i];
            if (((String)object3).length() > SLNetStation.MAX_SELECTOR_SIZE) {
                this.sllog.log(false, 0, "[" + this.sladdr + "] invalid selector: " + (String)object3);
                continue;
            }
            object2 = "SELECT " + (String)object3;
            this.sllog.log(false, 2, "[" + this.sladdr + "] sending: " + (String)object2);
            object = new String((String)object2 + "\r").getBytes();
            byte[] byArray = null;
            byArray = this.sendData((byte[])object, this.sladdr, 1024);
            String string = new String(byArray);
            if (string.equals("OK\r\n")) {
                this.sllog.log(false, 2, "[" + this.sladdr + "] response: selector " + (String)object3 + " is OK");
                ++n;
                continue;
            }
            if (!string.equals("ERROR\r\n")) throw new SeedLinkException("[" + this.sladdr + "] response: invalid response to SELECT command: " + string);
            this.sllog.log(true, 0, "[" + this.sladdr + "] response: selector " + (String)object3 + " not accepted");
        }
        if (n < 1) {
            throw new SeedLinkException("[" + this.sladdr + "] response: no data stream selector(s) accepted");
        }
        this.sllog.log(false, 2, "[" + this.sladdr + "] response: " + n + " selector(s) accepted");
        String string = null;
        if (sLNetStation.seqnum != -1 && this.resume) {
            string = this.dialup ? "FETCH" : "DATA";
            if (this.lastpkttime && this.checkVersion(2.93f) >= 0 && sLNetStation.btime != null) {
                string = string + " " + Integer.toHexString(sLNetStation.seqnum + 1) + " " + sLNetStation.getSLTimeStamp();
                this.sllog.log(false, 1, "[" + this.sladdr + "] requesting resume data from 0x" + Integer.toHexString(sLNetStation.seqnum + 1).toUpperCase() + " (decimal: " + (sLNetStation.seqnum + 1) + ") at " + sLNetStation.getSLTimeStamp());
            } else {
                string = string + " " + Integer.toHexString(sLNetStation.seqnum + 1);
                this.sllog.log(false, 1, "[" + this.sladdr + "] requesting resume data from  0x" + Integer.toHexString(sLNetStation.seqnum + 1).toUpperCase() + " (decimal: " + (sLNetStation.seqnum + 1) + ")");
            }
        } else if (this.begin_time != null) {
            if (this.checkVersion(2.92f) < 0) throw new SeedLinkException("[" + this.sladdr + "] detected SeedLink version (" + this.server_version + ") does not support TIME windows");
            string = this.end_time == null ? "TIME " + this.begin_time : "TIME " + this.begin_time + " " + this.end_time;
            this.sllog.log(false, 1, "[" + this.sladdr + "] requesting specified time window");
        } else {
            string = this.dialup ? "FETCH" : "DATA";
            this.sllog.log(false, 1, "[" + this.sladdr + "] requesting next available data");
        }
        this.sllog.log(false, 2, "[" + this.sladdr + "] sending: " + string);
        object3 = new String(string + "\r").getBytes();
        object2 = null;
        object2 = this.sendData((byte[])object3, this.sladdr, 1024);
        object = new String((byte[])object2);
        if (((String)object).equals("OK\r\n")) {
            this.sllog.log(false, 2, "[" + this.sladdr + "] response: DATA/FETCH/TIME command is OK");
            ++n;
            return;
        } else {
            if (!((String)object).equals("ERROR\r\n")) throw new SeedLinkException("[" + this.sladdr + "] response: invalid response to DATA/FETCH/TIME command: " + (String)object);
            throw new SeedLinkException("[" + this.sladdr + "] response: DATA/FETCH/TIME command is not accepted");
        }
    }

    public void negotiateUniStation() throws SeedLinkException, IOException {
        SLNetStation sLNetStation = null;
        try {
            sLNetStation = (SLNetStation)this.streams.elementAt(0);
        }
        catch (Exception exception) {
            throw new SeedLinkException("[" + this.sladdr + "] cannot negotiate uni-station, stream list does not have exactly one element");
        }
        if (!sLNetStation.net.equals(UNINETWORK) || !sLNetStation.station.equals(UNISTATION)) {
            throw new SeedLinkException("[" + this.sladdr + "] cannot negotiate uni-station, mode not configured!");
        }
        this.negotiateStation(sLNetStation);
    }

    public void negotiateMultiStation() throws SeedLinkException, IOException {
        Object object;
        int n = 0;
        if (this.streams.size() < 1) {
            throw new SeedLinkException("[" + this.sladdr + "] cannot negotiate multi-station, stream list is empty");
        }
        for (int i = 0; i < this.streams.size(); ++i) {
            object = (SLNetStation)this.streams.elementAt(i);
            String string = ((SLNetStation)object).net + ((SLNetStation)object).station;
            String string2 = "STATION  " + ((SLNetStation)object).station + " " + ((SLNetStation)object).net;
            this.sllog.log(false, 2, "[" + this.sladdr + "] sending: " + string2);
            byte[] byArray = new String(string2 + "\r").getBytes();
            byte[] byArray2 = null;
            byArray2 = this.sendData(byArray, this.sladdr, 1024);
            String string3 = new String(byArray2);
            if (!string3.equals("OK\r\n")) {
                if (string3.equals("ERROR\r\n")) {
                    this.sllog.log(true, 0, "[" + this.sladdr + "] response: station not accepted, skipping");
                    continue;
                }
                throw new SeedLinkException("[" + this.sladdr + "] response: invalid response to STATION command: " + string3);
            }
            this.sllog.log(false, 2, "[" + this.sladdr + "] response: station is OK (selected)");
            try {
                this.negotiateStation((SLNetStation)object);
            }
            catch (Exception exception) {
                this.sllog.log(true, 0, exception.toString());
                continue;
            }
            ++n;
        }
        if (n < 1) {
            throw new SeedLinkException("[" + this.sladdr + "] no stations accepted");
        }
        this.sllog.log(false, 1, "[" + this.sladdr + "] " + n + " station(s) accepted");
        String string = "END";
        this.sllog.log(false, 2, "[" + this.sladdr + "] sending: " + string);
        object = new String(string + "\r").getBytes();
        this.sendData((byte[])object, this.sladdr, 0);
    }

    public void updateStream(SLPacket sLPacket) throws SeedLinkException {
        int n = sLPacket.getSequenceNumber();
        if (n == -1) {
            throw new SeedLinkException("[" + this.sladdr + "] could not determine sequence number");
        }
        Blockette blockette = sLPacket.getBlockette();
        if (blockette.getType() != 999) {
            throw new SeedLinkException("[" + this.sladdr + "] blockette not 999 (Fixed Section Data Header)");
        }
        String string = null;
        String string2 = null;
        Btime btime = null;
        try {
            string2 = (String)blockette.getFieldVal(4);
            string = (String)blockette.getFieldVal(7);
            btime = (Btime)blockette.getFieldVal(8);
        }
        catch (SeedException seedException) {
            throw new SeedLinkException("[" + this.sladdr + "] blockette read error: " + (Object)((Object)seedException));
        }
        if (!this.multistation) {
            SLNetStation sLNetStation = null;
            try {
                sLNetStation = (SLNetStation)this.streams.elementAt(0);
            }
            catch (Exception exception) {
                throw new SeedLinkException("[" + this.sladdr + "] cannot update uni-station stream, stream list does not have exactly one element");
            }
            sLNetStation.seqnum = n;
            sLNetStation.btime = btime;
            return;
        }
        boolean bl = false;
        SLNetStation sLNetStation = null;
        for (int i = 0; i < this.streams.size(); ++i) {
            sLNetStation = (SLNetStation)this.streams.elementAt(i);
            if (sLNetStation.net.equals(string) && sLNetStation.station.equals(string2)) break;
            if (sLNetStation.net.contains("?") || sLNetStation.net.contains("*") || sLNetStation.station.contains("?") || sLNetStation.station.contains("*")) {
                bl = true;
            }
            sLNetStation = null;
        }
        if (sLNetStation != null) {
            sLNetStation.seqnum = n;
            sLNetStation.btime = btime;
        } else if (!bl) {
            this.sllog.log(true, 0, "unexpected data received: " + string + " " + string2);
        }
    }
}

