/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.Switch;
import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.client.BoxAreaParser;
import edu.sc.seis.seisFile.client.DonutParser;
import edu.sc.seis.seisFile.client.ISOTimeParser;
import edu.sc.seis.seisFile.client.RangeParser;
import edu.sc.seis.seisFile.fdsnws.AbstractFDSNClient;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventIterator;
import edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.quakeml.Quakeml;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;

public class EventClient
extends AbstractFDSNClient {
    private static final String DEPTH = "depth";
    private static final String CONTRIBUTORS = "contributors";
    private static final String CATALOGS = "catalogs";
    private static final String MAGNITUDE = "magnitude";
    private static final String TYPES = "types";
    private static final String INCLUDEALLORIGINS = "includeallorigins";
    private static final String INCLUDEALLMAGNITUDES = "includeallmagnitudes";
    private static final String INCLUDEARRIVALS = "includearrivals";

    @Override
    protected void addParams() throws JSAPException {
        super.addParams();
        this.add((Parameter)BoxAreaParser.createParam("Event constraining box as west/east/south/north"));
        this.add((Parameter)DonutParser.createParam("Event constraining donut as lat/lon/minRadius/maxRadius"));
        this.add((Parameter)ISOTimeParser.createYesterdayParam("begin", "The earliest time for an accepted event", false));
        this.add((Parameter)ISOTimeParser.createParam("end", "now", "The latest time for an accepted event", true));
        this.add((Parameter)RangeParser.createParam(MAGNITUDE, "0", "10", "The range of acceptable magnitudes"));
        this.add((Parameter)this.createListOption(TYPES, 't', TYPES, "The types of magnitudes to retrieve."));
        this.add((Parameter)RangeParser.createParam(DEPTH, "0", "10000", "The range of acceptable depths in kilometers", 'D'));
        this.add((Parameter)this.createListOption(CATALOGS, 'c', CATALOGS, "A comma separated list of catalogs to search"));
        this.add((Parameter)this.createListOption(CONTRIBUTORS, 'C', CONTRIBUTORS, "A comma separated list of contributors to search"));
        this.add((Parameter)new Switch(INCLUDEALLORIGINS, '\u0000', INCLUDEALLORIGINS, "Retrieve all origins instead of only the primary origin associated with each event."));
        this.add((Parameter)new Switch(INCLUDEALLMAGNITUDES, '\u0000', INCLUDEALLMAGNITUDES, "Retrieve all magnitudes for the event instead of only the primary magnitude."));
        this.add((Parameter)new Switch(INCLUDEARRIVALS, '\u0000', INCLUDEARRIVALS, "Specify if phase arrivals should be included."));
        this.add((Parameter)new Switch("validate", '\u0000', "validate", "Validate XML against schema"));
    }

    public EventClient(String[] args) throws JSAPException {
        super(args);
    }

    public void run() {
        JSAPResult result = this.getResult();
        if (this.shouldPrintHelp()) {
            System.out.println(this.jsap.getHelp());
            return;
        }
        if (this.shouldPrintVersion()) {
            System.out.println(BuildVersion.getVersion());
            return;
        }
        if (!this.isSuccess()) {
            Iterator errs = result.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
            System.err.println();
            System.err.println("Usage: java " + this.getClass().getName());
            System.err.println("                " + this.jsap.getUsage());
            System.err.println();
            System.err.println(this.jsap.getHelp());
            return;
        }
        try {
            FDSNEventQueryParams queryParams = this.configureQuery(result);
            if (this.getResult().getBoolean("printurl")) {
                System.out.println(queryParams.formURI());
                return;
            }
            FDSNEventQuerier querier = new FDSNEventQuerier(queryParams);
            if (this.getResult().getBoolean("validate")) {
                querier.validateQuakeML();
                System.out.println("Valid");
            } else if (this.getResult().getBoolean("raw")) {
                querier.outputRaw(System.out);
            } else {
                Quakeml quakeml = querier.getQuakeML();
                if (!quakeml.checkSchemaVersion()) {
                    System.out.println("");
                    System.out.println("WARNING: XmlSchema of this document does not match this code, results may be incorrect.");
                    System.out.println("XmlSchema (code): http://quakeml.org/xmlns/quakeml/1.2");
                    System.out.println("XmlSchema (doc): " + quakeml.getSchemaVersion());
                }
                this.handleResults(quakeml);
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    FDSNEventQueryParams configureQuery(JSAPResult result) throws SeisFileException {
        FDSNEventQueryParams queryParams = new FDSNEventQueryParams();
        if (result.contains("box")) {
            HashMap box = (HashMap)result.getObject("box");
            queryParams.area(Float.parseFloat((String)box.get("west")), Float.parseFloat((String)box.get("east")), Float.parseFloat((String)box.get("south")), Float.parseFloat((String)box.get("north")));
        }
        if (result.contains("donut")) {
            HashMap donut = (HashMap)result.getObject("donut");
            queryParams.donut(Float.parseFloat((String)donut.get("lat")), Float.parseFloat((String)donut.get("lon")), Float.parseFloat((String)donut.get("min")), Float.parseFloat((String)donut.get("max")));
        }
        if (result.contains("begin")) {
            queryParams.setStartTime((Date)result.getObject("begin"));
        }
        if (result.contains("end")) {
            queryParams.setEndTime((Date)result.getObject("end"));
        }
        if (result.contains(DEPTH)) {
            HashMap depthRange = (HashMap)result.getObject(DEPTH);
            queryParams.setMinDepth(Float.parseFloat((String)depthRange.get("min"))).setMaxDepth(Float.parseFloat((String)depthRange.get("max")));
        }
        if (result.contains(MAGNITUDE)) {
            HashMap magRange = (HashMap)result.getObject(MAGNITUDE);
            queryParams.setMinMagnitude(Float.parseFloat((String)magRange.get("min"))).setMaxMagnitude(Float.parseFloat((String)magRange.get("max")));
            if (result.contains(TYPES)) {
                queryParams.setMagnitudeType(result.getString(TYPES));
            }
        }
        if (result.contains(CATALOGS)) {
            queryParams.setCatalog(result.getString(CATALOGS));
        }
        if (result.contains(CONTRIBUTORS)) {
            queryParams.setContributor(result.getString(CONTRIBUTORS));
        }
        if (result.getBoolean(INCLUDEARRIVALS)) {
            queryParams.setIncludeArrivals(true);
        }
        if (result.getBoolean(INCLUDEALLMAGNITUDES)) {
            queryParams.setIncludeAllMagnitudes(true);
        }
        if (result.getBoolean(INCLUDEALLORIGINS)) {
            queryParams.setIncludeAllOrigins(true);
        }
        if (result.contains("host")) {
            queryParams.setHost(result.getString("host"));
        }
        if (result.contains("baseurl")) {
            try {
                queryParams.internalSetBaseURI(new URI(result.getString("baseurl")));
            }
            catch (URISyntaxException e) {
                throw new SeisFileException("Unable to parse URI: " + result.getString("baseurl"), e);
            }
        }
        return queryParams;
    }

    public void handleResults(Quakeml quakeml) throws XMLStreamException, SeisFileException {
        EventIterator eIt = quakeml.getEventParameters().getEvents();
        while (eIt.hasNext()) {
            Event e = eIt.next();
            Origin o = e.getOriginList().get(0);
            Magnitude m = e.getMagnitudeList().get(0);
            System.out.println(o.getLatitude() + "/" + o.getLongitude() + " " + m.getMag().getValue() + " " + m.getType() + " " + o.getTime().getValue());
        }
    }

    public static void main(String[] args) throws JSAPException {
        new EventClient(args).run();
    }
}

