/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.quakeml.Time;
import edu.sc.seis.seisFile.fdsnws.quakeml.TimeWindow;
import edu.sc.seis.seisFile.fdsnws.quakeml.WaveformStreamID;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Amplitude {
    public static final String ELEMENT_NAME = "amplitude";
    String publicID;
    String pickID;
    String type;
    RealQuantity genericAmplitude;
    RealQuantity period;
    TimeWindow timeWindow;
    Time scalingTime;
    Float snr;
    String category;
    String unit;
    String methodID;
    WaveformStreamID waveformID;
    String filterID;
    String magnitudeHint;
    String evaluationMode;
    String evaluationStatus;
    CreationInfo creationInfo;
    List<Comment> commentList = new ArrayList<Comment>();

    public Amplitude(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        this.publicID = StaxUtil.pullAttribute(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("type")) {
                    this.type = StaxUtil.pullText(reader, "type");
                    continue;
                }
                if (elName.equals("category")) {
                    this.category = StaxUtil.pullText(reader, "category");
                    continue;
                }
                if (elName.equals("unit")) {
                    this.unit = StaxUtil.pullText(reader, "unit");
                    continue;
                }
                if (elName.equals("methodID")) {
                    this.methodID = StaxUtil.pullText(reader, "methodID");
                    continue;
                }
                if (elName.equals("snr")) {
                    this.snr = Float.valueOf(StaxUtil.pullFloat(reader, "snr"));
                    continue;
                }
                if (elName.equals("scalingTime")) {
                    this.scalingTime = new Time(reader, "scalingTime");
                    continue;
                }
                if (elName.equals("timeWindow")) {
                    this.timeWindow = new TimeWindow(reader);
                    continue;
                }
                if (elName.equals("waveformID")) {
                    this.waveformID = new WaveformStreamID(reader, "waveformID");
                    continue;
                }
                if (elName.equals("filterID")) {
                    this.filterID = StaxUtil.pullText(reader, "filterID");
                    continue;
                }
                if (elName.equals("magnitudeHint")) {
                    this.magnitudeHint = StaxUtil.pullText(reader, "magnitudeHint");
                    continue;
                }
                if (elName.equals("pickID")) {
                    this.pickID = StaxUtil.pullText(reader, "pickID");
                    continue;
                }
                if (elName.equals("period")) {
                    this.period = new RealQuantity(reader, "period");
                    continue;
                }
                if (elName.equals("evaluationMode")) {
                    this.evaluationMode = StaxUtil.pullText(reader, "evaluationMode");
                    continue;
                }
                if (elName.equals("evaluationStatus")) {
                    this.evaluationStatus = StaxUtil.pullText(reader, "evaluationStatus");
                    continue;
                }
                if (elName.equals("genericAmplitude")) {
                    this.genericAmplitude = new RealQuantity(reader, "genericAmplitude");
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getPublicID() {
        return this.publicID;
    }

    public String getPickID() {
        return this.pickID;
    }

    public String getType() {
        return this.type;
    }

    public RealQuantity getGenericAmplitude() {
        return this.genericAmplitude;
    }

    public RealQuantity getPeriod() {
        return this.period;
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    public Time getScalingTime() {
        return this.scalingTime;
    }

    public Float getSnr() {
        return this.snr;
    }

    public String getCategory() {
        return this.category;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getMethodID() {
        return this.methodID;
    }

    public WaveformStreamID getWaveformID() {
        return this.waveformID;
    }

    public String getFilterID() {
        return this.filterID;
    }

    public String getMagnitudeHint() {
        return this.magnitudeHint;
    }

    public String getEvaluationMode() {
        return this.evaluationMode;
    }

    public String getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }
}

