/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataUsed {
    public static final String ELEMENT_NAME = "dataUsed";
    private String waveType;
    private int stationCount;
    private int componentCount;
    private float shortestPeriod;
    private float longestPeriod;

    public DataUsed(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("waveType")) {
                    this.waveType = StaxUtil.pullText(reader, "waveType");
                    continue;
                }
                if (elName.equals("stationCount")) {
                    this.stationCount = StaxUtil.pullInt(reader, "stationCount");
                    continue;
                }
                if (elName.equals("componentCount")) {
                    this.componentCount = StaxUtil.pullInt(reader, "componentCount");
                    continue;
                }
                if (elName.equals("shortestPeriod")) {
                    this.shortestPeriod = StaxUtil.pullFloat(reader, "shortestPeriod");
                    continue;
                }
                if (elName.equals("longestPeriod")) {
                    this.longestPeriod = StaxUtil.pullFloat(reader, "longestPeriod");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public String getWaveType() {
        return this.waveType;
    }

    public int getStationCount() {
        return this.stationCount;
    }

    public int getComponentCount() {
        return this.componentCount;
    }

    public float getShortestPeriod() {
        return this.shortestPeriod;
    }

    public float getLongestPeriod() {
        return this.longestPeriod;
    }
}

