/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Arrival;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.OriginQuality;
import edu.sc.seis.seisFile.fdsnws.quakeml.OriginUncertainty;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.quakeml.Time;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Origin {
    public static final String ELEMENT_NAME = "origin";
    Time time;
    RealQuantity latitude;
    RealQuantity longitude;
    RealQuantity depth = new RealQuantity(0.0f);
    String depthType;
    String earthModelID;
    List<Comment> commentList = new ArrayList<Comment>();
    List<Arrival> arrivalList = new ArrayList<Arrival>();
    String waveformID;
    OriginQuality quality;
    OriginUncertainty originUncertainty;
    String evaluationMode;
    String evaluationStatus;
    String type;
    CreationInfo creationInfo;
    String publicId;
    String irisContributor = "";
    String irisCatalog = "";

    public Origin(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        Attribute contributorAttr;
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        this.publicId = StaxUtil.pullAttribute(startE, "publicID");
        Attribute catalogAttr = startE.getAttributeByName(new QName("http://service.iris.edu/fdsnws/event/1/", "catalog"));
        if (catalogAttr != null) {
            this.irisCatalog = catalogAttr.getValue();
        }
        if ((contributorAttr = startE.getAttributeByName(new QName("http://service.iris.edu/fdsnws/event/1/", "contributor"))) != null) {
            this.irisContributor = contributorAttr.getValue();
        }
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("waveformID")) {
                    this.waveformID = StaxUtil.pullText(reader, "waveformID");
                    continue;
                }
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                if (elName.equals("time")) {
                    this.time = new Time(reader, "time");
                    continue;
                }
                if (elName.equals("latitude")) {
                    this.latitude = new RealQuantity(reader, "latitude");
                    continue;
                }
                if (elName.equals("longitude")) {
                    this.longitude = new RealQuantity(reader, "longitude");
                    continue;
                }
                if (elName.equals("depth")) {
                    this.depth = new RealQuantity(reader, "depth");
                    continue;
                }
                if (elName.equals("depthType")) {
                    this.depthType = StaxUtil.pullText(reader, "depthType");
                    continue;
                }
                if (elName.equals("earthModelID")) {
                    this.earthModelID = StaxUtil.pullText(reader, "earthModelID");
                    continue;
                }
                if (elName.equals("quality")) {
                    this.quality = new OriginQuality(reader);
                    continue;
                }
                if (elName.equals("originUncertainty")) {
                    this.originUncertainty = new OriginUncertainty(reader);
                    continue;
                }
                if (elName.equals("type")) {
                    this.type = StaxUtil.pullText(reader, "type");
                    continue;
                }
                if (elName.equals("evaluationMode")) {
                    this.evaluationMode = StaxUtil.pullText(reader, "evaluationMode");
                    continue;
                }
                if (elName.equals("evaluationStatus")) {
                    this.evaluationStatus = StaxUtil.pullText(reader, "evaluationStatus");
                    continue;
                }
                if (elName.equals("arrival")) {
                    this.arrivalList.add(new Arrival(reader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public String toString() {
        return this.time.getValue() + " (" + this.latitude.getValue() + ", " + this.longitude.getValue() + ") " + this.depth.getValue();
    }

    public Time getTime() {
        return this.time;
    }

    public RealQuantity getLatitude() {
        return this.latitude;
    }

    public RealQuantity getLongitude() {
        return this.longitude;
    }

    public RealQuantity getDepth() {
        return this.depth;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public String getWaveformID() {
        return this.waveformID;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getIrisContributor() {
        return this.irisContributor;
    }

    public String getIrisCatalog() {
        return this.irisCatalog;
    }

    public List<Arrival> getArrivalList() {
        return this.arrivalList;
    }

    public OriginUncertainty getOriginUncertainty() {
        return this.originUncertainty;
    }

    public String getDepthType() {
        return this.depthType;
    }

    public String getEarthModelID() {
        return this.earthModelID;
    }

    public OriginQuality getQuality() {
        return this.quality;
    }

    public String getEvaluationMode() {
        return this.evaluationMode;
    }

    public String getEvaluationStatus() {
        return this.evaluationStatus;
    }

    public String getType() {
        return this.type;
    }
}

