/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseFilterType;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatNoUnitType;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Polynomial
extends BaseFilterType {
    private String approximationType;
    private Float freqLowerBound;
    private float freqUpperBound;
    private float approxLowerBound;
    private float approxUpperBound;
    private float maxError;
    private List<FloatNoUnitType> coefficientList = new ArrayList<FloatNoUnitType>();

    public Polynomial(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        this(reader, "Polynomial");
    }

    public Polynomial(XMLEventReader reader, String elementName) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement(elementName, reader);
        super.parseAttributes(startE);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("ApproximationType")) {
                    this.approximationType = StaxUtil.pullText(reader, "ApproximationType");
                    continue;
                }
                if (elName.equals("FrequencyLowerBound")) {
                    this.freqLowerBound = Float.valueOf(StaxUtil.pullFloat(reader, "FrequencyLowerBound"));
                    continue;
                }
                if (elName.equals("FrequencyUpperBound")) {
                    this.freqUpperBound = StaxUtil.pullFloat(reader, "FrequencyUpperBound");
                    continue;
                }
                if (elName.equals("ApproximationLowerBound")) {
                    this.approxLowerBound = StaxUtil.pullFloat(reader, "ApproximationLowerBound");
                    continue;
                }
                if (elName.equals("ApproximationUpperBound")) {
                    this.approxUpperBound = StaxUtil.pullFloat(reader, "ApproximationUpperBound");
                    continue;
                }
                if (elName.equals("MaximumError")) {
                    this.maxError = StaxUtil.pullFloat(reader, "MaximumError");
                    continue;
                }
                if (elName.equals("Coefficient")) {
                    this.coefficientList.add(new FloatNoUnitType(reader, "Coefficient"));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public String getApproximationType() {
        return this.approximationType;
    }

    public Float getFreqLowerBound() {
        return this.freqLowerBound;
    }

    public float getFreqUpperBound() {
        return this.freqUpperBound;
    }

    public float getApproxLowerBound() {
        return this.approxLowerBound;
    }

    public float getApproxUpperBound() {
        return this.approxUpperBound;
    }

    public float getMaxError() {
        return this.maxError;
    }

    public List<FloatNoUnitType> getCoefficientList() {
        return this.coefficientList;
    }
}

