/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.gcf;

import edu.iris.dmc.seedcodec.Utility;
import edu.sc.seis.seisFile.gcf.GCFFormatException;
import java.io.DataOutput;
import java.io.IOException;

public class SerialTransportHeader {
    int blockSeqNum;
    int blockSize;
    public static final int ASCII_G = 71;
    public static final int SIZE = 4;

    public SerialTransportHeader(int blockSeqNum, int blockSize) {
        this.blockSeqNum = blockSeqNum;
        this.blockSize = blockSize;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(71);
        out.writeByte(this.getBlockSeqNum());
        out.writeShort(this.getBlockSize());
    }

    public static SerialTransportHeader fromBytes(byte[] data, int offset) throws GCFFormatException {
        if (data[offset] == 71) {
            SerialTransportHeader header = new SerialTransportHeader(data[offset + 1], Utility.bytesToInt((byte)data[offset + 2], (byte)data[offset + 3], (boolean)false));
            return header;
        }
        throw new GCFFormatException("serial transport header must start with 'G'");
    }

    public byte[] toBytes() {
        byte[] out = new byte[]{71, (byte)this.blockSeqNum, (byte)(this.blockSize >> 8 & 0xFF), (byte)(this.blockSize & 0xFF)};
        return out;
    }

    public int getBlockSeqNum() {
        return this.blockSeqNum;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String toString() {
        return "71 " + this.getBlockSeqNum() + " " + this.getBlockSize();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blockSeqNum;
        result = 31 * result + this.blockSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerialTransportHeader other = (SerialTransportHeader)obj;
        if (this.blockSeqNum != other.blockSeqNum) {
            return false;
        }
        return this.blockSize == other.blockSize;
    }
}

