/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncFileCompare;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class GMTSyncFile {
    Color lineColor = new Color(51, 102, 255);
    int lineWidth = 18;
    Color textColor = Color.BLACK;
    int textSize = 10;
    int textAngle = 0;
    int font = 1;
    String justify = "LM";
    int plotWidth = 10;
    int plotHeight = 6;
    String plotSizeUnit = "i";
    int numChannels;
    Date start;
    Date end;
    String baseFilename = "syncPlot";
    PrintWriter out;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public GMTSyncFile(int numChannels, Date start, Date end, PrintWriter out) {
        this.start = start;
        this.end = end;
        this.numChannels = numChannels;
        this.out = out;
    }

    public void gmtHeader() {
        this.out.println("BASE=\"" + this.baseFilename + "\"");
        this.out.println("PS=${BASE}.ps");
        this.out.println();
        String labelStep = "-Bpa3of1o -Bsa1YS";
        if (this.end.getTime() - this.start.getTime() < 31622400000L) {
            labelStep = "-Bpa1of1o -Bsa1YS";
        }
        if (this.end.getTime() - this.start.getTime() < 15552000000L) {
            labelStep = "-Bpa7Rf1d -Bsa1OS";
        }
        if (this.end.getTime() - this.start.getTime() < 2592000000L) {
            labelStep = "-Bpa1Rf6h -Bsa1OS";
        }
        if (this.end.getTime() - this.start.getTime() < 432000000L) {
            this.out.println("gmtset PLOT_CLOCK_FORMAT hh:mm");
            labelStep = "-Bpa6Hf1h -Bsa1DS";
        }
        if (this.end.getTime() - this.start.getTime() < 86400000L) {
            labelStep = "-Bpa15mf5m -Bsa1HS";
        }
        this.out.println("psbasemap -R" + this.sdf.format(this.start) + "/" + this.sdf.format(this.end) + "/0/" + this.numChannels + " -JX" + this.plotWidth + this.plotSizeUnit + "/" + this.plotHeight + this.plotSizeUnit + " " + labelStep + " -K > $PS");
    }

    public void gmtTrailer() {
    }

    public void plot(SyncFile sf, int index) {
        this.out.println("psxy -R -JX -W" + this.getLineWidth() + "," + GMTSyncFile.colorToGMTRGB(this.lineColor) + " -m -O -K >> $PS <<END");
        for (SyncLine sline : sf) {
            this.out.println("> ");
            this.out.println(this.sdf.format(sline.getStartTime()) + " " + index);
            this.out.println(this.sdf.format(sline.getEndTime()) + " " + index);
        }
        this.out.println("END");
    }

    public void label(Date xLoc, int yLoc, String text) {
        this.out.println("pstext -R -JX -G" + GMTSyncFile.colorToGMTRGB(this.textColor) + " -O -K >> $PS <<END");
        this.out.println(this.sdf.format(xLoc) + " " + yLoc + " " + this.textSize + " " + this.textAngle + " " + this.font + " " + this.justify + " " + text);
        this.out.println("END");
    }

    public static String colorToGMTRGB(Color color) {
        return color.getRed() + "/" + color.getGreen() + "/" + color.getBlue();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public int getTextAngle() {
        return this.textAngle;
    }

    public void setTextAngle(int textAngle) {
        this.textAngle = textAngle;
    }

    public int getFont() {
        return this.font;
    }

    public void setFont(int font) {
        this.font = font;
    }

    public String getJustify() {
        return this.justify;
    }

    public void setJustify(String justify) {
        this.justify = justify;
    }

    public int getPlotWidth() {
        return this.plotWidth;
    }

    public void setPlotWidth(int plotWidth) {
        this.plotWidth = plotWidth;
    }

    public int getPlotHeight() {
        return this.plotHeight;
    }

    public void setPlotHeight(int plotHeight) {
        this.plotHeight = plotHeight;
    }

    public String getPlotSizeUnit() {
        return this.plotSizeUnit;
    }

    public void setPlotSizeUnit(String plotSizeUnit) {
        this.plotSizeUnit = plotSizeUnit;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public void setNumChannels(int numChannels) {
        this.numChannels = numChannels;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String getBaseFilename() {
        return this.baseFilename;
    }

    public void setBaseFilename(String baseFilename) {
        this.baseFilename = baseFilename;
    }

    public static void main(String[] args) throws Exception {
        String inFilename = args[0];
        SyncFile sf = SyncFile.load(new File(inFilename));
        sf.sort();
        HashMap<String, SyncFile> byChan = sf.splitByChannel();
        String fileBase = SyncFileCompare.trimDotSync(inFilename);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileBase + ".gmt")));
        HashSet<String> chanKeys = new HashSet<String>(byChan.keySet());
        ArrayList<String> chanKeyList = new ArrayList<String>(chanKeys);
        Collections.sort(chanKeyList);
        Collections.reverse(chanKeyList);
        int numChannels = chanKeyList.size();
        Date[] range = SyncFileCompare.range(byChan.values());
        Date earliest = range[0];
        Date latest = range[1];
        GMTSyncFile gmtPlotter = new GMTSyncFile(numChannels + 1, earliest, latest, out);
        gmtPlotter.setBaseFilename(fileBase);
        gmtPlotter.gmtHeader();
        int chanIndex = 0;
        for (String key : chanKeyList) {
            gmtPlotter.plot(byChan.get(key), ++chanIndex);
            gmtPlotter.setJustify("LB");
            gmtPlotter.setTextColor(Color.BLACK);
            gmtPlotter.label(earliest, chanIndex, key);
        }
        gmtPlotter.gmtTrailer();
        out.close();
    }
}

