/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.SeisFileRuntimeException;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SyncFileReader
implements Iterator<SyncLine> {
    BufferedReader in;
    String header;
    SyncLine nextLine;

    public SyncFileReader(String filename) throws IOException {
        this(new File(filename));
    }

    public SyncFileReader(File inFile) throws IOException {
        this(new BufferedReader(new FileReader(inFile)));
    }

    public SyncFileReader(BufferedReader in) throws IOException {
        this.in = in;
        this.header = in.readLine();
    }

    void loadNext() throws SeisFileRuntimeException {
        block6: {
            try {
                if (this.nextLine != null || this.in == null) break block6;
                String line = this.in.readLine();
                if (line != null) {
                    this.nextLine = SyncLine.parse(line);
                    break block6;
                }
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.in = null;
            }
            catch (SeisFileException e) {
                throw new SeisFileRuntimeException(e);
            }
            catch (IOException e) {
                throw new SeisFileRuntimeException("Unable to read next line.", e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.loadNext();
        return this.nextLine == null;
    }

    @Override
    public SyncLine next() {
        if (this.hasNext()) {
            SyncLine out = this.nextLine;
            this.nextLine = null;
            return out;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported");
    }
}

