/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.util.Time;
import java.nio.channels.SocketChannel;
import java.util.Comparator;

public class ConnectionStatistics {
    public SocketChannel channel;
    public String address;
    public long index;
    public long connectTime;
    public long lastRequestTime;
    public long numBytesReceived;
    public long numBytesSent;
    private String lastCommand;
    private boolean runningCommand;
    private long commandStart;
    public boolean isTraced;

    public ConnectionStatistics(SocketChannel ch) {
        this.channel = ch;
        this.runningCommand = false;
        this.isTraced = false;
    }

    public void touch() {
        this.lastRequestTime = System.currentTimeMillis();
    }

    public void beginCommand(String command) {
        this.runningCommand = true;
        this.commandStart = System.currentTimeMillis();
        this.lastCommand = command;
        int eol = this.lastCommand.indexOf(10);
        if (eol != -1) {
            this.lastCommand = this.lastCommand.substring(0, eol);
        }
    }

    public void endCommand() {
        this.runningCommand = false;
    }

    public void read(int nb) {
        this.numBytesReceived += (long)nb;
    }

    public void sent(int nb) {
        this.numBytesSent += (long)nb;
    }

    public static String getHeaderString() {
        return "[A]ddress        [C]onnect time         [L]ast time            [R]X bytes  [T]X bytes  [I]ndex\n";
    }

    public String getConnectionString() {
        String s = String.format("%-16s %-22s %-22s %-11d %-11d %-11d", this.address, Time.toDateString(this.connectTime), Time.toDateString(this.lastRequestTime), this.numBytesReceived, this.numBytesSent, this.index);
        return s;
    }

    public static String getCommandHeaderString() {
        return "Index     Address         Time (s)\n";
    }

    public String getCommandString() {
        if (!this.runningCommand) {
            return null;
        }
        double runTime = (double)(System.currentTimeMillis() - this.commandStart) / 1000.0;
        String s = String.format("%-9d %-15s %-6.3f\n\t%s\n", this.index, this.address, runTime, this.lastCommand);
        return s;
    }

    public static Comparator<ConnectionStatistics> getComparator(final SortOrder order, final boolean desc) {
        return new Comparator<ConnectionStatistics>(){

            @Override
            public int compare(ConnectionStatistics cs1, ConnectionStatistics cs2) {
                int cmp = 0;
                switch (order) {
                    default: {
                        cmp = cs1.address.compareTo(cs2.address);
                        break;
                    }
                    case LAST_REQUEST_TIME: {
                        cmp = (int)(cs1.lastRequestTime - cs2.lastRequestTime);
                        break;
                    }
                    case CONNECT_TIME: {
                        cmp = (int)(cs1.connectTime - cs2.connectTime);
                        break;
                    }
                    case RX_BYTES: {
                        cmp = (int)(cs1.numBytesReceived - cs2.numBytesReceived);
                        break;
                    }
                    case TX_BYTES: {
                        cmp = (int)(cs1.numBytesSent - cs2.numBytesSent);
                        break;
                    }
                    case INDEX: {
                        cmp = (int)(cs1.index - cs2.index);
                    }
                }
                if (desc) {
                    cmp = -cmp;
                }
                return cmp;
            }
        };
    }

    public static enum SortOrder {
        ADDRESS,
        CONNECT_TIME,
        LAST_REQUEST_TIME,
        RX_BYTES,
        TX_BYTES,
        INDEX;


        public static SortOrder parse(char c) {
            switch (Character.toUpperCase(c)) {
                default: {
                    return ADDRESS;
                }
                case 'L': {
                    return LAST_REQUEST_TIME;
                }
                case 'C': {
                    return CONNECT_TIME;
                }
                case 'R': {
                    return RX_BYTES;
                }
                case 'T': {
                    return TX_BYTES;
                }
                case 'I': 
            }
            return INDEX;
        }
    }
}

