/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import gov.usgs.plot.render.FrameRenderer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class ImageDataRenderer
extends FrameRenderer {
    private double dataMinX;
    private double dataMaxX;
    private double dataMinY;
    private double dataMaxY;
    private Image image;

    public ImageDataRenderer() {
    }

    public ImageDataRenderer(Image img) {
        this.image = img;
    }

    public void setImage(Image img) {
        this.image = img;
    }

    public void setDataExtents(double minX, double maxX, double minY, double maxY) {
        this.dataMinX = minX;
        this.dataMaxX = maxX;
        this.dataMinY = minY;
        this.dataMaxY = maxY;
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform origAT = g.getTransform();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        if (this.image != null) {
            g.clip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
            AffineTransform at = new AffineTransform();
            int imageWidth = this.image.getWidth(null);
            int imageHeight = this.image.getHeight(null);
            double dataWidth = this.dataMaxX - this.dataMinX;
            double ratioWidth = dataWidth / this.getWidth();
            double dataHeight = this.dataMaxY - this.dataMinY;
            double ratioHeight = dataHeight / this.getHeight();
            at.scale(ratioWidth * (double)this.graphWidth / (double)imageWidth, ratioHeight * (double)this.graphHeight / (double)imageHeight);
            g.translate(this.getXPixel(this.dataMinX), this.getYPixel(this.dataMaxY));
            g.drawImage(this.image, at, null);
            g.translate(-this.getXPixel(this.dataMinX), -this.getYPixel(this.dataMaxY));
        }
        g.setClip(origClip);
        g.setTransform(origAT);
        if (this.getLegendRenderer() != null) {
            this.getLegendRenderer().render(g);
        }
        if (this.axis != null) {
            this.axis.postRender(g);
        }
    }
}

