/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import edu.sc.seis.seisFile.BuildVersion;
import gov.usgs.swarm.Icons;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.data.CachedDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class AboutDialog
extends JDialog
implements Runnable {
    private static final long serialVersionUID = -1L;
    private static final JFrame applicationFrame = Swarm.getApplicationFrame();
    private static final int TITLE_LOC_Y = 5;
    private static final int TITLE_HEIGHT = 190;
    private static final int MAIN_PAD_HEIGHT = 9;
    private static final int MAIN_LOC_Y = 204;
    private static final int MAIN_HEIGHT = 100;
    private static final int BUTTON_PAD_HEIGHT = 11;
    private static final int BUTTON_LOC_Y = 315;
    private static final int BUTTON_HEIGHT = 30;
    private static final int BG_WIDTH = 237;
    private static final int BG_HEIGHT = 355;
    private static final int WIDTH = 240;
    private static final int HEIGHT = 381;
    private final JPanel mainPanel;
    private final MemoryPanel memoryPanel;
    private final JLabel freeMemory;
    private final JLabel totalMemory;
    private final JLabel usedMemory;
    private final JLabel maxMemory;
    private final JLabel cacheMemory;
    private final JButton gcButton;
    private final ImageIcon background;
    private final JButton okButton;
    private Thread updateThread;
    private boolean kill = false;

    public AboutDialog() {
        super(applicationFrame, "About", true);
        this.setSize(240, 381);
        Dimension parentSize = applicationFrame.getSize();
        Point parentLoc = applicationFrame.getLocation();
        this.setLocation(parentLoc.x + (parentSize.width / 2 - 120), parentLoc.y + (parentSize.height / 2 - 190));
        this.setResizable(false);
        this.background = Icons.honeycomb;
        if (this.background.getIconWidth() != 237 || this.background.getIconHeight() != 355) {
            Image image = this.background.getImage();
            image = image.getScaledInstance(237, 355, 2);
            this.background.setImage(image);
        }
        JPanel bp = new JPanel(new BorderLayout());
        bp.add((Component)new JLabel(this.background), "Center");
        bp.setSize(237, 355);
        bp.setLocation(0, 0);
        this.getLayeredPane().add(bp);
        this.getLayeredPane().setLayer(bp, JLayeredPane.DEFAULT_LAYER);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(LineBorder.createBlackLineBorder());
        this.memoryPanel = new MemoryPanel(new GridLayout(5, 2));
        this.memoryPanel.setBorder(new EmptyBorder(3, 6, 3, 6));
        this.memoryPanel.add(new JLabel("Free memory: "));
        this.freeMemory = new JLabel();
        this.memoryPanel.add(this.freeMemory);
        this.memoryPanel.add(new JLabel("Total memory: "));
        this.totalMemory = new JLabel();
        this.memoryPanel.add(this.totalMemory);
        this.memoryPanel.add(new JLabel("Used memory: "));
        this.usedMemory = new JLabel();
        this.memoryPanel.add(this.usedMemory);
        this.memoryPanel.add(new JLabel("Max memory: "));
        this.maxMemory = new JLabel();
        this.memoryPanel.add(this.maxMemory);
        this.memoryPanel.add(new JLabel("Cache size: "));
        this.cacheMemory = new JLabel();
        this.memoryPanel.add(this.cacheMemory);
        this.mainPanel.add((Component)this.memoryPanel, "Center");
        this.mainPanel.setSize(224, 100);
        this.mainPanel.setLocation(5, 204);
        this.memoryPanel.setBackground(new Color(255, 255, 0));
        this.mainPanel.setBackground(new Color(0, 0, 0, 0));
        this.getLayeredPane().add(this.mainPanel);
        this.getLayeredPane().setLayer(this.mainPanel, JLayeredPane.PALETTE_LAYER);
        JTextPane title = new JTextPane();
        title.setFont(this.freeMemory.getFont());
        title.setEditable(false);
        title.setBackground(new Color(255, 255, 0, 210));
        title.setSize(224, 190);
        title.setLocation(5, 5);
        title.setBorder(LineBorder.createBlackLineBorder());
        title.setContentType("text/html");
        title.setText("<HTML><DIV style=\"text-align: center;\"><SPAN style=\"color: red;\">SWARM:</SPAN><BR><SPAN style=\"color: blue;\">Seismic Wave Analysis/</SPAN><BR><SPAN style=\"color: blue;\">Real-time Monitoring/</SPAN><BR>Version: " + Swarm.getVersion() + "<BR>" + "<HR>" + "<B>Funded by:</B><BR>" + "USGS  http://www.usgs.gov<BR>" + "IRIS  http://www.iris.edu<BR>" + "ISTI  http://www.isti.com<BR>" + "<HR>" + "<B>Library versions:</B><BR>" + BuildVersion.getName() + " " + BuildVersion.getVersion() + "<BR>" + "SLClient v1.2.1X00" + "<BR>" + "</DIV></HTML>");
        this.getLayeredPane().add(title);
        this.getLayeredPane().setLayer(title, JLayeredPane.PALETTE_LAYER);
        this.okButton = new JButton("OK");
        this.okButton.setSize(60, 30);
        this.okButton.setLocation(170, 315);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
                AboutDialog.this.kill = true;
            }
        });
        this.gcButton = new JButton("Run GC");
        this.gcButton.setSize(90, 30);
        this.gcButton.setLocation(70, 315);
        this.gcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        this.getLayeredPane().add(this.okButton);
        this.getLayeredPane().add(this.gcButton);
        this.getLayeredPane().setLayer(this.okButton, JLayeredPane.PALETTE_LAYER);
        this.getLayeredPane().setLayer(this.gcButton, JLayeredPane.PALETTE_LAYER);
    }

    @Override
    public void setVisible(boolean v) {
        this.updateThread = new Thread((Runnable)this, "About");
        this.updateThread.start();
        super.setVisible(v);
    }

    @Override
    public void run() {
        while (!this.kill) {
            try {
                this.update();
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        this.kill = false;
    }

    public void update() {
        this.memoryPanel.repaint();
    }

    private class MemoryPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final NumberFormat nf;

        public MemoryPanel(LayoutManager layout) {
            super(layout);
            this.nf = new DecimalFormat("#.##");
        }

        @Override
        public void paint(Graphics g) {
            this.update();
            super.paint(g);
        }

        private String toByteString(long bytes) {
            return this.nf.format((double)bytes / 1000000.0) + " MB";
        }

        private void update() {
            Runtime r = Runtime.getRuntime();
            AboutDialog.this.freeMemory.setText(this.toByteString(r.freeMemory()));
            AboutDialog.this.totalMemory.setText(this.toByteString(r.totalMemory()));
            AboutDialog.this.usedMemory.setText(this.toByteString(r.totalMemory() - r.freeMemory()));
            AboutDialog.this.maxMemory.setText(this.toByteString(r.maxMemory()));
            CachedDataSource cache = CachedDataSource.getInstance();
            AboutDialog.this.cacheMemory.setText(this.toByteString(cache.getSize()));
        }
    }
}

