/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import gov.usgs.swarm.AbstractChannelInfo;
import gov.usgs.swarm.StationInfo;
import java.util.Collections;
import java.util.List;

public class ChannelInfo
extends AbstractChannelInfo {
    private final String channel;
    private final String formattedSCNL;
    private final String location;
    private final StationInfo stationInfo;

    public ChannelInfo(StationInfo stationInfo, String channel, String location) {
        this.stationInfo = stationInfo;
        this.channel = channel;
        this.location = location;
        this.formattedSCNL = ChannelInfo.getFormattedSCNL(stationInfo.getStation(), channel, stationInfo.getNetwork(), location);
    }

    public ChannelInfo(String s) {
        String channel = "";
        String network = "";
        String location = "";
        double latitude = Double.NaN;
        double longitude = Double.NaN;
        String delimiter = s.indexOf(36) == -1 ? " " : "\\$";
        String[] ss = s.split(delimiter);
        String station = ss[0];
        if (ss.length > 2) {
            channel = ss[1];
            network = ss[2];
            if (ss.length > 3) {
                location = ss[3];
                if (ss.length > 4) {
                    latitude = StationInfo.parseDouble(ss[4]);
                    if (ss.length > 5) {
                        longitude = StationInfo.parseDouble(ss[5]);
                    }
                }
            }
        }
        this.stationInfo = new StationInfo(station, network, latitude, longitude);
        this.channel = channel;
        this.location = location;
        this.formattedSCNL = ChannelInfo.getFormattedSCNL(station, channel, network, location);
    }

    public ChannelInfo(String station, String channel, String network, String location, double latitude, double longitude, String siteName) {
        this(new StationInfo(station, network, latitude, longitude, siteName), channel, location);
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public String getFormattedSCNL() {
        return this.formattedSCNL;
    }

    @Override
    public List<String> getGroups() {
        return Collections.emptyList();
    }

    @Override
    public double getLatitude() {
        return this.stationInfo.getLatitude();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public double getLongitude() {
        return this.stationInfo.getLongitude();
    }

    @Override
    public String getNetwork() {
        return this.stationInfo.getNetwork();
    }

    @Override
    public String getSiteName() {
        return this.stationInfo.getSiteName();
    }

    @Override
    public String getStation() {
        return this.stationInfo.getStation();
    }

    public StationInfo getStationInfo() {
        return this.stationInfo;
    }
}

