/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm;

import gov.usgs.plot.data.file.FileType;
import gov.usgs.swarm.AboutDialog;
import gov.usgs.swarm.FileChooser;
import gov.usgs.swarm.OptionsDialog;
import gov.usgs.swarm.Swarm;
import gov.usgs.swarm.SwarmConfig;
import gov.usgs.swarm.SwarmDialog;
import gov.usgs.swarm.SwarmLayout;
import gov.usgs.swarm.data.CachedDataSource;
import gov.usgs.swarm.data.FileDataSource;
import gov.usgs.swarm.internalFrame.InternalFrameListener;
import gov.usgs.swarm.internalFrame.SwarmInternalFrames;
import gov.usgs.swarm.map.MapFrame;
import gov.usgs.swarm.wave.WaveClipboardFrame;
import gov.usgs.util.Util;
import gov.usgs.util.ui.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class SwarmMenu
extends JMenuBar
implements InternalFrameListener {
    private static final long serialVersionUID = 1L;
    private JMenu fileMenu;
    private JMenuItem openFile;
    private JMenuItem closeFiles;
    private JMenuItem clearCache;
    private JMenuItem exit;
    private JMenuItem options;
    private String lastLayoutName;
    private JMenu layoutMenu;
    private JMenuItem saveLayout;
    private JMenuItem saveLastLayout;
    private JMenuItem removeLayouts;
    private JMenu windowMenu;
    private JMenuItem tileWaves;
    private JMenuItem tileHelicorders;
    private JMenuItem fullScreen;
    private JCheckBoxMenuItem clipboard;
    private JCheckBoxMenuItem chooser;
    private JCheckBoxMenuItem map;
    private JMenuItem mapToFront;
    private JMenuItem closeAll;
    private JMenu helpMenu;
    private JMenuItem about;
    private AboutDialog aboutDialog;
    private Map<JInternalFrame, InternalFrameMenuItem> windows = new HashMap<JInternalFrame, InternalFrameMenuItem>();
    private Map<SwarmLayout, JMenuItem> layouts = new HashMap<SwarmLayout, JMenuItem>();

    public SwarmMenu() {
        this.createFileMenu();
        this.createLayoutMenu();
        this.createWindowMenu();
        this.createHelpMenu();
        SwarmInternalFrames.addInternalFrameListener(this);
    }

    private void createFileMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        this.openFile = new JMenuItem("Open File...");
        this.openFile.setMnemonic('O');
        this.openFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = FileChooser.getFileChooser();
                chooser.resetChoosableFileFilters();
                for (FileType ft : FileType.getKnownTypes()) {
                    ExtensionFileFilter f = new ExtensionFileFilter(ft.extension, ft.description);
                    chooser.addChoosableFileFilter(f);
                }
                chooser.setFileFilter(chooser.getAcceptAllFileFilter());
                File lastPath = new File(SwarmConfig.getInstance().lastPath);
                chooser.setCurrentDirectory(lastPath);
                chooser.setFileSelectionMode(0);
                chooser.setMultiSelectionEnabled(true);
                chooser.setDialogTitle("Open Wave as Data Source");
                int result = chooser.showOpenDialog(Swarm.getApplicationFrame());
                if (result == 0) {
                    File[] fs = chooser.getSelectedFiles();
                    FileDataSource.getInstance().openFiles(fs);
                }
            }
        });
        this.openFile.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.fileMenu.add(this.openFile);
        this.closeFiles = new JMenuItem("Close Files");
        this.closeFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDataSource.getInstance().flush();
            }
        });
        this.closeFiles.setMnemonic('l');
        this.fileMenu.add(this.closeFiles);
        this.clearCache = new JMenuItem("Clear Cache");
        this.clearCache.setMnemonic('C');
        this.clearCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CachedDataSource cache = CachedDataSource.getInstance();
                if (cache != null) {
                    cache.flush();
                }
            }
        });
        this.clearCache.setAccelerator(KeyStroke.getKeyStroke(123, 128));
        this.fileMenu.add(this.clearCache);
        this.fileMenu.addSeparator();
        this.options = new JMenuItem("Options...");
        this.options.setMnemonic('O');
        this.options.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog od = new OptionsDialog();
                od.setVisible(true);
            }
        });
        this.fileMenu.add(this.options);
        this.fileMenu.addSeparator();
        this.exit = new JMenuItem("Exit");
        this.exit.setMnemonic('x');
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.getApplication().closeApp();
            }
        });
        this.fileMenu.add(this.exit);
        this.add(this.fileMenu);
        this.fileMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                CachedDataSource cache = CachedDataSource.getInstance();
                SwarmMenu.this.clearCache.setEnabled(!cache.isEmpty());
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    private void createLayoutMenu() {
        this.layoutMenu = new JMenu("Layout");
        this.layoutMenu.setMnemonic('L');
        this.saveLayout = new JMenuItem("Save Layout...");
        this.saveLayout.setMnemonic('S');
        this.saveLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.getApplication().saveLayout(null);
            }
        });
        this.saveLayout.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        this.layoutMenu.add(this.saveLayout);
        this.saveLastLayout = new JMenuItem("Overwrite Last Layout...");
        this.saveLastLayout.setMnemonic('L');
        this.saveLastLayout.setEnabled(false);
        this.saveLastLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SwarmMenu.this.lastLayoutName != null) {
                    Swarm.getApplication().saveLayout(SwarmMenu.this.lastLayoutName);
                }
            }
        });
        this.saveLastLayout.setAccelerator(KeyStroke.getKeyStroke(76, 192));
        this.layoutMenu.add(this.saveLastLayout);
        this.removeLayouts = new JMenuItem("Remove Layout...");
        this.removeLayouts.setMnemonic('R');
        this.removeLayouts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveLayoutDialog d = new RemoveLayoutDialog();
                d.setVisible(true);
            }
        });
        this.layoutMenu.add(this.removeLayouts);
        this.layoutMenu.addSeparator();
        this.add(this.layoutMenu);
    }

    public String getLastLayoutName() {
        return this.lastLayoutName;
    }

    public void setLastLayoutName(String ln) {
        this.lastLayoutName = ln;
        this.saveLastLayout.setEnabled(true);
        this.saveLastLayout.setText("Overwrite Last Layout (" + ln + ")");
    }

    public void addLayout(final SwarmLayout sl) {
        int i;
        JMenuItem mi = new JMenuItem(sl.getName());
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sl.process();
                SwarmMenu.this.setLastLayoutName(sl.getName());
            }
        });
        for (i = 4; i < this.layoutMenu.getItemCount(); ++i) {
            JMenuItem m = this.layoutMenu.getItem(i);
            if (m.getText().compareToIgnoreCase(sl.getName()) < 0) continue;
            this.layoutMenu.add((Component)mi, i);
            break;
        }
        if (i == this.layoutMenu.getItemCount()) {
            this.layoutMenu.add((Component)mi, i);
        }
        this.layouts.put(sl, mi);
    }

    public void removeLayout(SwarmLayout sl) {
        JMenuItem mi = this.layouts.get(sl);
        this.layoutMenu.remove(mi);
        this.layouts.remove(sl);
    }

    private void createWindowMenu() {
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setMnemonic('W');
        this.chooser = new JCheckBoxMenuItem("Data Chooser");
        this.chooser.setMnemonic('D');
        this.chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.getApplication().setChooserVisible(!Swarm.getApplication().isChooserVisible());
            }
        });
        this.chooser.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        this.windowMenu.add(this.chooser);
        this.clipboard = new JCheckBoxMenuItem("Wave Clipboard");
        this.clipboard.setMnemonic('W');
        this.clipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaveClipboardFrame waveClipboard;
                waveClipboard.setVisible(!(waveClipboard = WaveClipboardFrame.getInstance()).isVisible());
            }
        });
        this.clipboard.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        this.windowMenu.add(this.clipboard);
        final MapFrame mapFrame = MapFrame.getInstance();
        this.map = new JCheckBoxMenuItem("Map");
        this.map.setMnemonic('M');
        this.map.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mapFrame.setVisible(!mapFrame.isVisible());
            }
        });
        this.map.setAccelerator(KeyStroke.getKeyStroke(77, 128));
        this.windowMenu.add(this.map);
        this.mapToFront = new JMenuItem("Bring Map to Front");
        this.mapToFront.setMnemonic('F');
        this.mapToFront.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mapFrame.setVisible(true);
            }
        });
        this.mapToFront.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        this.windowMenu.add(this.mapToFront);
        this.windowMenu.addSeparator();
        this.tileHelicorders = new JMenuItem("Tile Helicorders");
        this.tileHelicorders.setMnemonic('H');
        this.tileHelicorders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.getApplication().tileHelicorders();
            }
        });
        this.windowMenu.add(this.tileHelicorders);
        this.tileWaves = new JMenuItem("Tile Waves");
        this.tileWaves.setMnemonic('v');
        this.tileWaves.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.getApplication().tileWaves();
            }
        });
        this.windowMenu.add(this.tileWaves);
        this.windowMenu.addSeparator();
        this.fullScreen = new JMenuItem("Kiosk Mode");
        this.fullScreen.setMnemonic('K');
        this.fullScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Swarm.getApplication().toggleFullScreenMode();
            }
        });
        this.fullScreen.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        this.windowMenu.add(this.fullScreen);
        this.windowMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                SwarmMenu.this.clipboard.setSelected(WaveClipboardFrame.getInstance().isVisible());
                SwarmMenu.this.chooser.setSelected(Swarm.getApplication().isChooserVisible());
                SwarmMenu.this.map.setSelected(MapFrame.getInstance().isVisible());
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.windowMenu.addSeparator();
        this.closeAll = new JMenuItem("Close All");
        this.closeAll.setMnemonic('C');
        this.closeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwarmInternalFrames.removeAllFrames();
            }
        });
        this.windowMenu.add(this.closeAll);
        this.add(this.windowMenu);
    }

    private void createHelpMenu() {
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic('H');
        this.about = new JMenuItem("About...");
        this.about.setMnemonic('A');
        this.aboutDialog = new AboutDialog();
        this.about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwarmMenu.this.aboutDialog.update();
                SwarmMenu.this.aboutDialog.setVisible(true);
            }
        });
        this.helpMenu.add(this.about);
        this.add(this.helpMenu);
    }

    @Override
    public void internalFrameAdded(JInternalFrame f) {
        InternalFrameMenuItem mi = new InternalFrameMenuItem(f);
        this.windows.put(f, mi);
        this.windowMenu.add(mi);
    }

    @Override
    public void internalFrameRemoved(JInternalFrame f) {
        InternalFrameMenuItem mi = this.windows.get(f);
        this.windows.remove(f);
        this.windowMenu.remove(mi);
    }

    private class RemoveLayoutDialog
    extends SwarmDialog {
        private static final long serialVersionUID = 1L;
        private JList layoutList;
        private DefaultListModel model;

        protected RemoveLayoutDialog() {
            super(Swarm.getApplicationFrame(), "Remove Layouts", true);
            this.setSizeAndLocation();
        }

        @Override
        protected void createUI() {
            super.createUI();
            Set<String> keys = RemoveLayoutDialog.swarmConfig.layouts.keySet();
            ArrayList<String> sls = new ArrayList<String>();
            sls.addAll(keys);
            Collections.sort(sls, Util.getIgnoreCaseStringComparator());
            this.model = new DefaultListModel();
            for (String sl : sls) {
                this.model.addElement(sl);
            }
            this.layoutList = new JList(this.model);
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 9, 5, 9));
            int h = Math.max(200, Math.min(350, sls.size() * 19));
            panel.setPreferredSize(new Dimension(200, h));
            panel.add((Component)new JLabel("Select layouts to remove:"), "North");
            panel.add((Component)new JScrollPane(this.layoutList), "Center");
            this.mainPanel.add((Component)panel, "Center");
        }

        @Override
        public void wasOK() {
            Object[] toRemove;
            for (Object key : toRemove = this.layoutList.getSelectedValues()) {
                SwarmLayout layout = (SwarmLayout)RemoveLayoutDialog.swarmConfig.layouts.get((String)key);
                if (layout == null) continue;
                JMenuItem mi = (JMenuItem)SwarmMenu.this.layouts.get(layout);
                SwarmMenu.this.layoutMenu.remove(mi);
                swarmConfig.removeLayout(layout);
            }
        }
    }

    private class InternalFrameMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private JInternalFrame frame;

        public InternalFrameMenuItem(JInternalFrame f) {
            this.frame = f;
            this.setText(f.getTitle());
            this.setIcon(f.getFrameIcon());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (InternalFrameMenuItem.this.frame.isIcon()) {
                            InternalFrameMenuItem.this.frame.setIcon(false);
                        }
                        InternalFrameMenuItem.this.frame.toFront();
                        InternalFrameMenuItem.this.frame.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

