/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.chooser;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.swarm.chooser.DataSourcePanel;
import gov.usgs.swarm.data.fdsnWs.WebServiceUtils;
import gov.usgs.swarm.data.fdsnWs.WebServicesSource;
import gov.usgs.util.ResourceReader;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class WebServicesPanel
extends DataSourcePanel {
    private static final String WS_NETWORK_FILE = "IRIS_networks.txt";
    private static final String codeText = ";" + WebServicesSource.typeString + ":";
    private boolean showUrlFieldsFlag = false;
    private JComboBox network;
    private JTextField station;
    private JTextField location;
    private JTextField channel;
    private JTextField gulperSize;
    private JTextField gulperDelay;
    private JTextField wsDataselectUrlField;
    private JTextField wsStationUrlField;

    public WebServicesPanel() {
        super(WebServicesSource.typeString, "IRIS WS");
    }

    @Override
    public boolean allowOK(boolean edit) {
        String message = null;
        double gs = -1.0;
        try {
            gs = Double.parseDouble(this.gulperSize.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (gs <= 0.0) {
            message = "The gulper size must be greater than 0 minutes.";
        }
        double gd = -1.0;
        try {
            gd = Double.parseDouble(this.gulperDelay.getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (gd < 0.0) {
            message = "The gulper delay must be greater than or equal to 0 seconds.";
        }
        if (message != null) {
            JOptionPane.showMessageDialog(applicationFrame, message, "Error", 0);
            return false;
        }
        return true;
    }

    protected void createFields() {
        int index;
        this.network = new JComboBox();
        this.network.setEditable(true);
        this.station = new JTextField();
        this.location = new JTextField();
        this.channel = new JTextField();
        this.gulperSize = new JTextField();
        this.gulperDelay = new JTextField();
        this.wsDataselectUrlField = new JTextField();
        this.wsStationUrlField = new JTextField();
        String net = "IU";
        String sta = "";
        String loc = "";
        String chan = "";
        String gs = "60";
        String gd = "1.0";
        String wsDataSelectUrl = this.getDefaultText(this.wsDataselectUrlField);
        String wsStationUrl = this.getDefaultText(this.wsStationUrlField);
        if (this.source != null && (index = this.source.indexOf(codeText)) != -1) {
            String[] ss = this.source.substring(index + codeText.length()).split("\\|");
            int ssIndex = 0;
            net = ss[ssIndex++];
            sta = ss[ssIndex++];
            loc = ss[ssIndex++];
            chan = ss[ssIndex++];
            gs = String.format("%.0f", (double)Integer.parseInt(ss[ssIndex++]) / 60.0);
            gd = String.format("%.1f", (double)Integer.parseInt(ss[ssIndex++]) / 1000.0);
            wsDataSelectUrl = ss[ssIndex++];
            wsStationUrl = ss[ssIndex++];
        }
        this.initWebServicesNetworks();
        this.selectNetwork(net);
        this.station.setText(sta);
        this.location.setText(loc);
        this.channel.setText(chan);
        this.gulperSize.setText(gs);
        this.gulperDelay.setText(gd);
        this.wsDataselectUrlField.setText(wsDataSelectUrl);
        this.wsStationUrlField.setText(wsStationUrl);
    }

    @Override
    protected void createPanel() {
        this.createFields();
        FormLayout layout = new FormLayout("right:max(20dlu;pref), 3dlu, 40dlu, 0dlu, 45dlu, 3dlu, right:max(20dlu;pref), 3dlu, 40dlu, 0dlu, 45dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)new JLabel("Use this data source to connect to an IRIS Web Services server."), 11);
        builder.nextLine();
        builder.appendSeparator();
        JLabel scnlLabel = new JLabel("<HTML>Station, Channel, Network and Location filters or empty for all. Use -- for empty location code. Both wildcards (\"?\" for any single character and \"*\" for zero or more characters) and comma-separated lists are accepted. If all Networks channels will not be displayed on the map.</HTML>");
        builder.append((Component)scnlLabel, 11);
        builder.nextLine();
        builder.append("Station:");
        builder.append((Component)this.station, 3);
        builder.append("Channel:");
        builder.append((Component)this.channel, 3);
        builder.nextLine();
        builder.append("Network:");
        builder.append((Component)this.network, 3);
        builder.append("Location:");
        builder.append((Component)this.location, 3);
        builder.nextLine();
        builder.append("Gulp size:");
        builder.append((Component)this.gulperSize);
        builder.append(" minutes");
        builder.append("Gulp delay:");
        builder.append((Component)this.gulperDelay);
        builder.append(" seconds");
        if (this.showUrlFieldsFlag) {
            builder.nextLine();
            builder.append("Dataselect URL");
            builder.append((Component)this.wsDataselectUrlField, 9);
            builder.nextLine();
            builder.append("Station URL");
            builder.append((Component)this.wsStationUrlField, 9);
        }
        this.panel = builder.getPanel();
    }

    private String getDefaultText(Component component) {
        String s = component == this.wsDataselectUrlField ? "http://service.iris.edu/fdsnws/dataselect/1/query" : (component == this.wsStationUrlField ? "http://service.iris.edu/fdsnws/station/1/query" : "");
        return s;
    }

    protected String getNetworkText(String s) {
        return s.replaceFirst("\\s*,.*", "").trim();
    }

    private String getText(Component component) {
        Object value = component instanceof JComboBox ? ((JComboBox)component).getSelectedItem() : (component instanceof JTextComponent ? ((JTextComponent)component).getText() : component.toString());
        String s = value == null ? this.getDefaultText(component) : this.getText(value);
        if (component == this.network) {
            s = this.getNetworkText(s);
        }
        return s;
    }

    private String getText(Object value) {
        if (value != null) {
            return value.toString().trim();
        }
        return null;
    }

    protected ResourceReader getWsNetworResourceReader() {
        ResourceReader rr = this.getResourceReader(WS_NETWORK_FILE);
        if (rr == null) {
            WebServiceUtils.warning("IRIS_networks.txt is missing.");
        }
        return rr;
    }

    protected void initWebServicesNetworks() {
        ResourceReader rr = this.getWsNetworResourceReader();
        if (rr != null) {
            String s;
            while ((s = rr.nextLine()) != null) {
                if ((s = s.trim()).length() <= 1 || s.startsWith("#")) continue;
                this.network.addItem(s);
            }
        }
    }

    protected void selectNetwork(String net) {
        if (net != null && net.length() != 0) {
            boolean found = false;
            for (int i = 0; i < this.network.getItemCount(); ++i) {
                String item = (String)this.network.getItemAt(i);
                if (!item.startsWith(net)) continue;
                this.network.setSelectedIndex(i);
                found = true;
                break;
            }
            if (!found) {
                this.network.insertItemAt(net, 0);
                this.network.setSelectedIndex(0);
            }
        } else {
            this.network.setSelectedItem(null);
        }
    }

    @Override
    public String wasOK() {
        int gs = (int)(Double.parseDouble(this.gulperSize.getText()) * 60.0);
        int gd = (int)(Double.parseDouble(this.gulperDelay.getText()) * 1000.0);
        String result = String.format(this.getCode() + ":" + "%s|%s|%s|%s|%d|%d|%s|%s", this.getText(this.network), this.getText(this.station), this.getText(this.location), this.getText(this.channel), gs, gd, this.getText(this.wsDataselectUrlField), this.getText(this.wsStationUrlField));
        return result;
    }
}

