/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.chooser.node;

import gov.usgs.swarm.Icons;
import gov.usgs.swarm.Metadata;
import gov.usgs.swarm.SwarmConfig;
import gov.usgs.swarm.chooser.node.AbstractChooserNode;
import gov.usgs.util.Util;
import javax.swing.Icon;

public class ChannelNode
extends AbstractChooserNode {
    public static final int ONE_DAY_S = 86400;
    public static final String TOOL_TIP_DATE_FORMAT = "MMM dd, yyyy";
    private static final long serialVersionUID = 1L;
    private String channel;

    public ChannelNode(String c) {
        this.label = this.channel = c;
    }

    @Override
    public Icon getIcon() {
        Metadata md = SwarmConfig.getInstance().getMetadata(this.channel);
        if (md == null || !md.isTouched()) {
            return Icons.graybullet;
        }
        if (md.hasLonLat()) {
            return Icons.bluebullet;
        }
        return Icons.bullet;
    }

    public String getChannel() {
        return this.channel;
    }

    @Override
    public String getToolTip() {
        Metadata md = SwarmConfig.getInstance().getMetadata(this.channel);
        double minTime = md.getMinTime();
        double maxTime = md.getMaxTime();
        if (Double.isNaN(minTime) || Double.isNaN(maxTime)) {
            return "No data";
        }
        return Util.j2KToDateString(minTime, TOOL_TIP_DATE_FORMAT) + " - " + Util.j2KToDateString(maxTime, TOOL_TIP_DATE_FORMAT);
    }

    public boolean isStale() {
        Metadata md = SwarmConfig.getInstance().getMetadata(this.channel);
        double maxTime = md.getMaxTime();
        return Double.isNaN(maxTime) || Util.nowJ2K() - maxTime > 86400.0;
    }
}

