/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data.fdsnWs;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationIterator;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import gov.usgs.swarm.StationInfo;
import gov.usgs.swarm.data.fdsnWs.AbstractWebServiceStationClient;
import gov.usgs.swarm.data.fdsnWs.WebServiceUtils;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;

public class WebServiceStationXmlClient
extends AbstractWebServiceStationClient {
    public static WebServiceStationXmlClient createClient(String[] args) {
        String baseUrlText = WebServiceStationXmlClient.getArg(args, 0, "http://service.iris.edu/fdsnws/station/1/query");
        String net = WebServiceStationXmlClient.getArg(args, 1);
        String sta = WebServiceStationXmlClient.getArg(args, 2);
        String loc = WebServiceStationXmlClient.getArg(args, 3);
        String chan = WebServiceStationXmlClient.getArg(args, 4);
        Date date = WebServiceUtils.parseDate(WebServiceStationXmlClient.getArg(args, 5));
        return new WebServiceStationXmlClient(baseUrlText, net, sta, loc, chan, date);
    }

    public static void main(String[] args) {
        String error = null;
        WebServiceStationXmlClient client = WebServiceStationXmlClient.createClient(args);
        try {
            client.setStationList(WebServiceStationXmlClient.createStationList());
            error = client.fetchStations();
            if (error == null) {
                List<StationInfo> stationList = client.getStationList();
                System.out.println("station count: " + stationList.size());
                for (StationInfo station : stationList) {
                    System.out.println("station: " + station);
                    client.setCurrentStation(station);
                    error = client.fetchChannels();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (error != null) {
            System.out.println(error);
        } else {
            System.out.println("done");
        }
    }

    public WebServiceStationXmlClient(String baseUrlText, String net, String sta, String loc, String chan, Date date) {
        super(baseUrlText, net, sta, loc, chan, date);
    }

    protected boolean checkSchemaVersion(FDSNStationXML staMessage) {
        try {
            if (staMessage.checkSchemaVersion()) {
                return true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String message = "XM schema of this document (" + staMessage.getXmlSchemaLocation() + ") does not match this code (" + "schemaVersion" + ") , results may be incorrect.";
        WebServiceUtils.warning(message);
        return false;
    }

    @Override
    protected void fetch(URL url) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader r = factory.createXMLEventReader(url.toString(), this.conn.getInputStream());
        XMLEvent e = r.peek();
        while (!e.isStartElement()) {
            e = r.nextEvent();
            e = r.peek();
        }
        FDSNStationXML staMessage = new FDSNStationXML(r);
        this.checkSchemaVersion(staMessage);
        NetworkIterator it = staMessage.getNetworks();
        if (it != null) {
            while (it.hasNext()) {
                Network n = it.next();
                StationIterator sit = n.getStations();
                if (sit == null) continue;
                block6: while (sit.hasNext()) {
                    Station s = sit.next();
                    if (!n.toString().equals(s.getNetworkCode())) {
                        throw new StationXMLException("Station in wrong network: " + n.toString() + " != " + s.getNetworkCode() + "  " + r.peek().getLocation());
                    }
                    String network = n.toString();
                    String station = s.getCode();
                    FloatType latitude = s.getLatitude();
                    FloatType longitude = s.getLongitude();
                    String siteName = null;
                    if (s.getSite() != null) {
                        siteName = s.getSite().getName();
                    }
                    switch (this.getLevel()) {
                        case STATION: {
                            this.processStation(this.createStationInfo(station, network, latitude.getValue(), longitude.getValue(), siteName));
                            break;
                        }
                        case CHANNEL: {
                            List chanList = s.getChannelList();
                            for (Channel chan : chanList) {
                                String location = chan.getLocCode();
                                String channel = chan.getCode();
                                this.processChannel(this.createChannelInfo(station, channel, network, location, latitude.getValue(), longitude.getValue(), siteName, this.groupsType));
                            }
                            continue block6;
                        }
                    }
                }
            }
        }
        staMessage.closeReader();
    }
}

