/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.data.fdsnWs;

import edu.sc.seis.seisFile.mseed.DataRecord;
import gov.usgs.plot.data.Wave;
import gov.usgs.swarm.ChannelInfo;
import gov.usgs.swarm.StationInfo;
import gov.usgs.swarm.data.DataSelectReader;
import gov.usgs.swarm.data.SeismicDataSource;
import gov.usgs.swarm.data.fdsnWs.AbstractDataRecordClient;
import gov.usgs.swarm.data.fdsnWs.AbstractWebServiceStationClient;
import gov.usgs.swarm.data.fdsnWs.WebServiceStationTextClient;
import gov.usgs.swarm.data.fdsnWs.WebServiceStationXmlClient;
import gov.usgs.swarm.data.fdsnWs.WebServiceUtils;
import java.util.Date;
import java.util.List;

public class WebServicesClient
extends AbstractDataRecordClient {
    private static boolean useXmlClientFlag = Boolean.valueOf(WebServiceUtils.getProperty("SWARM_WS_USE_XML"));
    private final AbstractWebServiceStationClient stationClient;
    private final String wsDataSelectUrl;

    public static String getDefaultWsDataSelectUrl() {
        return "http://service.iris.edu/fdsnws/dataselect/1/query";
    }

    public static String getDefaultWsStationUrl() {
        return "http://service.iris.edu/fdsnws/station/1/query";
    }

    public WebServicesClient(SeismicDataSource source, String net, String sta, String loc, String chan) {
        this(source, net, sta, loc, chan, WebServicesClient.getDefaultWsDataSelectUrl(), WebServicesClient.getDefaultWsStationUrl());
    }

    public WebServicesClient(final SeismicDataSource source, String net, String sta, String loc, String chan, String wsDataSelectUrl, String wsStationUrl) {
        super(source);
        Date date = null;
        final List<String> channelList = WebServiceStationXmlClient.createChannelList();
        this.stationClient = useXmlClientFlag ? new WebServiceStationXmlClient(wsStationUrl, net, sta, loc, chan, date){

            @Override
            public void processChannel(ChannelInfo ch) {
                WebServiceUtils.addChannel(channelList, ch, source);
            }
        } : new WebServiceStationTextClient(wsStationUrl, net, sta, loc, chan, date){

            @Override
            public void processChannel(ChannelInfo ch) {
                WebServiceUtils.addChannel(channelList, ch, source);
            }
        };
        this.stationClient.setStationList(AbstractWebServiceStationClient.createStationList());
        this.stationClient.setChannelList(channelList);
        this.wsDataSelectUrl = wsDataSelectUrl;
    }

    @Override
    public List<String> getChannels() {
        List<String> channelList = this.stationClient.getChannelList();
        if (channelList.size() != 0) {
            WebServiceUtils.info("channel list is not empty");
        } else {
            String error = null;
            long start = System.currentTimeMillis();
            if (this.stationClient.isAllNetworks()) {
                this.stationClient.setCurrentStation(null);
                error = this.stationClient.fetchChannels();
            } else {
                String id = "channels";
                this.getSource().fireChannelsProgress("channels", 0.0);
                error = this.stationClient.fetchStations();
                if (error == null) {
                    int cnt = 0;
                    List<StationInfo> stationList = this.stationClient.getStationList();
                    int ns = stationList.size();
                    for (StationInfo station : stationList) {
                        this.getSource().fireChannelsProgress("channels", (double)cnt / (double)ns);
                        ++cnt;
                        this.stationClient.setCurrentStation(station);
                        error = this.stationClient.fetchChannels();
                        if (error == null) continue;
                        break;
                    }
                }
                this.getSource().fireChannelsProgress("channels", 1.0);
            }
            long end = System.currentTimeMillis();
            if (WebServiceUtils.isDebug()) {
                WebServiceUtils.debug("getChannels(" + (useXmlClientFlag ? "XML" : "Text") + "): " + (double)(end - start) / 1000.0 + " seconds");
            }
            if (error != null) {
                WebServiceUtils.warning("could not get channels: " + error);
            }
            this.assignChannels(channelList);
        }
        return channelList;
    }

    @Override
    public Wave getRawData(final ChannelInfo channelInfo, double t1, double t2) {
        Date begin = this.getDate(t1);
        Date end = this.getDate(t2);
        final List<Wave> waves = this.createWaves();
        DataSelectReader reader = new DataSelectReader(this.wsDataSelectUrl){

            @Override
            public boolean processRecord(DataRecord dr) {
                try {
                    WebServicesClient.this.addWaves(waves, dr);
                }
                catch (Exception ex) {
                    WebServiceUtils.warning("could not get web service raw data (" + channelInfo + "): " + ex.getMessage());
                }
                return true;
            }
        };
        try {
            String query = reader.createQuery(channelInfo.getNetwork(), channelInfo.getStation(), channelInfo.getLocation(), channelInfo.getChannel(), begin, end);
            reader.read(query, null);
        }
        catch (Exception ex) {
            WebServiceUtils.warning("could not get web service raw data (" + channelInfo + "): " + ex.getMessage());
        }
        Wave wave = this.join(waves);
        if (wave != null && WebServiceUtils.isDebug()) {
            WebServiceUtils.debug("web service raw data (" + this.getDateText(wave.getStartTime()) + ", " + this.getDateText(wave.getEndTime()) + ")");
        }
        return wave;
    }
}

