/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.map;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.swarm.SwarmDialog;
import gov.usgs.swarm.map.MapFrame;
import gov.usgs.swarm.map.MapLinePreview;
import gov.usgs.swarm.map.MapPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class MapSettingsDialog
extends SwarmDialog {
    public static final long serialVersionUID = -1L;
    private MapFrame map;
    private JPanel dialogPanel;
    private JTextField scale;
    private JTextField longitude;
    private JTextField latitude;
    private JTextField lineWidth;
    private JTextField refreshInterval;
    private ButtonGroup labelGroup;
    private JRadioButton someLabels;
    private JRadioButton allLabels;
    private JRadioButton noLabels;
    private JButton mapLine;
    private JColorChooser lineChooser;
    private JTextField labelSource;
    private static MapSettingsDialog dialog;

    private MapSettingsDialog() {
        super(applicationFrame, "Map Settings", true);
        this.createUI();
        this.setSizeAndLocation();
    }

    private void createFields() {
        this.latitude = new JTextField();
        this.longitude = new JTextField();
        this.scale = new JTextField();
        this.lineWidth = new JTextField();
        this.refreshInterval = new JTextField();
        this.labelGroup = new ButtonGroup();
        this.someLabels = new JRadioButton("Some");
        this.allLabels = new JRadioButton("All");
        this.noLabels = new JRadioButton("None");
        this.labelGroup.add(this.someLabels);
        this.labelGroup.add(this.allLabels);
        this.labelGroup.add(this.noLabels);
        this.labelSource = new JTextField();
        this.mapLine = new JButton();
        this.lineChooser = new JColorChooser();
        this.lineChooser.setPreviewPanel(new MapLinePreview());
        final ActionListener okActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.mapLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog = JColorChooser.createDialog(applicationFrame, "Map Line Settings", true, MapSettingsDialog.this.lineChooser, okActionListener, null);
                dialog.setVisible(true);
            }
        });
    }

    @Override
    protected void createUI() {
        super.createUI();
        this.createFields();
        FormLayout layout = new FormLayout("right:max(30dlu;pref), 3dlu, 50dlu, 3dlu, 30dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("Location");
        builder.append("Longitude:");
        builder.append((Component)this.longitude);
        builder.append("degrees");
        builder.nextLine();
        builder.append("Latitude:");
        builder.append((Component)this.latitude);
        builder.append("degrees");
        builder.nextLine();
        builder.append("Scale:");
        builder.append((Component)this.scale);
        builder.append("m/pixel");
        builder.nextLine();
        builder.appendSeparator("Options");
        builder.append("Line:");
        builder.append((Component)this.mapLine);
        builder.nextLine();
        builder.append("Refresh Interval:");
        builder.append((Component)this.refreshInterval);
        builder.append(" seconds");
        builder.nextLine();
        builder.append("Channel Labels:");
        builder.append((Component)this.noLabels);
        builder.nextLine();
        builder.append(" ");
        builder.append((Component)this.someLabels);
        builder.nextLine();
        builder.append(" ");
        builder.append((Component)this.allLabels);
        builder.nextLine();
        builder.append("Click Labels:");
        builder.append((Component)this.labelSource, 3);
        this.dialogPanel = builder.getPanel();
        this.mainPanel.add((Component)this.dialogPanel, "Center");
    }

    public static MapSettingsDialog getInstance(MapFrame mf) {
        if (dialog == null) {
            dialog = new MapSettingsDialog();
        }
        dialog.setMapFrame(mf);
        dialog.setToCurrent();
        return dialog;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.getRootPane().setDefaultButton(this.okButton);
        }
        super.setVisible(b);
    }

    public void setMapFrame(MapFrame mf) {
        this.map = mf;
        this.setToCurrent();
    }

    public void setToCurrent() {
        MapPanel panel = this.map.getMapPanel();
        this.longitude.setText(String.format("%.4f", panel.getCenter().x));
        this.latitude.setText(String.format("%.4f", panel.getCenter().y));
        this.scale.setText(String.format("%.1f", panel.getScale()));
        this.lineWidth.setText(Integer.toString(MapSettingsDialog.swarmConfig.mapLineWidth));
        this.refreshInterval.setText(String.format("%.2f", (double)this.map.getRefreshInterval() / 1000.0));
        MapPanel.LabelSetting ls = panel.getLabelSetting();
        switch (ls) {
            case ALL: {
                this.allLabels.setSelected(true);
                break;
            }
            case SOME: {
                this.someLabels.setSelected(true);
                break;
            }
            case NONE: {
                this.noLabels.setSelected(true);
            }
        }
        this.labelSource.setText(MapSettingsDialog.swarmConfig.labelSource);
    }

    @Override
    protected void wasOK() {
        try {
            MapSettingsDialog.swarmConfig.labelSource = this.labelSource.getText();
            MapPanel panel = this.map.getMapPanel();
            MapPanel.LabelSetting ls = MapPanel.LabelSetting.ALL;
            if (this.someLabels.isSelected()) {
                ls = MapPanel.LabelSetting.SOME;
            } else if (this.noLabels.isSelected()) {
                ls = MapPanel.LabelSetting.NONE;
            }
            panel.setLabelSetting(ls);
            Point2D.Double center = new Point2D.Double();
            center.x = Double.parseDouble(this.longitude.getText());
            center.y = Double.parseDouble(this.latitude.getText());
            double sc = Double.parseDouble(this.scale.getText());
            panel.setCenterAndScale(center, sc);
            MapSettingsDialog.swarmConfig.mapLineWidth = Integer.parseInt(this.lineWidth.getText());
            this.map.setRefreshInterval(Math.round(Double.parseDouble(this.refreshInterval.getText()) * 1000.0));
            panel.loadLabels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean allowOK() {
        String message = null;
        try {
            message = "Invalid refresh interval; legal values are between 0 and 3600, 0 to refresh continuously.";
            double ri = Double.parseDouble(this.refreshInterval.getText());
            if (ri < 0.0 || ri > 3600.0) {
                throw new NumberFormatException();
            }
            message = "Invalid longitude; legal values are between -180 and 180.";
            double lon = Double.parseDouble(this.longitude.getText());
            if (lon < -180.0 || lon > 180.0) {
                throw new NumberFormatException();
            }
            message = "Invalid latitude; legal values are between -90 and 90.";
            double lat = Double.parseDouble(this.latitude.getText());
            if (lat < -90.0 || lat > 90.0) {
                throw new NumberFormatException();
            }
            message = "Invalid scale; legal values are greater than 0.";
            double sc = Double.parseDouble(this.scale.getText());
            if (sc <= 0.0) {
                throw new NumberFormatException();
            }
            message = "Invalid line width; legal values are integers greater than 0.";
            int i = Integer.parseInt(this.lineWidth.getText());
            if (i <= 0) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, message, "Options Error", 0);
            return false;
        }
    }
}

