/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.wave;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.swarm.SwarmDialog;
import gov.usgs.swarm.wave.MultiMonitor;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MultiMonitorSettingsDialog
extends SwarmDialog {
    public static final long serialVersionUID = -1L;
    private MultiMonitor monitor;
    private JPanel dialogPanel;
    private JComboBox spanList;
    private JTextField refreshInterval;
    private JTextField slideInterval;
    private static MultiMonitorSettingsDialog dialog;

    private MultiMonitorSettingsDialog() {
        super(applicationFrame, "Monitor Settings", true);
        this.createUI();
        this.setSizeAndLocation();
    }

    private void createFields() {
        int[] values = MultiMonitor.SPANS;
        String[] spans = new String[values.length];
        for (int i = 0; i < spans.length; ++i) {
            spans[i] = Integer.toString(values[i]);
        }
        this.spanList = new JComboBox<String>(spans);
        this.spanList.setEditable(true);
        this.refreshInterval = new JTextField();
        this.slideInterval = new JTextField();
    }

    @Override
    protected void createUI() {
        super.createUI();
        this.createFields();
        FormLayout layout = new FormLayout("right:max(30dlu;pref), 3dlu, 40dlu, 3dlu, 40dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append("Time Span:");
        builder.append((Component)this.spanList);
        builder.append(" seconds");
        builder.nextLine();
        builder.append("Refresh Interval:");
        builder.append((Component)this.refreshInterval);
        builder.append(" seconds");
        builder.nextLine();
        builder.append("Redraw Interval:");
        builder.append((Component)this.slideInterval);
        builder.append(" seconds");
        builder.nextLine();
        this.dialogPanel = builder.getPanel();
        this.mainPanel.add((Component)this.dialogPanel, "Center");
    }

    public static MultiMonitorSettingsDialog getInstance(MultiMonitor mm) {
        if (dialog == null) {
            dialog = new MultiMonitorSettingsDialog();
        }
        dialog.setMonitor(mm);
        dialog.setToCurrent();
        return dialog;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.getRootPane().setDefaultButton(this.okButton);
        }
        super.setVisible(b);
    }

    public void setMonitor(MultiMonitor mm) {
        this.monitor = mm;
        this.setToCurrent();
    }

    public void setToCurrent() {
        this.slideInterval.setText(Double.toString((double)this.monitor.getSlideInterval() / 1000.0));
        this.refreshInterval.setText(Double.toString((double)this.monitor.getRefreshInterval() / 1000.0));
        String span = Integer.toString(this.monitor.getSpan());
        this.spanList.setSelectedItem(span);
    }

    @Override
    protected void wasOK() {
        try {
            this.monitor.setSpan(Integer.parseInt(this.spanList.getSelectedItem().toString()));
            this.monitor.setRefreshInterval(Math.round(Double.parseDouble(this.refreshInterval.getText()) * 1000.0));
            this.monitor.setSlideInterval(Math.round(Double.parseDouble(this.slideInterval.getText()) * 1000.0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean allowOK() {
        String message = null;
        try {
            message = "Invalid refresh interval; legal values are between 0 and 3600, 0 to refresh continuously.";
            double ri = Double.parseDouble(this.refreshInterval.getText());
            if (ri < 0.0 || ri > 3600.0) {
                throw new NumberFormatException();
            }
            message = "Invalid redraw interval; legal values are between 0 and 3600, 0 to refresh continuously.";
            ri = Double.parseDouble(this.refreshInterval.getText());
            if (ri < 0.0 || ri > 3600.0) {
                throw new NumberFormatException();
            }
            message = "Invalid time span.";
            ri = Integer.parseInt(this.spanList.getSelectedItem().toString());
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, message, "Options Error", 0);
            return false;
        }
    }
}

