/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.swarm.wave;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gov.usgs.math.Butterworth;
import gov.usgs.swarm.SwarmDialog;
import gov.usgs.swarm.wave.WaveViewSettings;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class WaveViewSettingsDialog
extends SwarmDialog {
    private static final long serialVersionUID = 1L;
    private JPanel dialogPanel;
    private static WaveViewSettingsDialog dialog;
    private WaveViewSettings settings;
    private JLabel warningLabel;
    private ButtonGroup viewGroup;
    private JRadioButton waveButton;
    private JCheckBox removeBias;
    private JCheckBox useUnits;
    private JRadioButton spectraButton;
    private JRadioButton spectrogramButton;
    private ButtonGroup waveScaleGroup;
    private JRadioButton waveAutoScale;
    private JRadioButton waveManualScale;
    private JCheckBox waveAutoScaleMemory;
    private JTextField minAmp;
    private JTextField maxAmp;
    private JCheckBox logPower;
    private JCheckBox logFreq;
    private JTextField powerRange;
    private JTextField minFreq;
    private JTextField maxFreq;
    private ButtonGroup spectraScaleGroup;
    private JRadioButton spectraAutoScale;
    private JRadioButton spectraManualScale;
    private JTextField binSize;
    private JTextField nfft;
    private JTextField spectrogramOverlap;
    private ButtonGroup filterGroup;
    private JCheckBox filterEnabled;
    private JRadioButton lowPass;
    private JRadioButton highPass;
    private JRadioButton bandPass;
    private JCheckBox zeroPhaseShift;
    private JTextField corner1;
    private JTextField corner2;
    private JSlider order;
    private int settingsCount;

    private WaveViewSettingsDialog() {
        super(applicationFrame, "Wave Settings", true);
        this.createUI();
        this.setSizeAndLocation();
    }

    public static WaveViewSettingsDialog getInstance(WaveViewSettings s) {
        return WaveViewSettingsDialog.getInstance(s, 1);
    }

    public static WaveViewSettingsDialog getInstance(WaveViewSettings s, int count) {
        if (dialog == null) {
            dialog = new WaveViewSettingsDialog();
        }
        dialog.setSettings(s);
        dialog.setToCurrent();
        dialog.setSettingsCount(count);
        return dialog;
    }

    public void setSettingsCount(int i) {
        this.settingsCount = i;
        if (this.settingsCount > 1) {
            this.warningLabel.setText("You are currently configuring the settings for " + this.settingsCount + " different waves.");
        } else {
            this.warningLabel.setText(" ");
        }
    }

    public void setSettings(WaveViewSettings s) {
        this.settings = s;
    }

    public void setToCurrent() {
        switch (this.settings.viewType) {
            case WAVE: {
                this.waveButton.setSelected(true);
                break;
            }
            case SPECTRA: {
                this.spectraButton.setSelected(true);
                break;
            }
            case SPECTROGRAM: {
                this.spectrogramButton.setSelected(true);
            }
        }
        this.removeBias.setSelected(this.settings.removeBias);
        this.useUnits.setSelected(this.settings.useUnits);
        if (this.settings.autoScaleAmp) {
            this.waveAutoScale.setSelected(true);
        } else {
            this.waveManualScale.setSelected(true);
        }
        this.waveAutoScaleMemory.setSelected(this.settings.autoScaleAmpMemory);
        if (this.settings.autoScalePower) {
            this.spectraAutoScale.setSelected(true);
        } else {
            this.spectraManualScale.setSelected(true);
        }
        this.minAmp.setText(String.format("%.1f", this.settings.minAmp));
        this.maxAmp.setText(String.format("%.1f", this.settings.maxAmp));
        this.powerRange.setText(String.format("%.1f, %.1f", this.settings.minPower, this.settings.maxPower));
        this.binSize.setText(String.format("%.1f", this.settings.binSize));
        this.nfft.setText(String.format("%d", this.settings.nfft));
        this.minFreq.setText(String.format("%.1f", this.settings.minFreq));
        this.maxFreq.setText(String.format("%.1f", this.settings.maxFreq));
        this.logFreq.setSelected(this.settings.logFreq);
        this.logPower.setSelected(this.settings.logPower);
        this.spectrogramOverlap.setText(String.format("%3.0f", this.settings.spectrogramOverlap * 100.0));
        this.filterEnabled.setSelected(this.settings.filterOn);
        switch (this.settings.filter.getType()) {
            case LOWPASS: {
                this.lowPass.setSelected(true);
                this.corner1.setText("0.0");
                this.corner2.setText(String.format("%.1f", this.settings.filter.getCorner1()));
                break;
            }
            case HIGHPASS: {
                this.highPass.setSelected(true);
                this.corner1.setText(String.format("%.1f", this.settings.filter.getCorner1()));
                this.corner2.setText("0.0");
                break;
            }
            case BANDPASS: {
                this.bandPass.setSelected(true);
                this.corner1.setText(String.format("%.1f", this.settings.filter.getCorner1()));
                this.corner2.setText(String.format("%.1f", this.settings.filter.getCorner2()));
            }
        }
        this.order.setValue(this.settings.filter.getOrder());
    }

    private void createComponents() {
        this.warningLabel = new JLabel(" ");
        this.viewGroup = new ButtonGroup();
        this.waveButton = new JRadioButton("Wave");
        this.spectraButton = new JRadioButton("Spectra");
        this.spectrogramButton = new JRadioButton("Spectrogram");
        this.viewGroup.add(this.waveButton);
        this.viewGroup.add(this.spectraButton);
        this.viewGroup.add(this.spectrogramButton);
        this.waveScaleGroup = new ButtonGroup();
        this.removeBias = new JCheckBox("Remove bias");
        this.useUnits = new JCheckBox("Use calibrations");
        this.waveManualScale = new JRadioButton("Manual scale");
        this.waveAutoScale = new JRadioButton("Autoscale");
        this.waveScaleGroup.add(this.waveAutoScale);
        this.waveScaleGroup.add(this.waveManualScale);
        this.waveAutoScaleMemory = new JCheckBox("Persistent rescale");
        this.minAmp = new JTextField(7);
        this.maxAmp = new JTextField(7);
        this.logPower = new JCheckBox("Log power");
        this.logFreq = new JCheckBox("Log frequency");
        this.powerRange = new JTextField(6);
        this.minFreq = new JTextField(4);
        this.maxFreq = new JTextField(4);
        this.spectraScaleGroup = new ButtonGroup();
        this.spectraAutoScale = new JRadioButton("Auto scale");
        this.spectraManualScale = new JRadioButton("Manual scale");
        this.spectraScaleGroup.add(this.spectraAutoScale);
        this.spectraScaleGroup.add(this.spectraManualScale);
        this.binSize = new JTextField(4);
        this.nfft = new JTextField(4);
        this.spectrogramOverlap = new JTextField(4);
        this.filterGroup = new ButtonGroup();
        this.filterEnabled = new JCheckBox("Enabled");
        this.lowPass = new JRadioButton("Low pass");
        this.highPass = new JRadioButton("High pass");
        this.bandPass = new JRadioButton("Band pass");
        this.filterGroup.add(this.lowPass);
        this.filterGroup.add(this.highPass);
        this.filterGroup.add(this.bandPass);
        this.zeroPhaseShift = new JCheckBox("Zero phase shift (doubles order)");
        this.corner1 = new JTextField(7);
        this.corner2 = new JTextField(7);
        this.order = new JSlider(2, 8, 4);
        this.order.setMajorTickSpacing(2);
        this.order.setSnapToTicks(true);
        this.order.createStandardLabels(2);
        this.order.setPaintLabels(true);
    }

    @Override
    protected void createUI() {
        super.createUI();
        this.createComponents();
        FormLayout layout = new FormLayout("left:60dlu, 3dlu, left:60dlu, 3dlu, left:60dlu, 3dlu, left:60dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.appendSeparator("View");
        builder.nextLine();
        builder.append((Component)this.waveButton);
        builder.append((Component)this.spectraButton);
        builder.append((Component)this.spectrogramButton);
        builder.nextLine();
        builder.appendSeparator("Wave Options");
        builder.nextLine();
        builder.append((Component)this.removeBias);
        builder.add((Component)new JLabel("Min. Amplitude:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.minAmp);
        builder.append((Component)this.waveAutoScale);
        builder.nextLine();
        builder.append((Component)this.useUnits);
        builder.add((Component)new JLabel("Max. Amplitude:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.maxAmp);
        builder.append((Component)this.waveManualScale);
        builder.nextLine();
        builder.append((Component)new JLabel(""), 5);
        builder.append((Component)this.waveAutoScaleMemory);
        builder.nextLine();
        builder.appendSeparator("Spectra Options");
        builder.nextLine();
        builder.append((Component)new JLabel(""), 1);
        builder.append((Component)this.logPower);
        builder.append((Component)this.logFreq);
        builder.nextLine();
        builder.appendSeparator("Spectrogram Options");
        builder.nextLine();
        builder.append((Component)new JLabel(""), 1);
        builder.append((Component)this.spectraAutoScale);
        builder.append((Component)this.spectraManualScale);
        builder.nextLine();
        builder.appendRow("center:18dlu");
        builder.add((Component)new JLabel("Min. frequency:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.minFreq);
        builder.add((Component)new JLabel("Window size (s):"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.binSize);
        builder.nextLine();
        builder.appendRow("center:18dlu");
        builder.add((Component)new JLabel("Max. frequency:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.maxFreq);
        builder.add((Component)new JLabel("# of FFT points:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.nfft);
        builder.nextLine();
        builder.appendRow("center:18dlu");
        builder.add((Component)new JLabel("Overlap (%)"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.spectrogramOverlap);
        builder.add((Component)new JLabel("Power range (dB):"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.powerRange);
        builder.nextLine();
        builder.appendSeparator("Butterworth Filter");
        builder.append((Component)this.filterEnabled, 3);
        builder.append((Component)this.zeroPhaseShift, 3);
        builder.nextLine();
        builder.append((Component)this.lowPass, 3);
        builder.add((Component)new JLabel("Min. frequency:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.corner1);
        builder.nextLine();
        builder.append((Component)this.highPass, 3);
        builder.add((Component)new JLabel("Max. frequency:"), cc.xy(builder.getColumn(), builder.getRow(), "right, center"));
        builder.nextColumn(2);
        builder.append((Component)this.corner2);
        builder.nextLine();
        builder.append((Component)this.bandPass, 3);
        builder.add((Component)new JLabel("Order"), cc.xyw(builder.getColumn(), builder.getRow(), 3, "center, center"));
        builder.nextLine();
        builder.appendRow("center:20dlu");
        builder.nextColumn(3);
        builder.append((Component)this.order, 4);
        builder.nextLine();
        builder.append((Component)this.warningLabel, 7);
        builder.nextLine();
        this.dialogPanel = builder.getPanel();
        this.mainPanel.add((Component)this.dialogPanel, "Center");
    }

    @Override
    public boolean allowOK() {
        String message = null;
        try {
            message = "Error in minimum ampitude format.";
            double min = Double.parseDouble(this.minAmp.getText());
            message = "Error in maximum ampitude format.";
            double max = Double.parseDouble(this.maxAmp.getText());
            message = "Minimum amplitude must be less than maximum amplitude.";
            if (min >= max) {
                throw new NumberFormatException();
            }
            message = "Error in minimum frequency format.";
            double minf = Double.parseDouble(this.minFreq.getText());
            message = "Error in maximum frequency format.";
            double maxf = Double.parseDouble(this.maxFreq.getText());
            message = "Minimum frequency must be 0 or above and less than maximum frequency.";
            if (minf < 0.0 || minf >= maxf) {
                throw new NumberFormatException();
            }
            message = "Error in spectrogram overlap format.";
            double so = Double.parseDouble(this.spectrogramOverlap.getText());
            message = "Spectrogram overlap must be between 0 and 95%.";
            if (so < 0.0 || so > 95.0) {
                throw new NumberFormatException();
            }
            message = "Error in minimum Hz format.";
            double c1 = Double.parseDouble(this.corner1.getText());
            message = "Minimum Hz must be 0 or above.";
            if (c1 < 0.0) {
                throw new NumberFormatException();
            }
            message = "Error in maximum Hz format.";
            double c2 = Double.parseDouble(this.corner2.getText());
            message = "Maximum Hz must be 0 or above.";
            if (c2 < 0.0) {
                throw new NumberFormatException();
            }
            message = "Minimum Hz must be less than maximum Hz.";
            if (this.bandPass.isSelected() && c1 >= c2) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, message, "Options Error", 0);
            return false;
        }
    }

    @Override
    public void wasOK() {
        try {
            if (this.waveButton.isSelected()) {
                this.settings.viewType = WaveViewSettings.ViewType.WAVE;
            } else if (this.spectraButton.isSelected()) {
                this.settings.viewType = WaveViewSettings.ViewType.SPECTRA;
            } else if (this.spectrogramButton.isSelected()) {
                this.settings.viewType = WaveViewSettings.ViewType.SPECTROGRAM;
            }
            this.settings.removeBias = this.removeBias.isSelected();
            this.settings.useUnits = this.useUnits.isSelected();
            this.settings.autoScaleAmp = this.waveAutoScale.isSelected();
            this.settings.autoScaleAmpMemory = this.waveAutoScaleMemory.isSelected();
            this.settings.autoScalePower = this.spectraAutoScale.isSelected();
            double newMinPower = Double.parseDouble(this.powerRange.getText().split(",")[0]);
            double newMaxPower = Double.parseDouble(this.powerRange.getText().split(",")[1]);
            if (newMinPower != this.settings.minPower | newMaxPower != this.settings.maxPower) {
                this.settings.minPower = Double.parseDouble(this.powerRange.getText().split(",")[0]);
                this.settings.maxPower = Double.parseDouble(this.powerRange.getText().split(",")[1]);
                this.settings.autoScalePower = false;
            }
            this.settings.minAmp = Double.parseDouble(this.minAmp.getText());
            this.settings.maxAmp = Double.parseDouble(this.maxAmp.getText());
            this.settings.maxFreq = Double.parseDouble(this.maxFreq.getText());
            this.settings.minFreq = Double.parseDouble(this.minFreq.getText());
            if (this.settings.minFreq < 0.0) {
                this.settings.minFreq = 0.0;
            }
            this.settings.binSize = Double.parseDouble(this.binSize.getText());
            this.settings.nfft = Integer.parseInt(this.nfft.getText());
            this.settings.logFreq = this.logFreq.isSelected();
            this.settings.logPower = this.logPower.isSelected();
            this.settings.spectrogramOverlap = Double.parseDouble(this.spectrogramOverlap.getText()) / 100.0;
            if (this.settings.spectrogramOverlap > 0.95 || this.settings.spectrogramOverlap < 0.0) {
                this.settings.spectrogramOverlap = 0.0;
            }
            this.settings.notifyView();
            this.settings.filterOn = this.filterEnabled.isSelected();
            this.settings.zeroPhaseShift = this.zeroPhaseShift.isSelected();
            Butterworth.FilterType ft = null;
            double c1 = 0.0;
            double c2 = 0.0;
            if (this.lowPass.isSelected()) {
                ft = Butterworth.FilterType.LOWPASS;
                c1 = Double.parseDouble(this.corner2.getText());
                c2 = 0.0;
            } else if (this.highPass.isSelected()) {
                ft = Butterworth.FilterType.HIGHPASS;
                c1 = Double.parseDouble(this.corner1.getText());
                c2 = 0.0;
            } else if (this.bandPass.isSelected()) {
                ft = Butterworth.FilterType.BANDPASS;
                c1 = Double.parseDouble(this.corner1.getText());
                c2 = Double.parseDouble(this.corner2.getText());
            }
            this.settings.filter.set(ft, this.order.getValue(), 100.0, c1, c2);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Illegal values.", "Options Error", 0);
        }
    }
}

