/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.wave;

import gov.usgs.plot.data.Wave;
import gov.usgs.plot.render.wave.SliceWaveRenderer;
import gov.usgs.vdx.data.Exportable;

public class SliceWaveExporter
extends SliceWaveRenderer
implements Exportable {
    private double step = 0.0;
    private double time = 0.0;
    private double bias = 0.0;

    public Double[] getNextExportRow() {
        if (this.wave == null) {
            return null;
        }
        double value = 0.0;
        if (this.step == 0.0) {
            this.resetExport();
            this.step = 1.0 / this.wave.getSamplingRate();
            this.time = this.wave.getStartTime();
            if (this.removeBias) {
                this.bias = this.wave.mean();
            }
        }
        if (this.wave.hasNext()) {
            value = this.wave.next();
            this.time += this.step;
            Double[] retval = new Double[]{this.time - this.step, value == (double)Wave.NO_DATA ? Double.valueOf(value) : Double.valueOf(value - this.bias)};
            return retval;
        }
        return null;
    }

    public void resetExport() {
        if (this.wave != null) {
            this.wave.reset();
        }
    }

    public int length() {
        return this.wave.samples();
    }
}

