@ echo off

@rem Set environment variables used by earthworm modules at run-time
@rem ---------------------------------------------------------------
set EW_INSTALLATION=INST_UNKNOWN
set EW_HOME=c:\earthworm
set EW_VERSION=earthworm_7.8
set EW_RUN_DIR=%EW_HOME%\run_working
set EW_PARAMS=%EW_RUN_DIR%\params\
set EW_LOG=%EW_RUN_DIR%\log\
set EW_DATA_DIR=%EW_RUN_DIR%\data\
set SYS_NAME=%COMPUTERNAME%

@rem Set environment variables for Glass compilation
@rem -------------------------------------
set GLASS_DIR=%EW_HOME%\%EW_VERSION%\src\seismic_processing\glass

@rem --------------------------
set TZ=GMT

@rem Set up Visual C++ compilation environment 
@rem ---------------------
@rem call "c:\Program Files\Microsoft Visual Studio\VC98\bin\Vcvars32.bat"
@rem call "c:\Program Files\Microsoft Visual Studio .NET 2003\Vc7\bin\vcvars32.bat"
@rem call "C:\Program Files\Microsoft Visual Studio 8\VC\bin\vcvars32.bat"
@rem call "C:\Program Files (x86)\Microsoft Visual Studio 8\VC\bin\vcvars32.bat"
@rem call "C:\Program Files\Microsoft Visual Studio 10.0\VC\vcvarsall.bat" 
@rem You can compile with Visual Studio 2012 (== VS 11) but you need ntwin32.mak 
@rem which isn't included with Visual Studio 2012, but IS included with Visual 
@rem Studio 2010 which you can still still download from Microsoft at the time of
@rem this writing July 2013. Once you do that you need to add a directory to your
@rem INCLUDE path, see below.
call "C:\Program Files (x86)\Microsoft Visual Studio 11.0\VC\bin\vcvars32.bat"

@rem Set up Intel Fortran compilation environment
@rem ---------------------
@rem call "c:\Program Files\Microsoft Visual Studio\DF98\bin\dfvars.bat"
@rem call "c:\Program Files\Intel\Compiler\Fortran\9.0\IA32\Bin\ifortvars.bat"
@rem "c:\Program Files\Intel\Compiler\Fortran\9.1\IA32\Bin\ifortvars.bat"
@rem call "c:\Program Files (x86)\Intel\Compiler\Fortran\9.1\IA32\Bin\ifortvars.bat"
@rem IBM Visual FORTRAN 11.1 Professional
@rem "c:\Program Files\Intel\Compiler\11.1\060\bin\ifortvars.bat" ia32 vs2008
@rem Intel Composer XE for Windows
call "C:\Program Files (x86)\Intel\Composer XE 2013\bin\ifortvars.bat" ia32 vs2012shell

@rem Set the path
@rem ------------------------------------------------------
set Path=%EW_HOME%\%EW_VERSION%\bin;%Path%;c:\Program Files\keditw;c:\local\bin

@rem Set the include path
@rem -------------------------------------------------------------------------
set INCLUDE=%EW_HOME%\%EW_VERSION%\include;%INCLUDE%
@rem Set the include MySQL path
@rem set INCLUDE=%EW_HOME%\%EW_VERSION%\src\archiving\mole\mysql-connector-c-6.0.2\include;%INCLUDE%
@rem if you are using Visual Studio 2012, and downloaded 2010 so you have the ntwin32.mak
@rem you'll need to use this line to include the directory where ntwin32.mak resides:
set INCLUDE=%EW_HOME%\%EW_VERSION%\src\archiving\mole\mysql-connector-c-6.0.2\include;%INCLUDE%;C:\Program Files (x86)\Microsoft SDKs\Windows\v7.0A\Include
@rem If you want to compile ew2moledb with another MySQL library, then
@rem Set the INCLUDE variable with your own mysql include dir and
@rem copy the library file mysqlclient.lib to the directory
@rem %EW_HOME%\%EW_VERSION%\src\archiving\mole\mysql-connector-c-build\lib

@rem Set the library path
@rem -----------------------------------------------------------------
set WIN_FLUSH_OBJ=commode.obj
set LIB=%EW_HOME%\%EW_VERSION%\lib;%LIB%

@rem -----------------------------------------------------------------
@rem Set extra flags you want for the C compiler here
@rem set GLOBALFLAGS=/D_WINNT /D_INTEL 
@rem you might want to set this NO_DEPRECATE if using Visual Studio 2005
set GLOBALFLAGS=/D_WINNT /D_INTEL /D_CRT_SECURE_NO_DEPRECATE /D_USE_32BIT_TIME_T

@rem Set INIT, the path to the tools.ini file which gets used by
@rem nmake to set global compiler switches
@rem -----------------------------------------------------------------
set INIT=%EW_HOME%\%EW_VERSION%\environment
