      SUBROUTINE HYLIN
C--GIVEN DEPTH & DISTANCE, THIS ROUTINE CALCULATES TRAVEL TIME, ITS
C--DERIVATIVES AND EMERGENCE ANGLES AT THE SOURCE FOR ALL ARRIVALS.
C  USES THE LINV LINEAR GRADIENT (HALFSPACE) CALCULATOR FROM HYPOELLIPSE
      INCLUDE 'common.inc'
      LOGICAL ALTMOD, SALMOD

C--THE FOLLOWING ARE PASSED THRU THE ARRAY A:
C DTDR      !TT DERIV WRT DISTANCE
C DTDZ      !TT DERIV WRT DEPTH
C T      !TRAVEL TIME
C AIN      !ANGLE OF EMERGENCE AT SOURCE

      ALTMOD=MODALT(MOD).GT.0
      SALMOD=MODSAL(MOD).GT.0

C--LOOP OVER ALL ARRIVALS
      DO 280 I=1,M
C--FIND STATION INDEX AND REMOVE KPS AS AN S FLAG
      KI=IND(I)
      KPS=KI/10000
      KI=KI-10000*KPS
      J=KINDX(KI)

C--DETERMINE THE MODEL NO. TO ACTUALLY USE FOR THIS STATION
      MD=MOD
      IF (ALTMOD .AND. JLMOD(J)) MD=MODALT(MOD)
C--SWITCH TO S MODEL
      MDS=MD
      IF (SALMOD .AND. KPS.EQ.1) MD=MODSAL(MDS)

C--STATION DISTANCE
      DX=DIS(KI)
C--STZ IS THE STATION DEPTH IN KM BELOW THE REFERENCE ELEVATION
      STZ=ELEVMX(MD)
      IF (LELEV(MD)) STZ=STZ -0.001*JELEV(J)

C--CALCULATE TRAVEL TIME & DERIVATIVES
C--VST=VELOCITY AT STATION, VEQ=VEL AT EQ (NOT USED)
      CALL LINV(DX,Z1,VREF(MD),VGRAD(MD),T,AIN,DTDR,DTDZ,STZ,VST,VEQ)

C--END OF STATION LOOP
      A(I,1)=AIN
      A(I,2)=T
      A(I,3)=DTDR
280   A(I,4)=DTDZ

      RETURN
      END
