/**EWQuakeAlert generates email messages when receiving HYP2000ARC
 * messages from Earthworm.
 * Copyright (C) 2009 Ruben S. Luis
 * This program is free software: you ca redistribute it an/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be usefull,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with EWQuakeAlert. If not, see <http://www.gnu.org/licenses/>.
 **/
package ewquakealert;

import java.util.Properties;

import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMessage.RecipientType;

public class sendEmail extends Thread{
  String[] recipients;
  String body;
  String subject;
  

  sendEmail(String[] recipients, String subject, String body) {
    this.recipients = recipients;
    this.subject = subject;
    this.body = body;
  }

  public void run() {
    try {
    Message message = new MimeMessage(getSession());

    for(int i=0; i<recipients.length; i++) {
        if (recipients[i].length()>0)
            message.addRecipient(RecipientType.TO, new InternetAddress(recipients[i]));
    }
      


    message.addFrom(new InternetAddress[] { new InternetAddress(Configuration.email) });

    message.setSubject(subject);
    message.setContent(body, "text/plain");
    Transport.send(message);
    for (int i=0; i<recipients.length; i++)
        if (recipients[i].length()>0)
            EWQuakeAlertView.println("Email sent to " + recipients[i] + ".");
    }
    catch (Exception e) {
        EWQuakeAlertView.println("Unable to send email.");
    }
  }

  private Session getSession() {
    Authenticator authenticator = new Authenticator();

    Properties properties = new Properties();
    properties.setProperty("mail.smtp.submitter", authenticator.getPasswordAuthentication().getUserName());
    properties.setProperty("mail.smtp.auth", "true");

    properties.setProperty("mail.smtp.host", Configuration.host);
    properties.setProperty("mail.smtp.port", "25");

    return Session.getInstance(properties, authenticator);
  }

  private class Authenticator extends javax.mail.Authenticator {
    private PasswordAuthentication authentication;

    public Authenticator() {
      String username = Configuration.username;
      String password = Configuration.password;
      authentication = new PasswordAuthentication(username, password);
    }

    protected PasswordAuthentication getPasswordAuthentication() {
      return authentication;
    }
  }
}
