package pickstatistics;

import java.util.Locale;
import javax.swing.table.AbstractTableModel;

public class StatTableModel extends AbstractTableModel {

    private String[] columnNames = new String[]{"Channel","Average Pick Count"};
    private Object[][] data;

    StatTableModel(StationGroup stations) {
        if (stations==null) {
            data = new Object[0][2];
            return;
        }
        //Calculate data
        data = new Object[stations.size()][2];
        for (int i=0, m=stations.size(); i<m; i++) {
            data[i][0] = stations.get(i).getSCNLString();
            //data[i][1] = String.format(Locale.UK, "%8.1f", stations.get(i).getAverage());
            data[i][1] = stations.get(i).getAverage();
        }
        
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return data.length;
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        return data[row][col];
    }

    public Class getColumnClass(int c) {
        return getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
        data[row][col] = value;
        fireTableCellUpdated(row, col);
    }
}

