package pickstatistics;

import java.util.ArrayList;
import java.util.Locale;

public class Station extends ArrayList<Bin> {

    private String[] scnl;
    private long duration;

    public Station(String[] scnl, long duration) {
        this.scnl = scnl;
        this.duration = duration;
    }

    public void addPick(long time) {
        long settime = (long) (time / duration) * duration;
        Bin reqbin = findBin(settime);
        if (reqbin == null) {
            this.add(new Bin(settime));
            reqbin = this.get(0);
        }
        reqbin.value++;
    }

    public long[] gettimes() {
        long[] times = new long[this.size()];
        for (int i = 0; i < this.size(); i++) {
            times[i] = this.get(i).starttime;
        }
        return times;
    }

    public int[] getvalues() {
        int[] values = new int[this.size()];
        for (int i = 0; i < this.size(); i++) {
            values[i] = this.get(i).value;
        }
        return values;
    }

    private Bin findBin(long time) {
        long settime = (long) (time / duration) * duration;
        if (this.size() > 0) {
            int pos = (int) ((settime - this.get(0).starttime) / duration);
            if (pos < 0) {
                for (int i = 0; i < -pos; i++) {
                    this.add(0, new Bin(this.get(0).starttime - duration));
                }
                pos = 0;
            } else if (pos >= this.size()) {
                long reftime = this.get(this.size() - 1).starttime + duration;
                for (int i = 0, m = pos - this.size() + 1; i < m; i++) {
                    this.add(new Bin(reftime + i * duration));
                }
            }
            return this.get(pos);
        }
        return null;
    }

    public boolean isSCNL(String[] s) {
        int counter = 0;
        for (int i = 0; i < scnl.length && i < s.length; i++) {
            if (scnl[i].equals(s[i])) {
                counter++;
            } else {
                return false;
            }
        }
        if (counter == scnl.length) {
            return true;
        }
        return false;
    }

    public void printStatistics() {
        for (Bin bin : this) {
            System.out.println(String.format(Locale.UK, "%1$tY.%1$tm.%1$td %1$tH:%1$tM:%1$tS %2$d",
                    bin.starttime, bin.value));
        }
    }

    public String getSCNLString() {
        return scnl[0] + "." + scnl[1] + "." + scnl[2] + "." + scnl[3];
    }

    public double getAverage() {
        double average = 0;
        if (this.size() > 0) {
            for (Bin bin : this) {
                average += bin.value;
            }
            average /= this.size();
        }
        return average;
    }
}

class Bin {

    long starttime;
    int value = 0;

    Bin(long starttime) {
        this.starttime = starttime;
    }
}
