package pickewanalysis;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JFileChooser;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import pickewanalysis.wavesources.WaveSource;

@Root(name = "PickEWAnalysisConfiguration")
public class Configuration extends javax.swing.JDialog {

    public Configuration() {
        initComponents();
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        stationsFileLabel = new javax.swing.JLabel();
        stationsFileField = new javax.swing.JTextField();
        browseButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        sourcesTable = new javax.swing.JTable();
        moveUpButton = new javax.swing.JButton();
        monveDownButton = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        stationsTable = new javax.swing.JTable();
        addButton = new javax.swing.JButton();
        rmvButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("PickEWAnalysis Settings");
        setModal(true);
        setResizable(false);

        stationsFileLabel.setText("Stations File");

        stationsFileField.setText(" ");

        browseButton.setText("Browse");
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        sourcesTable.setAutoCreateRowSorter(true);
        sourcesTable.setFont(new java.awt.Font("Tahoma", 0, 10)); // NOI18N
        sourcesTable.setModel(new SourcesListTableModel(sources));
        sourcesTable.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        sourcesTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                sourcesTableMouseReleased(evt);
            }
        });
        jScrollPane1.setViewportView(sourcesTable);

        moveUpButton.setText("Move Up");
        moveUpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveUpButtonActionPerformed(evt);
            }
        });

        monveDownButton.setText("Move Down");
        monveDownButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                monveDownButtonActionPerformed(evt);
            }
        });

        stationsTable.setAutoCreateRowSorter(true);
        stationsTable.setFont(new java.awt.Font("Tahoma", 0, 10)); // NOI18N
        stationsTable.setModel(new ConfigStationsListTableModel(curSource));
        stationsTable.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(stationsTable);

        addButton.setText("Add");
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        rmvButton.setText("Remove");
        rmvButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rmvButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(stationsFileLabel)
                        .addGap(18, 18, 18)
                        .addComponent(stationsFileField)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(browseButton, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cancelButton, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 246, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(rmvButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(addButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(moveUpButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(monveDownButton))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 350, Short.MAX_VALUE)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(stationsFileLabel)
                    .addComponent(stationsFileField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(browseButton))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(moveUpButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(monveDownButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(addButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(rmvButton))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 339, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 339, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cancelButton)
                    .addComponent(okButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void sourcesTableMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_sourcesTableMouseReleased
        int rowIndex = sourcesTable.convertRowIndexToModel(sourcesTable.getSelectedRow());
        curSource = (WaveSource) ((SourcesListTableModel) sourcesTable.getModel()).getValueAt(rowIndex, 1);
        stationsTable.setModel(new ConfigStationsListTableModel(curSource));
    }//GEN-LAST:event_sourcesTableMouseReleased

    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
        AddSourceDialog sourcediag = new AddSourceDialog(new javax.swing.JFrame(), true);
        sourcediag.setLocationRelativeTo(this);
        sourcediag.setVisible(true);
        if (sourcediag.getSource() != null) {
            //Update sources table model
            SourcesListTableModel sourcesModel = (SourcesListTableModel) sourcesTable.getModel();
            sourcesModel.getSources().add(sourcediag.getSource());
            sourcesModel.fireTableDataChanged();
        }
    }//GEN-LAST:event_addButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        updateTables();
        dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        sources = ((SourcesListTableModel) sourcesTable.getModel()).getSources();
        updateTables();
        if (tempStationsFile != null) {
            StationsFile = tempStationsFile;
        }
        try {
            save(configFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed

    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        JFileChooser filechooser = new JFileChooser();
        filechooser.setCurrentDirectory(new File("./"));
        int aux = filechooser.showOpenDialog(null);
        if (aux == JFileChooser.APPROVE_OPTION) {
            File selectedfile = filechooser.getSelectedFile();
            if (selectedfile != null) {
                tempStationsFile = selectedfile.getAbsolutePath();
                stationsFileField.setText(selectedfile.getAbsolutePath());
            }
        }
    }//GEN-LAST:event_browseButtonActionPerformed

    private void rmvButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rmvButtonActionPerformed
        int rowIndex = sourcesTable.convertRowIndexToModel(sourcesTable.getSelectedRow());
        if (rowIndex == -1) {
            return;
        }
        SourcesListTableModel sourcesModel = (SourcesListTableModel) sourcesTable.getModel();
        sourcesModel.getSources().remove(rowIndex);
        sourcesModel.fireTableDataChanged();
        curSource = null;
        ((ConfigStationsListTableModel) stationsTable.getModel()).fireTableDataChanged();
    }//GEN-LAST:event_rmvButtonActionPerformed

    private void moveUpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_moveUpButtonActionPerformed
        int rowIndex = sourcesTable.convertRowIndexToModel(sourcesTable.getSelectedRow());
        if (rowIndex <= 0) {
            return;
        }
        SourcesListTableModel sourcesModel = (SourcesListTableModel) sourcesTable.getModel();
        List<WaveSource> xsources = sourcesModel.getSources();
        WaveSource selected = xsources.get(rowIndex);
        xsources.remove(rowIndex);
        xsources.add(rowIndex - 1, selected);
        sourcesModel.fireTableDataChanged();
        sourcesTable.setRowSelectionInterval(rowIndex - 1, rowIndex - 1);
    }//GEN-LAST:event_moveUpButtonActionPerformed

    private void monveDownButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_monveDownButtonActionPerformed
        int rowIndex = sourcesTable.convertRowIndexToModel(sourcesTable.getSelectedRow());
        if (rowIndex == sourcesTable.getRowCount() - 1) {
            return;
        }
        SourcesListTableModel sourcesModel = (SourcesListTableModel) sourcesTable.getModel();
        List<WaveSource> xsources = sourcesModel.getSources();
        WaveSource selected = xsources.get(rowIndex);
        xsources.remove(rowIndex);
        xsources.add(rowIndex + 1, selected);
        sourcesModel.fireTableDataChanged();
        sourcesTable.setRowSelectionInterval(rowIndex + 1, rowIndex + 1);
    }//GEN-LAST:event_monveDownButtonActionPerformed

    //Method to load a configuration file
    public static Configuration load(String filename) throws Exception {
        Serializer serializer = new Persister();
        Configuration newConfig = serializer.read(Configuration.class, new File(filename));
        newConfig.updateSources();
        newConfig.configFile = filename;
        return newConfig;
    }
    
    //Method to save this configuration onto a file
    public void save(String filename) throws Exception {
        Serializer serializer = new Persister();
        serializer.write(this, new File(filename));
    }

    public void updateSources() {
        //Update current sources, if any
        for (WaveSource source : sources) {
            try {
                source.update();
            } catch (Exception e) {
                new ErrorDialog("Unable to update source: " + e.getMessage(), "Error", null, true).setVisible(true);
                e.printStackTrace();
            }
        }
        if (!sources.isEmpty()) {
            curSource = sources.get(0);
        }
    }

    public void updateTables() {
        sourcesTable.setModel(new SourcesListTableModel(sources));
        if (!sources.isEmpty()) {
            curSource = sources.get(0);
        } else {
            curSource = null;
        }
        stationsTable.setModel(new ConfigStationsListTableModel(curSource));
    }

    @Override
    public void setVisible(boolean b) {
        stationsFileField.setText(StationsFile);
        updateSources();
        updateTables();
        super.setVisible(b);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JButton browseButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JButton monveDownButton;
    private javax.swing.JButton moveUpButton;
    private javax.swing.JButton okButton;
    private javax.swing.JButton rmvButton;
    private javax.swing.JTable sourcesTable;
    private javax.swing.JTextField stationsFileField;
    private javax.swing.JLabel stationsFileLabel;
    private javax.swing.JTable stationsTable;
    // End of variables declaration//GEN-END:variables
    //Default Configuration
    @Element(required=false)
    public String StationsFile = "";
    @Element
    public int RestartLength = 100;
    @Element
    public int MaxGap = 15;
    @Element
    public int NoCoda = 0;
    @Element(required = false)
    public Date endtime = new Date((long) (System.currentTimeMillis() / 1000) * 1000);
    @Element(required = false)
    public Date starttime = new Date(endtime.getTime() - 60000);
    @Element(required = false)
    public int parameterDisplayMode = PARAMETERS_DEFAULT;
    @ElementList(entry = "WaveSource", inline = true, required=false)
    public List<WaveSource> sources = new ArrayList<WaveSource>();
    //Non-referenced variables
    String configFile;
    WaveSource curSource = null;
    String tempStationsFile;
    //Constants
    public static final int PARAMETERS_DEFAULT = 0;
    public static final int PARAMETERS_FREQUENCY = 1;
}
