package pickewanalysis;

import javax.swing.table.AbstractTableModel;
import pickewanalysis.Configuration;
import pickewanalysis.ewpicker.PickEWStation;
import pickewanalysis.ewpicker.PickEWStationGroup;
import pickewanalysis.wavesources.WaveSource;

public class StationsListTableModel extends AbstractTableModel {

    //Variables
    private PickEWStationGroup stations;
    private boolean[] availableData;
    private String[] columnNames = new String[]{"Station", "Ava"};

    public StationsListTableModel(String stationsFile, Configuration config) {
        try {
            stations = new PickEWStationGroup(stationsFile);
        } catch (Exception e) {
            //Unable to load a valid stations file... create an emtpy one
            stations = new PickEWStationGroup();
        }

        availableData = new boolean[stations.size()];
        for (int i = 0; i < availableData.length; i++) {
            //For each station, check data availability
            availableData[i] = false;
            for (WaveSource source : config.sources) {
                if (source.isSCNL(stations.get(i).stat, stations.get(i).chan,
                        stations.get(i).net, stations.get(i).loc,
                        config.starttime.getTime(), config.endtime.getTime())) {
                    availableData[i] = true;
                    break;
                }
            }
        }
    }
    
    public PickEWStationGroup getStations() {
        return stations;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return stations.size();
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        if (stations.isEmpty()) {
            return null;
        }
        if (col == 0) {
            return stations.get(row);
        }
        return availableData[row];
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0:
                return PickEWStation.class;
            case 1:
                return Boolean.class;
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }
}
