/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LocalSeismogramFunction;
import edu.sc.seis.fissuresUtil.freq.Cmplx;
import edu.sc.seis.fissuresUtil.freq.SeisGramText;

public class ButterworthFilter
extends edu.sc.seis.fissuresUtil.freq.ButterworthFilter
implements LocalSeismogramFunction {
    public ButterworthFilter(SeisGramText localeText, double lowFreqCorner, double highFreqCorner, int numPoles) {
        super(localeText, lowFreqCorner, highFreqCorner, numPoles);
    }

    public ButterworthFilter(SeisGramText localeText, double lowFreqCorner, double highFreqCorner, int numPoles, int filterType) {
        super(localeText, lowFreqCorner, highFreqCorner, numPoles, filterType);
    }

    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws FissuresException {
        float[] fdata = seis.get_as_floats();
        Cmplx[] fftdata = Cmplx.fft(fdata);
        fdata = null;
        double dt = seis.getSampling().getPeriod().convertTo(UnitImpl.SECOND).getValue();
        Cmplx[] filtered = this.apply(dt, fftdata);
        fftdata = null;
        float[] outData = Cmplx.fftInverse(filtered, seis.getNumPoints());
        TimeSeriesDataSel sel = new TimeSeriesDataSel();
        sel.flt_values(outData);
        return new LocalSeismogramImpl((SeismogramAttr)seis, sel);
    }
}

