/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LocalSeismogramFunction;
import java.util.Date;

public class Cut
implements LocalSeismogramFunction {
    private MicroSecondDate begin;
    private MicroSecondDate end;
    public static final UnitImpl SEC_PER_SEC = UnitImpl.divide((UnitImpl)UnitImpl.SECOND, (UnitImpl)UnitImpl.SECOND);

    public Cut(MicroSecondDate begin, MicroSecondDate end) {
        this.begin = begin;
        this.end = end;
    }

    public Cut(RequestFilter request) {
        this(new MicroSecondDate(request.start_time), new MicroSecondDate(request.end_time));
    }

    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws FissuresException {
        if (!this.overlaps(seis)) {
            return null;
        }
        if (seis.getBeginTime().equals((Object)this.getBegin()) && seis.getEndTime().equals((Object)this.getEnd())) {
            return seis;
        }
        int beginIndex = this.getBeginIndex(seis);
        int endIndex = this.getEndIndex(seis);
        return Cut.cut(seis, beginIndex, endIndex);
    }

    public static LocalSeismogramImpl cut(LocalSeismogramImpl seis, int beginIndex, int endIndex) throws FissuresException {
        LocalSeismogramImpl outSeis;
        if (seis.can_convert_to_short()) {
            short[] outS = new short[endIndex - beginIndex];
            short[] inS = seis.get_as_shorts();
            System.arraycopy(inS, beginIndex, outS, 0, endIndex - beginIndex);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outS);
        } else if (seis.can_convert_to_long()) {
            int[] outI = new int[endIndex - beginIndex + 1];
            int[] inI = seis.get_as_longs();
            System.arraycopy(inI, beginIndex, outI, 0, endIndex - beginIndex);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outI);
        } else if (seis.can_convert_to_float()) {
            float[] outF = new float[endIndex - beginIndex + 1];
            float[] inF = seis.get_as_floats();
            System.arraycopy(inF, beginIndex, outF, 0, endIndex - beginIndex);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outF);
        } else {
            double[] outD = new double[endIndex - beginIndex + 1];
            double[] inD = seis.get_as_doubles();
            System.arraycopy(inD, beginIndex, outD, 0, endIndex - beginIndex);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outD);
        }
        outSeis.begin_time = seis.getBeginTime().add((TimeInterval)seis.getSampling().getPeriod().multiplyBy((double)beginIndex)).getFissuresTime();
        return outSeis;
    }

    public boolean overlaps(LocalSeismogramImpl seis) {
        return this.begin.before((Date)seis.getEndTime()) && this.end.after((Date)seis.getBeginTime());
    }

    protected int getEndIndex(LocalSeismogramImpl seis) {
        TimeInterval sampPeriod = seis.getSampling().getPeriod();
        TimeInterval endShift = this.end.subtract(seis.getBeginTime());
        endShift = endShift.divideBy((QuantityImpl)sampPeriod);
        endShift = endShift.convertTo(SEC_PER_SEC);
        int endIndex = (int)Math.floor(endShift.value);
        if (endIndex < 0) {
            endIndex = 0;
        }
        if (endIndex >= seis.getNumPoints()) {
            endIndex = seis.getNumPoints() - 1;
        }
        return endIndex;
    }

    protected int getBeginIndex(LocalSeismogramImpl seis) {
        TimeInterval sampPeriod = seis.getSampling().getPeriod();
        TimeInterval beginShift = this.begin.subtract(seis.getBeginTime());
        beginShift = beginShift.divideBy((QuantityImpl)sampPeriod);
        beginShift = beginShift.convertTo(SEC_PER_SEC);
        int beginIndex = (int)Math.ceil(beginShift.value);
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (beginIndex >= seis.getNumPoints()) {
            beginIndex = seis.getNumPoints() - 1;
        }
        return beginIndex;
    }

    public String toString() {
        return "Cut from " + this.begin + " to " + this.end;
    }

    public MicroSecondDate getBegin() {
        return this.begin;
    }

    public MicroSecondDate getEnd() {
        return this.end;
    }

    public RequestFilter apply(RequestFilter original) {
        RequestFilter result = new RequestFilter();
        result.channel_id = original.channel_id;
        MicroSecondDate filterBegin = new MicroSecondDate(original.start_time);
        MicroSecondDate filterEnd = new MicroSecondDate(original.end_time);
        if (this.begin.after((Date)filterEnd) || this.end.before((Date)filterBegin)) {
            return null;
        }
        result.start_time = this.begin.after((Date)filterBegin) ? this.begin.getFissuresTime() : original.start_time;
        result.end_time = this.end.before((Date)filterEnd) ? this.end.getFissuresTime() : original.end_time;
        return result;
    }
}

