/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.bag.IncompatibleSeismograms;
import java.awt.geom.AffineTransform;

public class Rotate {
    public static LocalSeismogramImpl[] rotateGCP(LocalSeismogramImpl x, Orientation xOrient, LocalSeismogramImpl y, Orientation yOrient, Location staLoc, Location evtLoc, String transverseCode, String radialCode) throws FissuresException, IncompatibleSeismograms {
        if ((xOrient.azimuth - yOrient.azimuth) % 360.0f != 90.0f) {
            if ((xOrient.azimuth - yOrient.azimuth) % 360.0f == -90.0f) {
                LocalSeismogramImpl tmp = x;
                Orientation tmpOrient = xOrient;
                x = y;
                xOrient = yOrient;
                y = tmp;
                yOrient = tmpOrient;
            } else {
                throw new IncompatibleSeismograms("not 90 deg separation: " + (xOrient.azimuth - yOrient.azimuth) % 360.0f);
            }
        }
        double radialAz = Rotate.getRadialAzimuth(staLoc, evtLoc);
        float[][] data = Rotate.rotate(x, y, Rotate.dtor(radialAz - (double)yOrient.azimuth));
        LocalSeismogramImpl[] out = new LocalSeismogramImpl[2];
        ChannelId xChanId = Rotate.replaceChannelOrientation(y.channel_id, transverseCode);
        out[0] = new LocalSeismogramImpl(x.get_id() + "Transverse", x.begin_time, data[0].length, x.sampling_info, x.y_unit, xChanId, data[0]);
        ChannelId yChanId = Rotate.replaceChannelOrientation(y.channel_id, radialCode);
        out[1] = new LocalSeismogramImpl(y.get_id() + "Radial", y.begin_time, data[1].length, y.sampling_info, y.y_unit, yChanId, data[1]);
        return out;
    }

    public static ChannelId replaceChannelOrientation(ChannelId chanId, String orientation) {
        return new ChannelId(chanId.network_id, chanId.station_code, chanId.site_code, chanId.channel_code.substring(0, 2) + orientation, chanId.begin_time);
    }

    public static float[][] rotateGCP(LocalSeismogramImpl x, LocalSeismogramImpl y, Location staLoc, Location evtLoc) throws FissuresException, IncompatibleSeismograms {
        return Rotate.rotate(x, y, Rotate.dtor(Rotate.getRadialAzimuth(staLoc, evtLoc)));
    }

    public static double getRadialAzimuth(Location staLoc, Location evtLoc) {
        DistAz distAz = new DistAz(staLoc, evtLoc);
        return (180.0 + distAz.getBaz()) % 360.0;
    }

    public static double getTransverseAzimuth(Location staLoc, Location evtLoc) {
        DistAz distAz = new DistAz(staLoc, evtLoc);
        return (270.0 + distAz.getBaz()) % 360.0;
    }

    public static float[][] rotate(LocalSeismogramImpl x, LocalSeismogramImpl y, double radians) throws FissuresException, IncompatibleSeismograms {
        float[][] data = new float[2][];
        float[] temp = x.get_as_floats();
        data[0] = new float[temp.length];
        System.arraycopy(temp, 0, data[0], 0, temp.length);
        temp = y.get_as_floats();
        data[1] = new float[temp.length];
        System.arraycopy(temp, 0, data[1], 0, temp.length);
        Rotate.rotate(data[0], data[1], radians);
        return data;
    }

    public static void rotate(float[] x, float[] y, double radians) throws IncompatibleSeismograms {
        Rotate.rotate(x, y, AffineTransform.getRotateInstance(radians));
    }

    public static void rotate(float[] x, float[] y, AffineTransform affine) throws IncompatibleSeismograms {
        if (x.length != y.length) {
            throw new IncompatibleSeismograms("x and y must have the same length. " + x.length + " " + y.length);
        }
        double[] matrix = new double[4];
        affine.getMatrix(matrix);
        for (int i = 0; i < x.length; ++i) {
            float tempx = x[i];
            float tempy = y[i];
            x[i] = (float)((double)tempx * matrix[0] + (double)tempy * matrix[2]);
            y[i] = (float)((double)tempx * matrix[1] + (double)tempy * matrix[3]);
        }
    }

    public static void rotate(float[] x, float[] y, float[] z, double theta, double phi) {
        throw new RuntimeException("Not implemented yet");
    }

    public static double dtor(double degree) {
        return Math.PI * degree / 180.0;
    }

    public static double rtod(double radian) {
        return radian * 180.0 / Math.PI;
    }
}

