/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.fissuresUtil.bag.LongShortTrigger;
import edu.sc.seis.fissuresUtil.bag.PhaseCut;
import edu.sc.seis.fissuresUtil.bag.PhaseNonExistent;
import edu.sc.seis.fissuresUtil.bag.Statistics;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;

public class SimplePhaseStoN {
    protected String phase;
    protected TimeInterval shortOffsetBegin;
    protected TimeInterval shortOffsetEnd;
    protected TimeInterval longOffsetBegin;
    protected TimeInterval longOffsetEnd;
    protected PhaseCut shortCut;
    protected PhaseCut longCut;
    protected TauPUtil taup;

    public SimplePhaseStoN(String phase, TimeInterval shortOffsetBegin, TimeInterval shortOffsetEnd, TimeInterval longOffsetBegin, TimeInterval longOffsetEnd, TauPUtil taup) throws TauModelException {
        this.phase = phase;
        this.shortOffsetBegin = shortOffsetBegin;
        this.shortOffsetEnd = shortOffsetEnd;
        this.longOffsetBegin = longOffsetBegin;
        this.longOffsetEnd = longOffsetEnd;
        if (shortOffsetBegin == null) {
            throw new NullPointerException("shortOffsetBegin cannot be null");
        }
        if (shortOffsetEnd == null) {
            throw new NullPointerException("shortOffsetEnd cannot be null");
        }
        if (longOffsetBegin == null) {
            throw new NullPointerException("longOffsetBegin cannot be null");
        }
        if (longOffsetEnd == null) {
            throw new NullPointerException("longOffsetEnd cannot be null");
        }
        this.taup = taup;
        this.shortCut = new PhaseCut(taup, phase, shortOffsetBegin, phase, shortOffsetEnd);
        this.longCut = new PhaseCut(taup, phase, longOffsetBegin, phase, longOffsetEnd);
    }

    public SimplePhaseStoN(String phase, TimeInterval shortOffsetBegin, TimeInterval shortOffsetEnd, TimeInterval longOffsetBegin, TimeInterval longOffsetEnd) throws TauModelException {
        this(phase, shortOffsetBegin, shortOffsetEnd, longOffsetBegin, longOffsetEnd, TauPUtil.getTauPUtil("prem"));
    }

    public SimplePhaseStoN(String phase) throws TauModelException {
        this(phase, new TimeInterval(-1.0, UnitImpl.SECOND), new TimeInterval(5.0, UnitImpl.SECOND), new TimeInterval(-100.0, UnitImpl.SECOND), new TimeInterval(-5.0, UnitImpl.SECOND));
    }

    public LongShortTrigger process(Location stationLoc, Origin origin, LocalSeismogramImpl seis) throws FissuresException, TauModelException, PhaseNonExistent {
        LocalSeismogramImpl shortSeis = this.shortCut.cut(stationLoc, origin, seis);
        LocalSeismogramImpl longSeis = this.longCut.cut(stationLoc, origin, seis);
        if (shortSeis == null || longSeis == null) {
            return null;
        }
        Statistics longStat = new Statistics(longSeis);
        double denominator = longStat.stddev();
        Statistics shortStat = new Statistics(shortSeis);
        double numerator = Math.sqrt(shortStat.var(longStat.mean()));
        Arrival[] arrivals = this.taup.calcTravelTimes(stationLoc, origin, new String[]{this.phase});
        MicroSecondDate phaseTime = null;
        MicroSecondDate originTime = new MicroSecondDate(origin.origin_time);
        if (arrivals.length != 0) {
            phaseTime = originTime.add(new TimeInterval(arrivals[0].getTime(), UnitImpl.SECOND));
        }
        TimeInterval sampPeriod = (TimeInterval)seis.getSampling().getPeriod().convertTo(UnitImpl.SECOND);
        int phaseIndex = (int)seis.getBeginTime().subtract(phaseTime).convertTo(UnitImpl.SECOND).divideBy((QuantityImpl)sampPeriod).get_value();
        float ratio = (float)(numerator / denominator);
        return new LongShortTrigger(seis, phaseIndex, ratio, (float)numerator, (float)denominator);
    }
}

