/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.CacheEventDC;
import edu.sc.seis.fissuresUtil.cache.CachePlottableDC;
import edu.sc.seis.fissuresUtil.cache.NSEventDC;
import edu.sc.seis.fissuresUtil.cache.NSPlottableDC;
import edu.sc.seis.fissuresUtil.cache.NSSeismogramDC;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.ProxyEventDC;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.ProxyPlottableDC;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.RetryEventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.RetryEventDC;
import edu.sc.seis.fissuresUtil.cache.RetryPlottableDC;
import edu.sc.seis.fissuresUtil.cache.RetrySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.VestingNetworkDC;
import edu.sc.seis.fissuresUtil.cache.VestingNetworkFinder;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;

public class BulletproofVestFactory {
    protected static int sleepSeconds = 1;
    private static int defaultNumRetry = 3;

    public static ProxyNetworkAccess vestNetworkAccess(NetworkAccess na, VestingNetworkFinder vnf) {
        if (na instanceof ProxyNetworkAccess) {
            return (ProxyNetworkAccess)na;
        }
        return VestingNetworkFinder.vest(na, vnf, BulletproofVestFactory.getDefaultNumRetry());
    }

    public static ProxyEventAccessOperations vestEventAccess(EventAccessOperations eventAccess) {
        return BulletproofVestFactory.vestEventAccess(eventAccess, 3);
    }

    public static ProxyEventAccessOperations vestEventAccess(EventAccessOperations eventAccess, int numRetry) {
        if (eventAccess instanceof CacheEvent) {
            return (ProxyEventAccessOperations)eventAccess;
        }
        RetryEventAccessOperations retry = new RetryEventAccessOperations(eventAccess, numRetry);
        CacheEvent cache = new CacheEvent(retry);
        return cache;
    }

    public static ProxyEventDC vestEventDC(String serverDNS, String serverName, FissuresNamingService fisName) {
        return BulletproofVestFactory.vestEventDC(serverDNS, serverName, fisName, BulletproofVestFactory.getDefaultNumRetry());
    }

    public static ProxyEventDC vestEventDC(String serverDNS, String serverName, FissuresNamingService fisName, int numRetry) {
        NSEventDC ns = new NSEventDC(serverDNS, serverName, fisName);
        RetryEventDC retry = new RetryEventDC(ns, numRetry);
        CacheEventDC cache = new CacheEventDC(retry);
        return cache;
    }

    public static ProxyNetworkDC vestNetworkDC(String serverDNS, String serverName, FissuresNamingService fisName) {
        return new VestingNetworkDC(serverDNS, serverName, fisName);
    }

    public static ProxyNetworkFinder vestNetworkFinder(ProxyNetworkDC netDC) {
        return new VestingNetworkFinder(netDC, BulletproofVestFactory.getDefaultNumRetry());
    }

    public static ProxySeismogramDC vestSeismogramDC(String serverDNS, String serverName, FissuresNamingService fisName) {
        return BulletproofVestFactory.vestSeismogramDC(serverDNS, serverName, fisName, BulletproofVestFactory.getDefaultNumRetry());
    }

    public static ProxySeismogramDC vestSeismogramDC(String serverDNS, String serverName, FissuresNamingService fisName, int numRetry) {
        NSSeismogramDC ns = new NSSeismogramDC(serverDNS, serverName, fisName);
        RetrySeismogramDC retryDC = new RetrySeismogramDC(ns, numRetry);
        return retryDC;
    }

    public static ProxyPlottableDC vestPlottableDC(String serverDNS, String serverName, FissuresNamingService fisName) {
        return BulletproofVestFactory.vestPlottableDC(serverDNS, serverName, fisName, BulletproofVestFactory.getDefaultNumRetry());
    }

    public static ProxyPlottableDC vestPlottableDC(String serverDNS, String serverName, FissuresNamingService fisName, int numRetry) {
        NSPlottableDC ns = new NSPlottableDC(serverDNS, serverName, fisName);
        RetryPlottableDC retry = new RetryPlottableDC(ns, numRetry);
        CachePlottableDC cache = new CachePlottableDC(retry);
        return cache;
    }

    public static int getDefaultNumRetry() {
        return defaultNumRetry;
    }

    public static void setDefaultNumRetry(int defaultNum) {
        defaultNumRetry = defaultNum;
    }

    public static void retrySleep(int count) {
        if (count > 3) {
            try {
                if (count > 10) {
                    Thread.sleep(10 * sleepSeconds * 1000);
                } else {
                    Thread.sleep(sleepSeconds * 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

