/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.Dimension;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfPlottable.PlottableDC;
import edu.iris.Fissures.IfPlottable.PlottableDCOperations;
import edu.iris.Fissures.IfPlottable.PlottableNotAvailable;
import edu.iris.Fissures.IfPlottable.UnsupportedDimension;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.cache.ProxyPlottableDC;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import java.lang.ref.SoftReference;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.log4j.Category;

public class CachePlottableDC
implements ProxyPlottableDC {
    private HashMap dayCache = new HashMap();
    private PlottableDCOperations plottable;
    private static Category logger = Category.getInstance((String)CachePlottableDC.class.getName());

    public CachePlottableDC(PlottableDCOperations plottableDC) {
        this.plottable = plottableDC;
    }

    public boolean custom_sizes() {
        return this.plottable.custom_sizes();
    }

    public Plottable[] get_plottable(RequestFilter request, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension, NotImplemented {
        return this.plottable.get_plottable(request, pixel_size);
    }

    public Dimension[] get_whole_day_sizes() {
        return this.plottable.get_whole_day_sizes();
    }

    public Plottable[] get_for_day(ChannelId channel_id, int year, int jDay, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension {
        Plottable[] plottableArray;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(new Date());
        int todayJDay = calendar.get(6);
        int todayYear = calendar.get(1);
        if (jDay == todayJDay && todayYear == year) {
            return this.plottable.get_for_day(channel_id, year, jDay, pixel_size);
        }
        String key = ChannelIdUtil.toString((ChannelId)channel_id) + "." + Integer.toString(year) + "." + Integer.toString(jDay);
        SoftReference ref = (SoftReference)this.dayCache.get(key);
        if (ref != null) {
            plottableArray = (Plottable[])ref.get();
            if (plottableArray != null) {
                return plottableArray;
            }
            this.dayCache.remove(key);
        }
        plottableArray = this.plottable.get_for_day(channel_id, year, jDay, pixel_size);
        this.dayCache.put(key, new SoftReference<Plottable[]>(plottableArray));
        return plottableArray;
    }

    public Dimension[] get_event_sizes() {
        return this.plottable.get_event_sizes();
    }

    public Plottable[] get_for_event(EventAccess event, ChannelId channel_id, Dimension pixel_size) throws PlottableNotAvailable, UnsupportedDimension {
        return this.plottable.get_for_event(event, channel_id, pixel_size);
    }

    public PlottableDCOperations getWrappedDC() {
        return this.plottable;
    }

    public PlottableDCOperations getWrappedDC(Class wrappedClass) {
        if (this.getWrappedDC().getClass().equals(wrappedClass)) {
            return this.getWrappedDC();
        }
        if (this.getWrappedDC().getClass().equals(ProxySeismogramDC.class)) {
            ((ProxySeismogramDC)this.getWrappedDC()).getWrappedDC(wrappedClass);
        }
        throw new IllegalArgumentException("This doesn't contain a DC of class " + wrappedClass);
    }

    public void reset() {
        this.dayCache.clear();
        if (this.plottable instanceof ProxyPlottableDC) {
            ((ProxyPlottableDC)this.plottable).reset();
        }
    }

    public PlottableDC getCorbaObject() {
        if (this.plottable instanceof PlottableDC) {
            return (PlottableDC)this.plottable;
        }
        if (this.plottable instanceof ProxyPlottableDC) {
            return ((ProxyPlottableDC)this.plottable).getCorbaObject();
        }
        throw new RuntimeException("subplottable not a PlottableDC or ProxyPlottableDC");
    }
}

