/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.omg.CORBA.SystemException;

public class InstrumentationLoader
extends Thread {
    boolean noStopThread = true;
    NumTrysComparator numTrysComparator = new NumTrysComparator();
    private LinkedList queue = new LinkedList();
    static Logger logger = Logger.getLogger((Class)InstrumentationLoader.class);

    public InstrumentationLoader() {
        super("InstrumentationLoader");
    }

    public void run() {
        while (this.noStopThread) {
            WorkUnit nextWork = null;
            try {
                nextWork = this.getFromQueue();
                Instrumentation inst = nextWork.net.retrieve_instrumentation(nextWork.seis.getRequestFilter().channel_id, nextWork.seis.getBeginTime());
                nextWork.seis.addAuxillaryData(StdAuxillaryDataNames.RESPONSE, inst.the_response);
                logger.debug((Object)("added response to dss for " + ChannelIdUtil.toStringNoDates((ChannelId)nextWork.seis.getRequestFilter().channel_id)));
            }
            catch (ChannelNotFound e) {
                logger.debug((Object)("Could not load instrumentation for channel " + ChannelIdUtil.toString((ChannelId)nextWork.seis.getRequestFilter().channel_id) + " at " + nextWork.seis.getBeginTime().date_time));
            }
            catch (SystemException e) {
                ++nextWork.numTries;
                if (nextWork.numTries >= 10) continue;
                this.addToQueue(nextWork);
            }
            catch (Throwable e) {
                GlobalExceptionHandler.handle("A problem occured loading the instrumentation for channel " + ChannelIdUtil.toString((ChannelId)nextWork.seis.getRequestFilter().channel_id), e);
            }
        }
    }

    public static void repairResponse(Response resp) throws InvalidResponse {
        if (InstrumentationLoader.isValid(resp)) {
            return;
        }
        logger.info((Object)"response is not valid, repairing");
        Stage[] stages = resp.stages;
        float sensitivity = stages[0].the_gain.gain_factor;
        for (int i = 1; i < stages.length; ++i) {
            if (stages[i - 1].the_gain.frequency != stages[i].the_gain.frequency && stages[i].the_gain.frequency != 0.0f) {
                throw new InvalidResponse("No sensitivity and different frequencies in the stages of the response. Stage 0=" + stages[0].the_gain.frequency + "  stage " + i + "= " + stages[i].the_gain.frequency);
            }
            sensitivity *= stages[i].the_gain.gain_factor;
        }
        resp.the_sensitivity.sensitivity_factor = sensitivity;
        resp.the_sensitivity.frequency = stages[0].the_gain.frequency;
    }

    protected synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    protected synchronized WorkUnit getFromQueue() throws InterruptedException {
        while (this.queue.isEmpty()) {
            this.wait();
        }
        Collections.sort(this.queue, this.numTrysComparator);
        Collections.reverse(this.queue);
        return (WorkUnit)this.queue.removeLast();
    }

    protected synchronized void addToQueue(WorkUnit work) {
        logger.debug((Object)"adding work");
        this.queue.addFirst(work);
        this.notifyAll();
    }

    public void getInstrumentation(DataSetSeismogram seis, NetworkAccess net) {
        this.addToQueue(new WorkUnit(seis, net));
    }

    public static boolean isValid(Sensitivity sens) {
        return sens.frequency >= 0.0f && sens.sensitivity_factor != -1.0f;
    }

    public static boolean isValid(Instrumentation inst) {
        return InstrumentationLoader.isValid(inst.the_response);
    }

    public static boolean isValid(Response resp) {
        return resp.stages.length != 0 && InstrumentationLoader.isValid(resp.the_sensitivity);
    }

    class NumTrysComparator
    implements Comparator {
        NumTrysComparator() {
        }

        public int compare(Object o1, Object o2) {
            WorkUnit wu1 = (WorkUnit)o1;
            WorkUnit wu2 = (WorkUnit)o2;
            if (wu1.numTries < wu2.numTries) {
                return -1;
            }
            if (wu1.numTries > wu2.numTries) {
                return 1;
            }
            return 0;
        }
    }

    class WorkUnit {
        DataSetSeismogram seis;
        NetworkAccess net;
        int numTries = 0;

        WorkUnit(DataSetSeismogram seis, NetworkAccess net) {
            this.seis = seis;
            this.net = net;
        }
    }
}

