/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.RetryNetworkFinder;
import edu.sc.seis.fissuresUtil.cache.SynchronizedNetworkFinder;
import org.apache.log4j.Logger;

public class NSNetworkFinder
extends ProxyNetworkFinder {
    private static Logger logger = Logger.getLogger((Class)NSNetworkFinder.class);
    ProxyNetworkDC netDC;
    private ProxyNetworkFinder finder;

    public NSNetworkFinder(ProxyNetworkDC netDC) {
        this.netDC = netDC;
    }

    private synchronized ProxyNetworkFinder getFinder() {
        if (this.finder == null) {
            this.finder = new RetryNetworkFinder(new SynchronizedNetworkFinder(this.netDC.a_finder()), 3);
        }
        return this.finder;
    }

    public NetworkAccess retrieve_by_id(NetworkId id) throws NetworkNotFound {
        try {
            return this.getFinder().retrieve_by_id(id);
        }
        catch (Throwable e) {
            logger.warn((Object)"Exception in retrieve_by_id(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getFinder().retrieve_by_id(id);
        }
    }

    public NetworkAccess[] retrieve_by_code(String code) throws NetworkNotFound {
        try {
            return this.getFinder().retrieve_by_code(code);
        }
        catch (Throwable e) {
            logger.warn((Object)"Exception in retrieve_by_code(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getFinder().retrieve_by_code(code);
        }
    }

    public NetworkAccess[] retrieve_by_name(String name) throws NetworkNotFound {
        try {
            return this.getFinder().retrieve_by_name(name);
        }
        catch (Throwable e) {
            logger.warn((Object)"Exception in retrieve_by_name(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getFinder().retrieve_by_name(name);
        }
    }

    public NetworkAccess[] retrieve_all() {
        try {
            return this.getFinder().retrieve_all();
        }
        catch (Throwable e) {
            logger.warn((Object)"Exception in retrieve_all(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getFinder().retrieve_all();
        }
    }

    public void reset() {
        this.netDC.reset();
        this.finder = null;
    }

    public boolean hasCorbaObject() {
        return this.getCorbaObject() != null;
    }

    public NetworkFinder getCorbaObject() {
        return this.getFinder().getCorbaObject();
    }
}

