/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfEvent.EventChannelFinder;
import edu.iris.Fissures.IfEvent.EventFinder;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.ProxyEventDC;
import org.apache.log4j.Logger;
import org.omg.CORBA.SystemException;

public class RetryEventDC
extends ProxyEventDC {
    protected int retry;
    private static final Logger logger = Logger.getLogger((Class)RetryEventDC.class);

    public RetryEventDC(ProxyEventDC eventDC, int retry) {
        this.setEventDC(eventDC);
        this.retry = retry;
    }

    public EventFinder a_finder() {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.getEventDC().a_finder();
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((Object)("Caught exception, retrying " + count + " of " + this.retry), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }

    public EventChannelFinder a_channel_finder() {
        SystemException lastException = null;
        for (int count = 0; count < this.retry; ++count) {
            try {
                return this.getEventDC().a_channel_finder();
            }
            catch (SystemException t) {
                lastException = t;
                logger.warn((Object)("Caught exception, retrying " + count + " of " + this.retry), (Throwable)t);
                BulletproofVestFactory.retrySleep(count);
                this.reset();
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException("Out of memory", e);
            }
        }
        throw lastException;
    }
}

