/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.apache.log4j.Category;

public class BestChannelUtil {
    protected static final String[] siteCodeHeuristic = new String[]{"00", "  ", "01"};
    protected static final String[] gainCodeHeuristic = new String[]{"H", "L"};
    protected static final String[] bandCodeHeuristic = new String[]{"L", "B", "S"};
    private static final String[] orientationCodes = new String[]{"Z", "N", "E", "1", "2"};
    static Category logger = Category.getInstance((String)BestChannelUtil.class.getName());

    public static String[] getSiteCodeHeuristic() {
        return siteCodeHeuristic;
    }

    public static String[] getGainCodeHeuristic() {
        return gainCodeHeuristic;
    }

    public static String[] getBandCodeHeuristic() {
        return bandCodeHeuristic;
    }

    public static Channel[] pruneChannels(Channel[] inChan, MicroSecondDate when) {
        LinkedList<Channel> out = new LinkedList<Channel>();
        for (int i = 0; i < inChan.length; ++i) {
            if (!when.before((Date)new MicroSecondDate(inChan[i].effective_time.end_time)) || !when.after((Date)new MicroSecondDate(inChan[i].effective_time.start_time))) continue;
            out.add(inChan[i]);
        }
        return out.toArray(new Channel[0]);
    }

    public static Channel getActiveChannel(Channel[] inChan, Channel current, MicroSecondDate when) {
        for (int i = 0; i < inChan.length; ++i) {
            if (!ChannelIdUtil.toStringNoDates((ChannelId)inChan[i].get_id()).equals(ChannelIdUtil.toStringNoDates((ChannelId)current.get_id())) || !when.before((Date)new MicroSecondDate(inChan[i].effective_time.end_time)) || !when.after((Date)new MicroSecondDate(inChan[i].effective_time.start_time))) continue;
            return inChan[i];
        }
        return null;
    }

    public static Channel getVerticalChannel(Channel[] inChan, String bandCode) {
        return BestChannelUtil.getChannel(inChan, bandCode, "Z");
    }

    public static Channel[] getHorizontalChannels(Channel[] inChan, String bandCode) {
        for (int h = 0; h < siteCodeHeuristic.length; ++h) {
            Channel east;
            Channel north = BestChannelUtil.getChannel(inChan, bandCode, "N", siteCodeHeuristic[h]);
            if (north != null && (east = BestChannelUtil.getChannelForOrientation(inChan, "E", north)) != null) {
                return new Channel[]{north, east};
            }
            north = BestChannelUtil.getChannel(inChan, bandCode, "1");
            if (north == null || (east = BestChannelUtil.getChannelForOrientation(inChan, "2", north)) == null) continue;
            return new Channel[]{north, east};
        }
        return null;
    }

    private static Channel getChannelForOrientation(Channel[] group, String orientation, Channel matchThis) {
        return BestChannelUtil.getChannel(group, BestChannelUtil.getBand(matchThis), orientation, matchThis.my_site.get_code(), BestChannelUtil.getGain(matchThis));
    }

    public static String getBand(Channel chan) {
        return BestChannelUtil.getBand(chan.get_code());
    }

    public static String getBand(String channelCode) {
        return channelCode.substring(0, 1);
    }

    public static String getGain(Channel chan) {
        return BestChannelUtil.getGain(chan.get_code());
    }

    public static String getGain(String channelCode) {
        return channelCode.substring(1, 2);
    }

    public static String getOrientation(Channel chan) {
        return BestChannelUtil.getOrientation(chan.get_code());
    }

    public static String getOrientation(String channelCode) {
        return channelCode.substring(2, 3);
    }

    public static Channel[] getChannels(Channel[] staChans, String bc) {
        ArrayList<Channel> results = new ArrayList<Channel>();
        for (int i = 0; i < orientationCodes.length; ++i) {
            String orientation = orientationCodes[i];
            Channel chan = BestChannelUtil.getChannel(staChans, bc, orientation);
            if (chan == null) continue;
            results.add(chan);
            for (int j = 0; j < orientationCodes.length; ++j) {
                Channel additional;
                String subOrient = orientationCodes[j];
                if (subOrient.equals(orientation) || (additional = BestChannelUtil.getChannelForOrientation(staChans, subOrient, chan)) == null) continue;
                results.add(additional);
            }
            break;
        }
        return results.toArray(new Channel[0]);
    }

    public static Channel getChannel(Channel[] inChan, String bandCode, String orientationCode) {
        for (int h = 0; h < siteCodeHeuristic.length; ++h) {
            Channel tmpChannel = BestChannelUtil.getChannel(inChan, bandCode, orientationCode, siteCodeHeuristic[h]);
            if (tmpChannel == null) continue;
            return tmpChannel;
        }
        return null;
    }

    public static Channel getChannel(Channel[] inChan, String bandCode, String orientationCode, String siteCode) {
        for (int i = 0; i < gainCodeHeuristic.length; ++i) {
            Channel tmp = BestChannelUtil.getChannel(inChan, bandCode, orientationCode, siteCode, gainCodeHeuristic[i]);
            if (tmp == null) continue;
            return tmp;
        }
        for (int chanNum = 0; chanNum < inChan.length; ++chanNum) {
            if (!inChan[chanNum].get_id().site_code.equals(siteCode) || !inChan[chanNum].get_code().endsWith(orientationCode) || !inChan[chanNum].get_code().startsWith(bandCode)) continue;
            return inChan[chanNum];
        }
        return null;
    }

    public static Channel getChannel(Channel[] inChan, String bandCode, String orientationCode, String siteCode, String gainCode) {
        String desiredChannelCode = bandCode + gainCode + orientationCode;
        for (int chanNum = 0; chanNum < inChan.length; ++chanNum) {
            if (!inChan[chanNum].my_site.get_code().equals(siteCode) || !inChan[chanNum].get_code().equals(desiredChannelCode)) continue;
            return inChan[chanNum];
        }
        return null;
    }
}

