/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.IntervalChooserOptions;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class IntervalChooser
extends JPanel {
    private GridBagConstraints constraints;
    private GridBagLayout bagLayout;
    private JComboBox unitBox;
    private JComboBox valueBox;

    public IntervalChooser() {
        this.initFrame();
        this.setEditable(true);
    }

    public IntervalChooser(IntervalChooserOptions[] options) {
        this.initFrame();
        this.populateUnits(options);
        this.setEditable(true);
    }

    private void initFrame() {
        this.bagLayout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.valueBox = new JComboBox();
        this.unitBox = new JComboBox();
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 1;
        this.setLayout(this.bagLayout);
        this.bagLayout.setConstraints(this.valueBox, this.constraints);
        this.add(this.valueBox);
        ++this.constraints.gridx;
        this.bagLayout.setConstraints(this.unitBox, this.constraints);
        this.add(this.unitBox);
    }

    private void populateValues(IntervalChooserOptions option) {
        int counter;
        for (counter = -100; counter <= -10; counter += 10) {
            this.valueBox.addItem(new String(Integer.toString(counter)));
        }
        for (counter = -9; counter <= 0; ++counter) {
            this.valueBox.addItem(new String(Integer.toString(counter)));
        }
        for (counter = 1; counter <= 10; ++counter) {
            this.valueBox.addItem(new String(Integer.toString(counter)));
        }
        for (counter = 20; counter <= 100; counter += 10) {
            this.valueBox.addItem(new String(Integer.toString(counter)));
        }
    }

    private void populateUnits(IntervalChooserOptions[] options) {
        for (int counter = 0; counter < options.length; ++counter) {
            this.unitBox.addItem(options[counter]);
        }
        this.unitBox.setSelectedIndex(1);
        this.populateValues(options[1]);
        this.valueBox.setSelectedIndex(9);
        this.unitBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                IntervalChooserOptions newSelection = (IntervalChooserOptions)cb.getSelectedItem();
            }
        });
    }

    public void setEditable(boolean bool) {
        this.valueBox.setEditable(bool);
    }

    public void setDefault(int index, IntervalChooserOptions option) {
        this.unitBox.setSelectedItem(option);
        this.valueBox.setSelectedIndex(index + 1);
    }

    public void setSelectedValue(int value) {
        this.valueBox.setSelectedItem(String.valueOf(value));
    }

    public TimeInterval getInterval() {
        int intervalValue;
        TimeInterval interval = null;
        try {
            intervalValue = Integer.parseInt((String)this.valueBox.getSelectedItem());
        }
        catch (NumberFormatException nfe) {
            intervalValue = 0;
        }
        IntervalChooserOptions option = (IntervalChooserOptions)this.unitBox.getSelectedItem();
        int unitValue = option.getIntervalChooserValue();
        if (unitValue == 0) {
            interval = new TimeInterval((double)intervalValue, UnitImpl.SECOND);
        } else if (unitValue == 1) {
            interval = new TimeInterval((double)intervalValue, UnitImpl.MINUTE);
        } else if (unitValue == 2) {
            interval = new TimeInterval((double)intervalValue, UnitImpl.HOUR);
        } else if (unitValue == 3) {
            interval = new TimeInterval((double)intervalValue, UnitImpl.DAY);
        } else if (unitValue == 4) {
            interval = new TimeInterval((double)(intervalValue * 30), UnitImpl.DAY);
        } else if (unitValue == 5) {
            interval = new TimeInterval((double)(intervalValue * 365), UnitImpl.DAY);
        }
        return interval;
    }

    public Date addTo(Date date) {
        int rollBackValue;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        try {
            rollBackValue = Integer.parseInt((String)this.valueBox.getSelectedItem());
        }
        catch (NumberFormatException nfe) {
            rollBackValue = 0;
        }
        IntervalChooserOptions option = (IntervalChooserOptions)this.unitBox.getSelectedItem();
        int unitValue = option.getIntervalChooserValue();
        if (unitValue == 0) {
            calendar.add(13, rollBackValue);
        } else if (unitValue == 1) {
            calendar.add(12, rollBackValue);
        } else if (unitValue == 2) {
            calendar.add(10, rollBackValue);
        } else if (unitValue == 3) {
            calendar.add(6, rollBackValue);
        } else if (unitValue == 4) {
            calendar.add(2, rollBackValue);
        } else if (unitValue == 5) {
            calendar.add(1, rollBackValue);
        }
        return calendar.getTime();
    }
}

