/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Time;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.apache.log4j.Logger;

public class NameListCellRenderer
extends DefaultListCellRenderer {
    boolean useNames;
    boolean useCodes;
    boolean codeIsFirst;
    private static Logger logger = Logger.getLogger((Class)NameListCellRenderer.class);

    public NameListCellRenderer(boolean useNames) {
        this(useNames, !useNames, true);
    }

    public NameListCellRenderer(boolean useNames, boolean useCodes, boolean codeIsFirst) {
        this.useNames = useNames;
        this.useCodes = useCodes;
        this.codeIsFirst = codeIsFirst;
    }

    private String getDisplayString(String name, String code) {
        String out = "";
        if (this.useNames) {
            out = name;
            if (!(name != null && name.length() != 0 || this.useCodes)) {
                out = code;
            }
            if (this.useCodes && this.codeIsFirst) {
                out = code + " - " + out;
            }
            if (this.useCodes && !this.codeIsFirst) {
                out = out + " - " + code;
            }
            return out;
        }
        return code;
    }

    public String getStringToDisplay(Station sta) {
        if (this.useNames) {
            if (this.useCodes) {
                if (this.codeIsFirst) {
                    return NameListCellRenderer.getCodes(sta) + " - " + sta.name;
                }
                return sta.name + " - " + NameListCellRenderer.getCodes(sta);
            }
            return sta.name;
        }
        return NameListCellRenderer.getCodes(sta);
    }

    public static String getCodes(Station sta) {
        return sta.get_id().network_id.network_code + "." + sta.get_code();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String name = "XXXX";
        if (value instanceof NetworkAccess) {
            try {
                String netCode = ((NetworkAccess)value).get_attributes().get_code();
                if (netCode.startsWith("X") || netCode.startsWith("Y") || netCode.startsWith("Z")) {
                    Time start = ((NetworkAccess)value).get_attributes().get_id().begin_time;
                    netCode = netCode + start.date_time.substring(2, 4);
                }
                name = this.getDisplayString(((NetworkAccess)value).get_attributes().name, netCode);
            }
            catch (Throwable e) {
                GlobalExceptionHandler.handle("in renderer for network " + name, e);
            }
        }
        if (value instanceof Station) {
            name = this.getStringToDisplay((Station)value);
        }
        if (value instanceof Site) {
            name = ((Site)value).get_code();
        }
        if (value instanceof Channel) {
            name = this.getDisplayString(((Channel)value).name, ((Channel)value).get_code());
        }
        if (value instanceof String) {
            name = (String)value;
        }
        Component c = super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
        return c;
    }

    public void setUseCodes(boolean useCodes) {
        this.useCodes = useCodes;
    }
}

