/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.Dimension;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.network.ChannelIdUtil;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import org.apache.log4j.Category;

public class SeisTimeFilterSelector {
    static Category logger = Category.getInstance((String)SeisTimeFilterSelector.class.getName());

    public LocalSeismogram[] getFromGivenFilters(DataCenterOperations dataCenter, RequestFilter[] filterseq) throws FissuresException {
        for (int i = 0; i < filterseq.length; ++i) {
            logger.info((Object)("request " + ChannelIdUtil.toString((ChannelId)filterseq[i].channel_id)));
            logger.info((Object)("   from " + filterseq[i].start_time.date_time));
            logger.info((Object)("   to   " + filterseq[i].end_time.date_time));
        }
        LocalSeismogram[] ls = dataCenter.retrieve_seismograms(filterseq);
        logger.info((Object)("Got " + ls.length + " seismograms."));
        return ls;
    }

    public RequestFilter[] makeFiltersGivenChannelId(ChannelId channel_id, int year, int jday, Dimension pixel_size, Time sTime, Time eTime) {
        StringBuffer dayBuffer = new StringBuffer();
        DecimalFormat numberFormat = new DecimalFormat();
        numberFormat.setMinimumIntegerDigits(3);
        numberFormat.format((long)jday, dayBuffer, new FieldPosition(0));
        String startTimeStr = new Integer(year).toString();
        startTimeStr = startTimeStr + dayBuffer + "T00:00:00.000Z";
        Time startTime = sTime;
        String endTimeStr = new Integer(year).toString();
        endTimeStr = endTimeStr + dayBuffer + "T23:59:59.999z";
        Time endTime = eTime;
        TimeRange window = new TimeRange(startTime, endTime);
        RequestFilter[] filters = new RequestFilter[]{new RequestFilter(channel_id, window.start_time, window.end_time)};
        return filters;
    }
}

