/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.database.LocalDataCenterCallBack;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Category;
import org.omg.CORBA.SystemException;

public class DataCenterThread
implements Runnable {
    int retryNum = 3;
    private static RetrievalJob job;
    private SoftReference seisRef = new SoftReference<Object>(null);
    private RequestFilter[] requestFilters;
    private LocalDataCenterCallBack a_client;
    private DataCenterOperations dbDataCenter;
    private Set initiators = Collections.synchronizedSet(new HashSet());
    private static Category logger;
    private boolean finished = false;
    private boolean failed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCenterThread(RequestFilter[] requestFilters, LocalDataCenterCallBack a_client, SeisDataChangeListener initiator, DataCenterOperations dbDataCenter) {
        this.requestFilters = requestFilters;
        this.a_client = a_client;
        Set set = this.initiators;
        synchronized (set) {
            this.initiators.add(initiator);
        }
        this.dbDataCenter = dbDataCenter;
        if (job == null) {
            job = new RetrievalJob();
        }
    }

    public void setRetryNum(int retryNum) {
        this.retryNum = retryNum;
    }

    public int getRetryNum() {
        return this.retryNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JobTracker.getTracker().add(job);
        DataCenterThread.job.incrementRetrievers();
        try {
            LocalSeismogram[] seis = this.retrieveSeis();
            Set set = this.initiators;
            synchronized (set) {
                Iterator it = this.initiators.iterator();
                while (it.hasNext()) {
                    SeisDataChangeListener cur = (SeisDataChangeListener)it.next();
                    this.a_client.pushData(this.castToLocalSeismogramImplArray(seis), cur);
                    this.a_client.finished(cur);
                }
                this.finished = true;
            }
        }
        catch (Throwable e) {
            this.passExceptionToListeners(e);
        }
        DataCenterThread.job.decrementRetrievers();
    }

    private LocalSeismogram[] retrieveSeis() throws FissuresException {
        SystemException lastException = null;
        for (int count = 0; count < this.retryNum; ++count) {
            try {
                return this.dbDataCenter.retrieve_seismograms(this.requestFilters);
            }
            catch (SystemException fe) {
                lastException = fe;
                continue;
            }
        }
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passExceptionToListeners(Throwable t) {
        Set set = this.initiators;
        synchronized (set) {
            this.failed = true;
            Iterator it = this.initiators.iterator();
            while (it.hasNext()) {
                SeisDataChangeListener cur = (SeisDataChangeListener)it.next();
                this.a_client.error(cur, t);
                this.a_client.finished(cur);
            }
        }
    }

    public static void incrementWaiters() {
        DataCenterThread.job.incrementWaiters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getData(SeisDataChangeListener listener, RequestFilter[] requestFilters) {
        LocalSeismogramImpl[] seis;
        for (int i = 0; i < requestFilters.length; ++i) {
            boolean found = false;
            for (int j = 0; j < this.requestFilters.length && !found; ++j) {
                if (requestFilters[i] != this.requestFilters[j]) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        Set i = this.initiators;
        synchronized (i) {
            if (!this.finished) {
                this.initiators.add(listener);
                return true;
            }
        }
        if (this.finished && (seis = (LocalSeismogramImpl[])this.seisRef.get()) != null) {
            this.a_client.pushData(seis, listener);
            this.a_client.finished(listener);
            return true;
        }
        return false;
    }

    private LocalSeismogramImpl[] castToLocalSeismogramImplArray(LocalSeismogram[] seismos) {
        LocalSeismogramImpl[] rtnValues = new LocalSeismogramImpl[seismos.length];
        for (int counter = 0; counter < seismos.length; ++counter) {
            rtnValues[counter] = (LocalSeismogramImpl)seismos[counter];
        }
        return rtnValues;
    }

    static {
        logger = Category.getInstance((String)DataCenterThread.class.getName());
    }

    private class RetrievalJob
    extends AbstractJob {
        private int retrievers;
        private int waiters;

        public RetrievalJob() {
            super("Data Retriever");
            this.retrievers = 0;
            this.waiters = 0;
            this.setFinished();
        }

        private synchronized void incrementWaiters() {
            this.setFinished(false);
            this.setStatus(this.retrievers + " retrieving data " + ++this.waiters + " waiting to retreive");
        }

        private synchronized void incrementRetrievers() {
            this.setFinished(false);
            this.setStatus(++this.retrievers + " retrieving data " + --this.waiters + " waiting to retrieve");
        }

        private synchronized void decrementRetrievers() {
            this.setStatus(--this.retrievers + " retrieving data " + this.waiters + " waiting to retrieve");
            if (this.retrievers == 0 && this.waiters == 0) {
                this.setFinished();
            } else {
                this.setFinished(false);
            }
        }

        public void runJob() {
        }
    }
}

