/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.DBUtil;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.JDBCUnit;
import edu.sc.seis.fissuresUtil.database.NotFound;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class JDBCQuantity {
    private JDBCSequence seq;
    private PreparedStatement get;
    private PreparedStatement put;
    private PreparedStatement getDBId;
    private JDBCUnit jdbcUnit;

    public JDBCQuantity() throws SQLException {
        this(ConnMgr.createConnection());
    }

    public JDBCQuantity(Connection conn) throws SQLException {
        this(new JDBCUnit(conn), conn);
    }

    public JDBCQuantity(JDBCUnit unit, Connection conn) throws SQLException {
        this.jdbcUnit = unit;
        this.seq = new JDBCSequence(conn, "QuantitySeq");
        if (!DBUtil.tableExists("quantity", conn)) {
            conn.createStatement().executeUpdate(ConnMgr.getSQL("quantity.create"));
        }
        this.put = conn.prepareStatement(" INSERT INTO quantity ( quantity_id, quantity_unit_id, quantity_value) VALUES (?,?,?)");
        this.get = conn.prepareStatement(" SELECT quantity_unit_id, quantity_value FROM quantity WHERE quantity_id= ? ");
        this.getDBId = conn.prepareStatement("SELECT quantity_id FROM quantity WHERE  quantity_unit_id = ? AND quantity_value = ?");
    }

    public int put(Quantity quantity) throws SQLException {
        try {
            return this.getDBId(quantity);
        }
        catch (NotFound ex) {
            int id = this.seq.next();
            this.put.setInt(1, id);
            this.insert(quantity, this.put, 2);
            this.put.executeUpdate();
            return id;
        }
    }

    public QuantityImpl get(int dbId) throws SQLException, NotFound {
        this.get.setInt(1, dbId);
        ResultSet rs = this.get.executeQuery();
        if (rs.next()) {
            return new QuantityImpl(rs.getDouble("quantity_value"), this.jdbcUnit.get(rs.getInt("quantity_unit_id")));
        }
        throw new NotFound("No quantity at id " + dbId);
    }

    public int getDBId(Quantity q) throws NotFound, SQLException {
        this.insert(q, this.getDBId, 1);
        ResultSet rs = this.getDBId.executeQuery();
        if (rs.next()) {
            return rs.getInt("quantity_id");
        }
        throw new NotFound(q + " is not in the quantity table");
    }

    public int insert(Quantity quantity, PreparedStatement stmt, int index) throws SQLException {
        stmt.setInt(index++, this.jdbcUnit.put((UnitImpl)quantity.the_units));
        stmt.setDouble(index++, quantity.value);
        return index;
    }

    public QuantityImpl extract(int id, double value) throws SQLException, NotFound {
        return new QuantityImpl(value, this.jdbcUnit.get(id));
    }
}

